/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.metatest;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.model.Statement;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.neo4j.test.rule.CleanupRule;

public class TestCleanupRule {
    @Test
    public void shouldCleanupAutoCloseable() throws Throwable {
        CleanupRule rule = new CleanupRule();
        AutoCloseable toClose = rule.add((AutoCloseable)Mockito.mock(AutoCloseable.class));
        this.simulateTestExecution(rule);
        ((AutoCloseable)Mockito.verify((Object)toClose)).close();
    }

    @Test
    public void shouldCleanupObjectWithAppropriateCloseMethod() throws Throwable {
        CleanupRule rule = new CleanupRule();
        Dirt toClose = (Dirt)rule.add(Mockito.mock(Dirt.class));
        this.simulateTestExecution(rule);
        ((Dirt)Mockito.verify((Object)toClose)).shutdown();
    }

    @Test
    public void shouldCleanupMultipleObjectsInReverseAddedOrder() throws Throwable {
        CleanupRule rule = new CleanupRule();
        AutoCloseable closeable = rule.add((AutoCloseable)Mockito.mock(AutoCloseable.class));
        Dirt dirt = (Dirt)rule.add(Mockito.mock(Dirt.class));
        this.simulateTestExecution(rule);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{dirt, closeable});
        ((Dirt)inOrder.verify((Object)dirt, Mockito.times((int)1))).shutdown();
        ((AutoCloseable)inOrder.verify((Object)closeable, Mockito.times((int)1))).close();
    }

    @Test
    public void shouldTellUserIllegalArgumentIfSo() throws Throwable {
        CleanupRule rule = new CleanupRule();
        try {
            rule.add(new Object());
            Assert.fail((String)"Should not accept this object");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void simulateTestExecution(CleanupRule rule) throws Throwable {
        rule.apply(new Statement(){

            public void evaluate() throws Throwable {
            }
        }, null).evaluate();
    }

    private static interface Dirt {
        public void shutdown();
    }
}

