/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.rule.concurrent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.junit.rules.ExternalResource;
import org.neo4j.function.Predicates;
import org.neo4j.function.ThrowingFunction;
import org.neo4j.helpers.ConcurrentTransfer;
import org.neo4j.test.ReflectionUtil;

public class ThreadingRule
extends ExternalResource {
    private ExecutorService executor;

    protected void before() throws Throwable {
        this.executor = Executors.newCachedThreadPool();
    }

    protected void after() {
        try {
            this.executor.shutdownNow();
            this.executor.awaitTermination(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            this.executor = null;
        }
    }

    public <FROM, TO, EX extends Exception> Future<TO> execute(ThrowingFunction<FROM, TO, EX> function, FROM parameter) {
        Consumer<Thread> threadConsumer = t -> {};
        return this.executor.submit(ThreadingRule.task(function, function.toString(), parameter, threadConsumer));
    }

    public <FROM, TO, EX extends Exception> List<Future<TO>> multiple(int threads, ThrowingFunction<FROM, TO, EX> function, FROM parameter) {
        ArrayList<Future<TO>> result = new ArrayList<Future<TO>>(threads);
        for (int i = 0; i < threads; ++i) {
            result.add(this.executor.submit(ThreadingRule.task(function, function.toString() + ":task=" + i, parameter, t -> {})));
        }
        return result;
    }

    public static <T> List<T> await(Iterable<Future<T>> futures) throws InterruptedException, ExecutionException {
        ArrayList<T> result = futures instanceof Collection ? new ArrayList<T>(((Collection)futures).size()) : new ArrayList();
        ArrayList<Throwable> failures = null;
        for (Future<T> future : futures) {
            try {
                result.add(future.get());
            }
            catch (ExecutionException e) {
                if (failures == null) {
                    failures = new ArrayList<Throwable>();
                }
                failures.add(e.getCause());
            }
        }
        if (failures != null) {
            if (failures.size() == 1) {
                throw new ExecutionException((Throwable)failures.get(0));
            }
            ExecutionException exception = new ExecutionException(null);
            for (Throwable failure : failures) {
                exception.addSuppressed(failure);
            }
            throw exception;
        }
        return result;
    }

    public <FROM, TO, EX extends Exception> Future<TO> executeAndAwait(ThrowingFunction<FROM, TO, EX> function, FROM parameter, Predicate<Thread> threadCondition, long timeout, TimeUnit unit) throws TimeoutException, InterruptedException {
        ConcurrentTransfer transfer = new ConcurrentTransfer();
        Future<TO> future = this.executor.submit(ThreadingRule.task(function, function.toString(), parameter, (Consumer<Thread>)transfer));
        Predicates.await((Supplier)transfer, threadCondition, (long)timeout, (TimeUnit)unit);
        return future;
    }

    private static <FROM, TO, EX extends Exception> Callable<TO> task(ThrowingFunction<FROM, TO, EX> function, String name, FROM parameter, Consumer<Thread> threadConsumer) {
        return () -> {
            Thread thread = Thread.currentThread();
            String previousName = thread.getName();
            thread.setName(name);
            threadConsumer.accept(thread);
            try {
                Object object = function.apply(parameter);
                return object;
            }
            finally {
                thread.setName(previousName);
            }
        };
    }

    public static Predicate<Thread> waitingWhileIn(final Class<?> owner, final String method) {
        return new Predicate<Thread>(){

            @Override
            public boolean test(Thread thread) {
                ReflectionUtil.verifyMethodExists(owner, method);
                if (thread.getState() != Thread.State.WAITING && thread.getState() != Thread.State.TIMED_WAITING) {
                    return false;
                }
                for (StackTraceElement element : thread.getStackTrace()) {
                    if (!element.getClassName().equals(owner.getName()) || !element.getMethodName().equals(method)) continue;
                    return true;
                }
                return false;
            }

            public String toString() {
                return String.format("Predicate[Thread.state=WAITING && thread.getStackTrace() contains %s.%s()]", owner.getName(), method);
            }
        };
    }
}

