/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import java.util.Arrays;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.RecordCursor;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.RecordIdIterator;
import org.neo4j.unsafe.impl.batchimport.StoreWithReservedId;
import org.neo4j.unsafe.impl.batchimport.staging.ReadRecordsStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;

public class ReadRecordsStepTest {
    @Test
    public void reservedIdIsSkipped() {
        long highId = 5L;
        int batchSize = (int)highId;
        Configuration config = Configuration.withBatchSize((Configuration)Configuration.DEFAULT, (int)batchSize);
        NodeStore store = StoreWithReservedId.newNodeStoreMock(highId);
        Mockito.when((Object)store.getHighId()).thenReturn((Object)highId);
        Mockito.when((Object)store.getRecordsPerPage()).thenReturn((Object)10);
        ReadRecordsStep step = new ReadRecordsStep((StageControl)Mockito.mock(StageControl.class), config, (RecordStore)store, RecordIdIterator.allIn((RecordStore)store, (Configuration)config));
        step.start(0);
        Object batch = step.nextBatchOrNull(0L, batchSize);
        Assert.assertNotNull((Object)batch);
        Object[] records = (NodeRecord[])batch;
        boolean hasRecordWithReservedId = Stream.of(records).anyMatch(ReadRecordsStepTest.recordWithReservedId());
        Assert.assertFalse((String)("Batch contains record with reserved id " + Arrays.toString(records)), (boolean)hasRecordWithReservedId);
    }

    @Test
    public void shouldContinueThroughBigIdHoles() throws Exception {
        NodeStore store = (NodeStore)Mockito.mock(NodeStore.class);
        long highId = 100L;
        Mockito.when((Object)store.getHighId()).thenReturn((Object)highId);
        Mockito.when((Object)store.newRecord()).thenReturn((Object)new NodeRecord(-1L));
        Configuration config = Configuration.withBatchSize((Configuration)Configuration.DEFAULT, (int)10);
        Mockito.when((Object)store.newRecordCursor((AbstractBaseRecord)Matchers.any(NodeRecord.class))).thenAnswer(invocation -> new ControlledRecordCursor<NodeRecord>((NodeRecord)invocation.getArguments()[0], record -> {
            record.setInUse(record.getId() < (long)config.batchSize() || record.getId() >= highId - (long)(config.batchSize() / 2));
            return record.inUse() && record.getId() < highId;
        }));
        ReadRecordsStep step = new ReadRecordsStep((StageControl)Mockito.mock(StageControl.class), config, (RecordStore)store, RecordIdIterator.allIn((RecordStore)store, (Configuration)config));
        step.start(0);
        NodeRecord[] first = (NodeRecord[])step.nextBatchOrNull(0L, config.batchSize());
        NodeRecord[] second = (NodeRecord[])step.nextBatchOrNull(1L, config.batchSize());
        NodeRecord[] third = (NodeRecord[])step.nextBatchOrNull(2L, config.batchSize());
        Assert.assertEquals((long)config.batchSize(), (long)first.length);
        Assert.assertEquals((long)0L, (long)first[0].getId());
        Assert.assertEquals((long)(first[0].getId() + (long)config.batchSize() - 1L), (long)first[first.length - 1].getId());
        Assert.assertEquals((long)(config.batchSize() / 2), (long)second.length);
        Assert.assertEquals((long)(highId - 1L), (long)second[second.length - 1].getId());
        Assert.assertNull((Object)third);
    }

    private static Predicate<NodeRecord> recordWithReservedId() {
        return record -> record.getId() == 0xFFFFFFFFL;
    }

    private static class ControlledRecordCursor<RECORD extends AbstractBaseRecord>
    implements RecordCursor<RECORD> {
        private final RECORD record;
        private final Predicate<RECORD> populator;

        public ControlledRecordCursor(RECORD record, Predicate<RECORD> populator) {
            this.record = record;
            this.populator = populator;
        }

        public void close() {
        }

        public RECORD get() {
            return this.record;
        }

        public RecordCursor<RECORD> acquire(long id, RecordLoad mode) {
            return this;
        }

        public void placeAt(long id, RecordLoad mode) {
        }

        public boolean next() {
            throw new UnsupportedOperationException();
        }

        public boolean next(long id) {
            this.record.setId(id);
            return this.populator.test(this.record);
        }

        public boolean next(long id, RECORD record, RecordLoad mode) {
            throw new UnsupportedOperationException();
        }
    }
}

