/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.core.DatabasePanicEventGenerator;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.logging.SimpleLogService;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.configuration.CommunityIdTypeConfigurationProvider;
import org.neo4j.kernel.impl.store.id.configuration.IdTypeConfigurationProvider;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryVersion;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.internal.DatabaseHealth;
import org.neo4j.kernel.lifecycle.LifecycleException;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.Logger;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.rule.NeoStoreDataSourceRule;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class NeoStoreDataSourceTest {
    @Rule
    public EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    @Rule
    public TestDirectory dir = TestDirectory.testDirectory((FileSystemAbstraction)this.fs.get());
    @Rule
    public NeoStoreDataSourceRule dsRule = new NeoStoreDataSourceRule();
    @Rule
    public PageCacheRule pageCacheRule = new PageCacheRule();

    @Test
    public void databaseHealthShouldBeHealedOnStart() throws Throwable {
        NeoStoreDataSource theDataSource = null;
        try {
            DatabaseHealth databaseHealth = new DatabaseHealth((DatabasePanicEventGenerator)Mockito.mock(DatabasePanicEventGenerator.class), NullLogProvider.getInstance().getLog(DatabaseHealth.class));
            theDataSource = this.dsRule.getDataSource(this.dir.graphDbDir(), this.fs.get(), this.pageCacheRule.getPageCache(this.fs.get()), MapUtil.stringMap((String[])new String[0]), databaseHealth);
            databaseHealth.panic(new Throwable());
            theDataSource.start();
            databaseHealth.assertHealthy(Throwable.class);
        }
        finally {
            if (theDataSource != null) {
                theDataSource.stop();
                theDataSource.shutdown();
            }
        }
    }

    @Test
    public void flushOfThePageCacheHappensOnlyOnceDuringShutdown() throws IOException {
        PageCache pageCache = (PageCache)Mockito.spy((Object)this.pageCacheRule.getPageCache(this.fs.get()));
        NeoStoreDataSource ds = this.dsRule.getDataSource(this.dir.graphDbDir(), this.fs.get(), pageCache, MapUtil.stringMap((String[])new String[0]));
        ds.init();
        ds.start();
        ((PageCache)Mockito.verify((Object)pageCache, (VerificationMode)Mockito.never())).flushAndForce();
        ((PageCache)Mockito.verify((Object)pageCache, (VerificationMode)Mockito.never())).flushAndForce((IOLimiter)org.mockito.Matchers.any(IOLimiter.class));
        ds.stop();
        ds.shutdown();
        ((PageCache)Mockito.verify((Object)pageCache)).flushAndForce(IOLimiter.unlimited());
    }

    @Test
    public void flushOfThePageCacheOnShutdownHappensIfTheDbIsHealthy() throws IOException {
        DatabaseHealth health = (DatabaseHealth)Mockito.mock(DatabaseHealth.class);
        Mockito.when((Object)health.isHealthy()).thenReturn((Object)true);
        PageCache pageCache = (PageCache)Mockito.spy((Object)this.pageCacheRule.getPageCache(this.fs.get()));
        NeoStoreDataSource ds = this.dsRule.getDataSource(this.dir.graphDbDir(), this.fs.get(), pageCache, MapUtil.stringMap((String[])new String[0]), health);
        ds.init();
        ds.start();
        ((PageCache)Mockito.verify((Object)pageCache, (VerificationMode)Mockito.never())).flushAndForce();
        ds.stop();
        ds.shutdown();
        ((PageCache)Mockito.verify((Object)pageCache)).flushAndForce(IOLimiter.unlimited());
    }

    @Test
    public void flushOfThePageCacheOnShutdownDoesNotHappenIfTheDbIsUnhealthy() throws IOException {
        DatabaseHealth health = (DatabaseHealth)Mockito.mock(DatabaseHealth.class);
        Mockito.when((Object)health.isHealthy()).thenReturn((Object)false);
        PageCache pageCache = (PageCache)Mockito.spy((Object)this.pageCacheRule.getPageCache(this.fs.get()));
        NeoStoreDataSource ds = this.dsRule.getDataSource(this.dir.graphDbDir(), this.fs.get(), pageCache, MapUtil.stringMap((String[])new String[0]), health);
        ds.init();
        ds.start();
        ((PageCache)Mockito.verify((Object)pageCache, (VerificationMode)Mockito.never())).flushAndForce();
        ds.stop();
        ds.shutdown();
        ((PageCache)Mockito.verify((Object)pageCache, (VerificationMode)Mockito.never())).flushAndForce(IOLimiter.unlimited());
    }

    @Test
    public void shouldLogCorrectTransactionLogDiagnosticsForNoTransactionLogs() throws Exception {
        NeoStoreDataSource dataSource = this.neoStoreDataSourceWithLogFilesContainingLowestTxId(this.noLogs());
        AssertableLogProvider logProvider = new AssertableLogProvider();
        Logger logger = logProvider.getLog(this.getClass()).infoLogger();
        NeoStoreDataSource.Diagnostics.TRANSACTION_RANGE.dump(dataSource, logger);
        logProvider.assertContainsMessageContaining("No transactions");
    }

    @Test
    public void shouldLogCorrectTransactionLogDiagnosticsForTransactionsInOldestLog() throws Exception {
        long logVersion = 2L;
        long prevLogLastTxId = 45L;
        NeoStoreDataSource dataSource = this.neoStoreDataSourceWithLogFilesContainingLowestTxId(this.logWithTransactions(logVersion, prevLogLastTxId));
        AssertableLogProvider logProvider = new AssertableLogProvider();
        Logger logger = logProvider.getLog(this.getClass()).infoLogger();
        NeoStoreDataSource.Diagnostics.TRANSACTION_RANGE.dump(dataSource, logger);
        logProvider.assertContainsMessageContaining("transaction " + (prevLogLastTxId + 1L));
        logProvider.assertContainsMessageContaining("version " + logVersion);
    }

    @Test
    public void shouldLogCorrectTransactionLogDiagnosticsForTransactionsInSecondOldestLog() throws Exception {
        long logVersion = 2L;
        long prevLogLastTxId = 45L;
        NeoStoreDataSource dataSource = this.neoStoreDataSourceWithLogFilesContainingLowestTxId(this.logWithTransactionsInNextToOldestLog(logVersion, prevLogLastTxId));
        AssertableLogProvider logProvider = new AssertableLogProvider();
        Logger logger = logProvider.getLog(this.getClass()).infoLogger();
        NeoStoreDataSource.Diagnostics.TRANSACTION_RANGE.dump(dataSource, logger);
        logProvider.assertContainsMessageContaining("transaction " + (prevLogLastTxId + 1L));
        logProvider.assertContainsMessageContaining("version " + (logVersion + 1L));
    }

    @Test
    public void logModuleSetUpError() throws Exception {
        Config config = Config.embeddedDefaults((Map)MapUtil.stringMap((String[])new String[0]));
        IdGeneratorFactory idGeneratorFactory = (IdGeneratorFactory)Mockito.mock(IdGeneratorFactory.class);
        RuntimeException openStoresError = new RuntimeException("Can't set up modules");
        ((IdGeneratorFactory)Mockito.doThrow((Throwable)openStoresError).when((Object)idGeneratorFactory)).create((File)org.mockito.Matchers.any(File.class), org.mockito.Matchers.anyLong(), org.mockito.Matchers.anyBoolean());
        CommunityIdTypeConfigurationProvider idTypeConfigurationProvider = new CommunityIdTypeConfigurationProvider();
        AssertableLogProvider logProvider = new AssertableLogProvider();
        SimpleLogService logService = new SimpleLogService((LogProvider)logProvider, (LogProvider)logProvider);
        PageCache pageCache = this.pageCacheRule.getPageCache(this.fs.get());
        NeoStoreDataSource dataSource = this.dsRule.getDataSource(this.dir.graphDbDir(), this.fs.get(), idGeneratorFactory, (IdTypeConfigurationProvider)idTypeConfigurationProvider, pageCache, config, (DatabaseHealth)Mockito.mock(DatabaseHealth.class), (LogService)logService);
        try {
            dataSource.start();
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertEquals((Object)openStoresError, (Object)e);
        }
        logProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog(NeoStoreDataSource.class).warn(Matchers.equalTo((Object)"Exception occurred while setting up store modules. Attempting to close things down."), Matchers.equalTo((Object)openStoresError))});
    }

    @Test
    public void shouldAlwaysShutdownLifeEvenWhenCheckPointingFails() throws Exception {
        File storeDir = this.dir.graphDbDir();
        FileSystemAbstraction fs = this.fs.get();
        PageCache pageCache = this.pageCacheRule.getPageCache(fs);
        DatabaseHealth databaseHealth = (DatabaseHealth)Mockito.mock(DatabaseHealth.class);
        Mockito.when((Object)databaseHealth.isHealthy()).thenReturn((Object)true);
        IOException ex = new IOException("boom!");
        ((DatabaseHealth)Mockito.doThrow((Throwable)ex).when((Object)databaseHealth)).assertHealthy(IOException.class);
        NeoStoreDataSource dataSource = this.dsRule.getDataSource(storeDir, fs, pageCache, Collections.emptyMap(), databaseHealth);
        dataSource.start();
        try {
            dataSource.stop();
            Assert.fail((String)"it should have thrown");
        }
        catch (LifecycleException e) {
            Assert.assertEquals((Object)ex, (Object)e.getCause());
        }
    }

    private NeoStoreDataSource neoStoreDataSourceWithLogFilesContainingLowestTxId(PhysicalLogFiles files) {
        DependencyResolver resolver = (DependencyResolver)Mockito.mock(DependencyResolver.class);
        Mockito.when((Object)resolver.resolveDependency(PhysicalLogFiles.class)).thenReturn((Object)files);
        NeoStoreDataSource dataSource = (NeoStoreDataSource)Mockito.mock(NeoStoreDataSource.class);
        Mockito.when((Object)dataSource.getDependencyResolver()).thenReturn((Object)resolver);
        return dataSource;
    }

    private PhysicalLogFiles noLogs() {
        PhysicalLogFiles files = (PhysicalLogFiles)Mockito.mock(PhysicalLogFiles.class);
        Mockito.when((Object)files.getLowestLogVersion()).thenReturn((Object)-1L);
        return files;
    }

    private PhysicalLogFiles logWithTransactions(long logVersion, long headerTxId) throws IOException {
        PhysicalLogFiles files = (PhysicalLogFiles)Mockito.mock(PhysicalLogFiles.class);
        Mockito.when((Object)files.getLowestLogVersion()).thenReturn((Object)logVersion);
        Mockito.when((Object)files.hasAnyEntries(logVersion)).thenReturn((Object)true);
        Mockito.when((Object)files.versionExists(logVersion)).thenReturn((Object)true);
        Mockito.when((Object)files.extractHeader(logVersion)).thenReturn((Object)new LogHeader(LogEntryVersion.CURRENT.byteCode(), logVersion, headerTxId));
        return files;
    }

    private PhysicalLogFiles logWithTransactionsInNextToOldestLog(long logVersion, long prevLogLastTxId) throws IOException {
        PhysicalLogFiles files = this.logWithTransactions(logVersion + 1L, prevLogLastTxId);
        Mockito.when((Object)files.getLowestLogVersion()).thenReturn((Object)logVersion);
        Mockito.when((Object)files.hasAnyEntries(logVersion)).thenReturn((Object)false);
        Mockito.when((Object)files.versionExists(logVersion)).thenReturn((Object)true);
        return files;
    }
}

