/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.DeadSimpleLogVersionRepository;
import org.neo4j.kernel.impl.transaction.DeadSimpleTransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.FlushableChannel;
import org.neo4j.kernel.impl.transaction.log.LogFile;
import org.neo4j.kernel.impl.transaction.log.LogHeaderCache;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.LogVersionRepository;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFile;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.PositionAwarePhysicalFlushableChannel;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.kernel.impl.transaction.log.entry.CheckPoint;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriter;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderWriter;
import org.neo4j.kernel.impl.transaction.log.entry.OnePhaseCommit;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.recovery.DefaultRecoverySPI;
import org.neo4j.kernel.recovery.LatestCheckPointFinder;
import org.neo4j.kernel.recovery.PositionToRecoverFrom;
import org.neo4j.kernel.recovery.Recovery;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class RecoveryTest {
    @Rule
    public final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    @Rule
    public final TestDirectory directory = TestDirectory.testDirectory();
    private final LogVersionRepository logVersionRepository = new DeadSimpleLogVersionRepository(1L);
    private final TransactionIdStore transactionIdStore = new DeadSimpleTransactionIdStore(5L, 0L, 0L, 0L, 0L);
    private final int logVersion = 0;
    private LogEntry lastCommittedTxStartEntry;
    private LogEntry lastCommittedTxCommitEntry;
    private LogEntry expectedStartEntry;
    private LogEntry expectedCommitEntry;
    private LogEntry expectedCheckPointEntry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldRecoverExistingData() throws Exception {
        PhysicalLogFiles logFiles = new PhysicalLogFiles(this.directory.directory(), "log", this.fileSystemRule.get());
        File file = logFiles.getLogFileForVersion(0L);
        this.writeSomeData(file, new Visitor<Pair<LogEntryWriter, Consumer<LogPositionMarker>>, IOException>(){

            public boolean visit(Pair<LogEntryWriter, Consumer<LogPositionMarker>> pair) throws IOException {
                LogEntryWriter writer = (LogEntryWriter)pair.first();
                Consumer consumer = (Consumer)pair.other();
                LogPositionMarker marker = new LogPositionMarker();
                consumer.accept(marker);
                LogPosition lastCommittedTxPosition = marker.newPosition();
                writer.writeStartEntry(0, 1, 2L, 3L, new byte[0]);
                RecoveryTest.this.lastCommittedTxStartEntry = (LogEntry)new LogEntryStart(0, 1, 2L, 3L, new byte[0], lastCommittedTxPosition);
                writer.writeCommitEntry(4L, 5L);
                RecoveryTest.this.lastCommittedTxCommitEntry = (LogEntry)new OnePhaseCommit(4L, 5L);
                writer.writeCheckPointEntry(lastCommittedTxPosition);
                RecoveryTest.this.expectedCheckPointEntry = (LogEntry)new CheckPoint(lastCommittedTxPosition);
                consumer.accept(marker);
                writer.writeStartEntry(0, 1, 6L, 4L, new byte[0]);
                RecoveryTest.this.expectedStartEntry = (LogEntry)new LogEntryStart(0, 1, 6L, 4L, new byte[0], marker.newPosition());
                writer.writeCommitEntry(5L, 7L);
                RecoveryTest.this.expectedCommitEntry = (LogEntry)new OnePhaseCommit(5L, 7L);
                return true;
            }
        });
        LifeSupport life = new LifeSupport();
        Recovery.Monitor monitor = (Recovery.Monitor)Mockito.mock(Recovery.Monitor.class);
        final AtomicBoolean recoveryRequired = new AtomicBoolean();
        try {
            StorageEngine storageEngine = (StorageEngine)Mockito.mock(StorageEngine.class);
            VersionAwareLogEntryReader reader = new VersionAwareLogEntryReader();
            LatestCheckPointFinder finder = new LatestCheckPointFinder(logFiles, this.fileSystemRule.get(), (LogEntryReader)reader);
            LogHeaderCache logHeaderCache = new LogHeaderCache(10);
            TransactionMetadataCache metadataCache = new TransactionMetadataCache(100);
            LogFile logFile = (LogFile)life.add((Lifecycle)new PhysicalLogFile(this.fileSystemRule.get(), logFiles, 50L, () -> this.transactionIdStore.getLastCommittedTransactionId(), this.logVersionRepository, (PhysicalLogFile.Monitor)Mockito.mock(PhysicalLogFile.Monitor.class), logHeaderCache));
            PhysicalLogicalTransactionStore txStore = new PhysicalLogicalTransactionStore(logFile, metadataCache, (LogEntryReader)reader);
            life.add((Lifecycle)new Recovery((Recovery.SPI)new DefaultRecoverySPI(storageEngine, logFiles, this.fileSystemRule.get(), this.logVersionRepository, finder, this.transactionIdStore, (LogicalTransactionStore)txStore, PositionToRecoverFrom.NO_MONITOR){
                private int nr;
                {
                    super(x0, x1, x2, x3, x4, x5, x6, x7);
                    this.nr = 0;
                }

                public Visitor<CommittedTransactionRepresentation, Exception> startRecovery() {
                    recoveryRequired.set(true);
                    final Visitor actual = super.startRecovery();
                    return new Visitor<CommittedTransactionRepresentation, Exception>(){

                        public boolean visit(CommittedTransactionRepresentation tx) throws Exception {
                            actual.visit((Object)tx);
                            switch (nr++) {
                                case 0: {
                                    Assert.assertEquals((Object)RecoveryTest.this.lastCommittedTxStartEntry, (Object)tx.getStartEntry());
                                    Assert.assertEquals((Object)RecoveryTest.this.lastCommittedTxCommitEntry, (Object)tx.getCommitEntry());
                                    break;
                                }
                                case 1: {
                                    Assert.assertEquals((Object)RecoveryTest.this.expectedStartEntry, (Object)tx.getStartEntry());
                                    Assert.assertEquals((Object)RecoveryTest.this.expectedCommitEntry, (Object)tx.getCommitEntry());
                                    break;
                                }
                                default: {
                                    Assert.fail((String)"Too many recovered transactions");
                                }
                            }
                            return false;
                        }
                    };
                }
            }, monitor));
            life.start();
            InOrder order = Mockito.inOrder((Object[])new Object[]{monitor});
            ((Recovery.Monitor)order.verify((Object)monitor, Mockito.times((int)1))).recoveryRequired((LogPosition)Matchers.any(LogPosition.class));
            ((Recovery.Monitor)order.verify((Object)monitor, Mockito.times((int)1))).recoveryCompleted(2);
            Assert.assertTrue((boolean)recoveryRequired.get());
        }
        finally {
            life.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldSeeThatACleanDatabaseShouldNotRequireRecovery() throws Exception {
        PhysicalLogFiles logFiles = new PhysicalLogFiles(this.directory.directory(), "log", this.fileSystemRule.get());
        File file = logFiles.getLogFileForVersion(0L);
        this.writeSomeData(file, new Visitor<Pair<LogEntryWriter, Consumer<LogPositionMarker>>, IOException>(){

            public boolean visit(Pair<LogEntryWriter, Consumer<LogPositionMarker>> pair) throws IOException {
                LogEntryWriter writer = (LogEntryWriter)pair.first();
                Consumer consumer = (Consumer)pair.other();
                LogPositionMarker marker = new LogPositionMarker();
                consumer.accept(marker);
                writer.writeStartEntry(0, 1, 2L, 3L, new byte[0]);
                writer.writeCommitEntry(4L, 5L);
                consumer.accept(marker);
                writer.writeCheckPointEntry(marker.newPosition());
                return true;
            }
        });
        LifeSupport life = new LifeSupport();
        Recovery.Monitor monitor = (Recovery.Monitor)Mockito.mock(Recovery.Monitor.class);
        try {
            StorageEngine storageEngine = (StorageEngine)Mockito.mock(StorageEngine.class);
            VersionAwareLogEntryReader reader = new VersionAwareLogEntryReader();
            LatestCheckPointFinder finder = new LatestCheckPointFinder(logFiles, this.fileSystemRule.get(), (LogEntryReader)reader);
            TransactionMetadataCache metadataCache = new TransactionMetadataCache(100);
            LogHeaderCache logHeaderCache = new LogHeaderCache(10);
            LogFile logFile = (LogFile)life.add((Lifecycle)new PhysicalLogFile(this.fileSystemRule.get(), logFiles, 50L, () -> this.transactionIdStore.getLastCommittedTransactionId(), this.logVersionRepository, (PhysicalLogFile.Monitor)Mockito.mock(PhysicalLogFile.Monitor.class), logHeaderCache));
            PhysicalLogicalTransactionStore txStore = new PhysicalLogicalTransactionStore(logFile, metadataCache, (LogEntryReader)reader);
            life.add((Lifecycle)new Recovery((Recovery.SPI)new DefaultRecoverySPI(storageEngine, logFiles, this.fileSystemRule.get(), this.logVersionRepository, finder, this.transactionIdStore, (LogicalTransactionStore)txStore, PositionToRecoverFrom.NO_MONITOR){

                public Visitor<CommittedTransactionRepresentation, Exception> startRecovery() {
                    Assert.fail((String)"Recovery should not be required");
                    return null;
                }
            }, monitor));
            life.start();
            Mockito.verifyZeroInteractions((Object[])new Object[]{monitor});
        }
        finally {
            life.shutdown();
        }
    }

    @Test
    public void shouldTruncateLogAfterSinglePartialTransaction() throws Exception {
        PhysicalLogFiles logFiles = new PhysicalLogFiles(this.directory.directory(), "log", this.fileSystemRule.get());
        File file = logFiles.getLogFileForVersion(0L);
        final LogPositionMarker marker = new LogPositionMarker();
        this.writeSomeData(file, new Visitor<Pair<LogEntryWriter, Consumer<LogPositionMarker>>, IOException>(){

            public boolean visit(Pair<LogEntryWriter, Consumer<LogPositionMarker>> pair) throws IOException {
                LogEntryWriter writer = (LogEntryWriter)pair.first();
                Consumer consumer = (Consumer)pair.other();
                consumer.accept(marker);
                writer.writeStartEntry(0, 1, 5L, 4L, new byte[0]);
                return true;
            }
        });
        boolean recoveryRequired = this.recover(logFiles);
        Assert.assertTrue((boolean)recoveryRequired);
        Assert.assertEquals((long)marker.getByteOffset(), (long)file.length());
    }

    @Test
    public void shouldTruncateLogAfterLastCompleteTransactionAfterSuccessfullRecovery() throws Exception {
        PhysicalLogFiles logFiles = new PhysicalLogFiles(this.directory.directory(), "log", this.fileSystemRule.get());
        File file = logFiles.getLogFileForVersion(0L);
        final LogPositionMarker marker = new LogPositionMarker();
        this.writeSomeData(file, new Visitor<Pair<LogEntryWriter, Consumer<LogPositionMarker>>, IOException>(){

            public boolean visit(Pair<LogEntryWriter, Consumer<LogPositionMarker>> pair) throws IOException {
                LogEntryWriter writer = (LogEntryWriter)pair.first();
                Consumer consumer = (Consumer)pair.other();
                writer.writeStartEntry(0, 1, 2L, 3L, new byte[0]);
                writer.writeCommitEntry(4L, 5L);
                consumer.accept(marker);
                writer.writeStartEntry(0, 1, 5L, 4L, new byte[0]);
                return true;
            }
        });
        boolean recoveryRequired = this.recover(logFiles);
        Assert.assertTrue((boolean)recoveryRequired);
        Assert.assertEquals((long)marker.getByteOffset(), (long)file.length());
    }

    @Test
    public void shouldTellTransactionIdStoreAfterSuccessfullRecovery() throws Exception {
        PhysicalLogFiles logFiles = new PhysicalLogFiles(this.directory.directory(), "log", this.fileSystemRule.get());
        File file = logFiles.getLogFileForVersion(0L);
        final LogPositionMarker marker = new LogPositionMarker();
        final byte[] additionalHeaderData = new byte[]{};
        boolean masterId = false;
        boolean authorId = true;
        long transactionId = 4L;
        long commitTimestamp = 5L;
        this.writeSomeData(file, new Visitor<Pair<LogEntryWriter, Consumer<LogPositionMarker>>, IOException>(){

            public boolean visit(Pair<LogEntryWriter, Consumer<LogPositionMarker>> pair) throws IOException {
                LogEntryWriter writer = (LogEntryWriter)pair.first();
                Consumer consumer = (Consumer)pair.other();
                writer.writeStartEntry(0, 1, 2L, 3L, additionalHeaderData);
                writer.writeCommitEntry(4L, 5L);
                consumer.accept(marker);
                return true;
            }
        });
        boolean recoveryRequired = this.recover(logFiles);
        Assert.assertTrue((boolean)recoveryRequired);
        long[] lastClosedTransaction = this.transactionIdStore.getLastClosedTransaction();
        Assert.assertEquals((long)4L, (long)lastClosedTransaction[0]);
        Assert.assertEquals((long)LogEntryStart.checksum((byte[])additionalHeaderData, (int)0, (int)1), (long)this.transactionIdStore.getLastCommittedTransaction().checksum());
        Assert.assertEquals((long)5L, (long)this.transactionIdStore.getLastCommittedTransaction().commitTimestamp());
        Assert.assertEquals((long)0L, (long)lastClosedTransaction[1]);
        Assert.assertEquals((long)marker.getByteOffset(), (long)lastClosedTransaction[2]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean recover(PhysicalLogFiles logFiles) {
        LifeSupport life = new LifeSupport();
        Recovery.Monitor monitor = (Recovery.Monitor)Mockito.mock(Recovery.Monitor.class);
        final AtomicBoolean recoveryRequired = new AtomicBoolean();
        try {
            StorageEngine storageEngine = (StorageEngine)Mockito.mock(StorageEngine.class);
            VersionAwareLogEntryReader reader = new VersionAwareLogEntryReader();
            LatestCheckPointFinder finder = new LatestCheckPointFinder(logFiles, this.fileSystemRule.get(), (LogEntryReader)reader);
            TransactionMetadataCache metadataCache = new TransactionMetadataCache(100);
            LogHeaderCache logHeaderCache = new LogHeaderCache(10);
            LogFile logFile = (LogFile)life.add((Lifecycle)new PhysicalLogFile(this.fileSystemRule.get(), logFiles, 50L, () -> this.transactionIdStore.getLastCommittedTransactionId(), this.logVersionRepository, (PhysicalLogFile.Monitor)Mockito.mock(PhysicalLogFile.Monitor.class), logHeaderCache));
            PhysicalLogicalTransactionStore txStore = new PhysicalLogicalTransactionStore(logFile, metadataCache, (LogEntryReader)reader);
            life.add((Lifecycle)new Recovery((Recovery.SPI)new DefaultRecoverySPI(storageEngine, logFiles, this.fileSystemRule.get(), this.logVersionRepository, finder, this.transactionIdStore, (LogicalTransactionStore)txStore, PositionToRecoverFrom.NO_MONITOR){

                public Visitor<CommittedTransactionRepresentation, Exception> startRecovery() {
                    recoveryRequired.set(true);
                    return super.startRecovery();
                }
            }, monitor));
            life.start();
        }
        finally {
            life.shutdown();
        }
        return recoveryRequired.get();
    }

    private void writeSomeData(File file, Visitor<Pair<LogEntryWriter, Consumer<LogPositionMarker>>, IOException> visitor) throws IOException {
        try (PhysicalLogVersionedStoreChannel versionedStoreChannel = new PhysicalLogVersionedStoreChannel((StoreChannel)((DefaultFileSystemAbstraction)this.fileSystemRule.get()).open(file, "rw"), 0L, 6);
             PositionAwarePhysicalFlushableChannel writableLogChannel = new PositionAwarePhysicalFlushableChannel((LogVersionedStoreChannel)versionedStoreChannel);){
            LogHeaderWriter.writeLogHeader((FlushableChannel)writableLogChannel, (long)0L, (long)2L);
            Consumer<LogPositionMarker> consumer = marker -> {
                try {
                    writableLogChannel.getCurrentPosition(marker);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            };
            LogEntryWriter first = new LogEntryWriter((FlushableChannel)writableLogChannel);
            visitor.visit((Object)Pair.of((Object)first, consumer));
        }
    }
}

