/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.configuration.ConfigValue;
import org.neo4j.configuration.DocumentedDefaultValue;
import org.neo4j.configuration.Internal;
import org.neo4j.configuration.LoadableConfig;
import org.neo4j.configuration.ReplacedBy;
import org.neo4j.graphdb.config.InvalidSettingException;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.config.SettingValidator;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.BaseConfigurationMigrator;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ConfigurationMigrator;
import org.neo4j.kernel.configuration.ConfigurationValidator;
import org.neo4j.kernel.configuration.Migrator;
import org.neo4j.kernel.configuration.Settings;
import org.neo4j.logging.Log;
import org.neo4j.test.rule.TestDirectory;

public class ConfigTest {
    private static MyMigratingSettings myMigratingSettings = new MyMigratingSettings();
    private static MySettingsWithDefaults mySettingsWithDefaults = new MySettingsWithDefaults();
    @Rule
    public TestDirectory testDirectory = TestDirectory.testDirectory();

    static Config Config() {
        return ConfigTest.Config(Collections.emptyMap());
    }

    static Config Config(Map<String, String> params) {
        return new Config(Optional.empty(), params, s -> {}, Collections.emptyList(), Optional.empty(), Arrays.asList(mySettingsWithDefaults, myMigratingSettings));
    }

    @Test
    public void shouldApplyDefaults() {
        Config config = ConfigTest.Config();
        Assert.assertThat((Object)config.get(MySettingsWithDefaults.hello), (Matcher)CoreMatchers.is((Object)"Hello, World!"));
    }

    @Test
    public void shouldApplyMigrations() {
        Config config = ConfigTest.Config(MapUtil.stringMap((String[])new String[]{"old", "hello!"}));
        Assert.assertThat((Object)config.get(MyMigratingSettings.newer), (Matcher)CoreMatchers.is((Object)"hello!"));
    }

    @Test(expected=InvalidSettingException.class)
    public void shouldNotAllowSettingInvalidValues() {
        ConfigTest.Config(MapUtil.stringMap((String[])new String[]{MySettingsWithDefaults.boolSetting.name(), "asd"}));
        Assert.fail((String)"Expected validation to fail.");
    }

    @Test
    public void shouldBeAbleToAugmentConfig() throws Exception {
        Config config = ConfigTest.Config();
        config.augment(MapUtil.stringMap((String[])new String[]{MySettingsWithDefaults.boolSetting.name(), "false"}));
        config.augment(MapUtil.stringMap((String[])new String[]{MySettingsWithDefaults.hello.name(), "Bye"}));
        Assert.assertThat((Object)config.get(MySettingsWithDefaults.boolSetting), (Matcher)Matchers.equalTo((Object)false));
        Assert.assertThat((Object)config.get(MySettingsWithDefaults.hello), (Matcher)Matchers.equalTo((Object)"Bye"));
    }

    @Test
    public void shouldRetainCustomConfigOutsideNamespaceAndPassOnBufferedLogInWithMethods() throws Exception {
        Log log = (Log)Mockito.mock(Log.class);
        Config first = Config.embeddedDefaults((Map)MapUtil.stringMap((String[])new String[]{"first.jibberish", "bah"}));
        first.setLogger(log);
        Config second = first.withDefaults(MapUtil.stringMap((String[])new String[]{"second.jibberish", "baah"}));
        Config third = second.with(MapUtil.stringMap((String[])new String[]{"third.jibberish", "baaah"}));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{log});
        Assert.assertEquals(Optional.of("bah"), (Object)third.getRaw("first.jibberish"));
        Assert.assertEquals(Optional.of("baah"), (Object)third.getRaw("second.jibberish"));
        Assert.assertEquals(Optional.of("baaah"), (Object)third.getRaw("third.jibberish"));
    }

    @Test
    public void shouldWarnAndDiscardUnknownOptionsInReservedNamespaceAndPassOnBufferedLogInWithMethods() throws Exception {
        Log log = (Log)Mockito.mock(Log.class);
        File confFile = this.testDirectory.file("test.conf");
        Assert.assertTrue((boolean)confFile.createNewFile());
        Config first = Config.embeddedDefaults(Optional.of(confFile), (Map)MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.strict_config_validation.name(), "false", "ha.jibberish", "baah", "dbms.jibberish", "booh"}));
        first.setLogger(log);
        first.with(MapUtil.stringMap((String[])new String[]{"causal_clustering.jibberish", "baah"}));
        ((Log)Mockito.verify((Object)log)).warn("Unknown config option: %s", new Object[]{"dbms.jibberish"});
        ((Log)Mockito.verify((Object)log)).warn("Unknown config option: %s", new Object[]{"ha.jibberish"});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{log});
    }

    @Test
    public void shouldLogDeprecationWarnings() throws Exception {
        Log log = (Log)Mockito.mock(Log.class);
        File confFile = this.testDirectory.file("test.conf");
        Assert.assertTrue((boolean)confFile.createNewFile());
        Config config = new Config(Optional.of(confFile), MapUtil.stringMap((String[])new String[]{MySettingsWithDefaults.oldHello.name(), "baah", MySettingsWithDefaults.oldSetting.name(), "booh"}), s -> {}, Collections.emptyList(), Optional.empty(), Arrays.asList(mySettingsWithDefaults, myMigratingSettings));
        config.setLogger(log);
        ((Log)Mockito.verify((Object)log)).warn("%s is deprecated. Replaced by %s", new Object[]{MySettingsWithDefaults.oldHello.name(), MySettingsWithDefaults.hello.name()});
        ((Log)Mockito.verify((Object)log)).warn("%s is deprecated.", new Object[]{MySettingsWithDefaults.oldSetting.name()});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{log});
    }

    @Test
    public void shouldSetInternalParameter() throws Exception {
        Config config = new Config(Optional.empty(), MapUtil.stringMap((String[])new String[]{MySettingsWithDefaults.secretSetting.name(), "false", MySettingsWithDefaults.hello.name(), "ABC"}), s -> {}, Collections.emptyList(), Optional.empty(), Arrays.asList(mySettingsWithDefaults, myMigratingSettings));
        Assert.assertTrue((boolean)((ConfigValue)config.getConfigValues().get(MySettingsWithDefaults.secretSetting.name())).internal());
        Assert.assertFalse((boolean)((ConfigValue)config.getConfigValues().get(MySettingsWithDefaults.hello.name())).internal());
    }

    @Test
    public void shouldSetDocumentedDefaultValue() throws Exception {
        Config config = new Config(Optional.empty(), MapUtil.stringMap((String[])new String[]{MySettingsWithDefaults.secretSetting.name(), "false", MySettingsWithDefaults.hello.name(), "ABC"}), s -> {}, Collections.emptyList(), Optional.empty(), Arrays.asList(mySettingsWithDefaults, myMigratingSettings));
        Assert.assertEquals(Optional.of("<documented default value>"), (Object)((ConfigValue)config.getConfigValues().get(MySettingsWithDefaults.secretSetting.name())).documentedDefaultValue());
        Assert.assertEquals(Optional.empty(), (Object)((ConfigValue)config.getConfigValues().get(MySettingsWithDefaults.hello.name())).documentedDefaultValue());
    }

    @Test
    public void shouldPassOnValidatorsOnWithMethods() throws Exception {
        ConfigurationValidator validator = (ConfigurationValidator)Mockito.spy((Object)new ConfigurationValidator(){

            @Nonnull
            public Map<String, String> validate(@Nonnull Collection<SettingValidator> settingValidators, @Nonnull Map<String, String> rawConfig, @Nonnull Log log, boolean parsingFile) throws InvalidSettingException {
                return rawConfig;
            }
        });
        Config first = Config.embeddedDefaults((Map)MapUtil.stringMap((String[])new String[]{"first.jibberish", "bah"}), Collections.singleton(validator));
        Config second = first.withDefaults(MapUtil.stringMap((String[])new String[]{"second.jibberish", "baah"}));
        second.with(MapUtil.stringMap((String[])new String[]{"third.jibberish", "baah"}));
        ((ConfigurationValidator)Mockito.verify((Object)validator, (VerificationMode)Mockito.times((int)3))).validate((Collection)org.mockito.Matchers.any(), (Map)org.mockito.Matchers.any(), (Log)org.mockito.Matchers.any(), org.mockito.Matchers.anyBoolean());
    }

    public static class MySettingsWithDefaults
    implements LoadableConfig {
        public static final Setting<String> hello = Settings.setting((String)"hello", (Function)Settings.STRING, (String)"Hello, World!");
        public static final Setting<Boolean> boolSetting = Settings.setting((String)"bool_setting", (Function)Settings.BOOLEAN, (String)"true");
        @Internal
        @DocumentedDefaultValue(value="<documented default value>")
        public static final Setting<Boolean> secretSetting = Settings.setting((String)"secret_setting", (Function)Settings.BOOLEAN, (String)"true");
        @Deprecated
        @ReplacedBy(value="hello")
        public static final Setting<String> oldHello = Settings.setting((String)"old_hello", (Function)Settings.STRING, (String)"Hello, Bob");
        @Deprecated
        public static final Setting<String> oldSetting = Settings.setting((String)"some_setting", (Function)Settings.STRING, (String)"Has no replacement");
    }

    public static class MyMigratingSettings
    implements LoadableConfig {
        @Migrator
        public static ConfigurationMigrator migrator = new BaseConfigurationMigrator(){
            {
                this.add((BaseConfigurationMigrator.Migration)new BaseConfigurationMigrator.SpecificPropertyMigration("old", "Old has been replaced by newer!"){

                    public void setValueWithOldSetting(String value, Map<String, String> rawConfiguration) {
                        rawConfiguration.put(newer.name(), value);
                    }
                });
            }
        };
        public static Setting<String> newer = Settings.setting((String)"newer", (Function)Settings.STRING, (String)"");
    }
}

