/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.OperationsFacade;
import org.neo4j.kernel.impl.api.StatementOperationParts;
import org.neo4j.kernel.impl.api.operations.SchemaReadOperations;
import org.neo4j.test.mockito.matcher.KernelExceptionUserMessageMatcher;

@RunWith(value=MockitoJUnitRunner.class)
public class OperationsFacadeTest {
    private final String LABEL1 = "Label1";
    private final String PROP1 = "Prop1";
    private final LabelSchemaDescriptor descriptor = SchemaDescriptorFactory.forLabel((int)1, (int[])new int[]{2});
    @Mock
    private KernelStatement kernelStatement;
    @Mock
    private StatementOperationParts statementOperationParts;
    @Mock
    private SchemaReadOperations schemaReadOperations;
    @InjectMocks
    private OperationsFacade operationsFacade;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void setUp() throws Exception {
        this.operationsFacade.initialize(this.statementOperationParts);
    }

    @Test
    public void testThrowExceptionWhenIndexNotFound() throws SchemaRuleNotFoundException {
        this.setupSchemaReadOperations();
        TokenNameLookup tokenNameLookup = this.getDefaultTokenNameLookup();
        this.expectedException.expect(SchemaRuleNotFoundException.class);
        this.expectedException.expect(new KernelExceptionUserMessageMatcher(tokenNameLookup, "No index was found for :Label1(Prop1)."));
        this.operationsFacade.indexGetForSchema(this.descriptor);
    }

    private SchemaReadOperations setupSchemaReadOperations() {
        SchemaReadOperations readOperations = (SchemaReadOperations)Mockito.mock(SchemaReadOperations.class);
        Mockito.when((Object)this.statementOperationParts.schemaReadOperations()).thenReturn((Object)readOperations);
        return readOperations;
    }

    private TokenNameLookup getDefaultTokenNameLookup() {
        TokenNameLookup tokenNameLookup = (TokenNameLookup)Mockito.mock(TokenNameLookup.class);
        Mockito.when((Object)tokenNameLookup.labelGetName(this.descriptor.getLabelId())).thenReturn((Object)"Label1");
        Mockito.when((Object)tokenNameLookup.propertyKeyGetName(this.descriptor.getPropertyId())).thenReturn((Object)"Prop1");
        return tokenNameLookup;
    }
}

