/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.io.IOException;
import java.util.Collections;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.impl.api.TransactionRepresentationCommitProcess;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.TestableTransactionAppender;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogAppendEvent;
import org.neo4j.storageengine.api.CommandsToApply;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.TransactionApplicationMode;

public class TransactionRepresentationCommitProcessTest {
    private final CommitEvent commitEvent = CommitEvent.NULL;

    @Test
    public void shouldFailWithProperMessageOnAppendException() throws Exception {
        TransactionAppender appender = (TransactionAppender)Mockito.mock(TransactionAppender.class);
        IOException rootCause = new IOException("Mock exception");
        ((TransactionAppender)Mockito.doThrow((Throwable)new IOException(rootCause)).when((Object)appender)).append((TransactionToApply)Matchers.any(TransactionToApply.class), (LogAppendEvent)Matchers.any(LogAppendEvent.class));
        StorageEngine storageEngine = (StorageEngine)Mockito.mock(StorageEngine.class);
        TransactionRepresentationCommitProcess commitProcess = new TransactionRepresentationCommitProcess(appender, storageEngine);
        try {
            commitProcess.commit(this.mockedTransaction(), this.commitEvent, TransactionApplicationMode.INTERNAL);
            Assert.fail((String)"Should have failed, something is wrong with the mocking in this test");
        }
        catch (TransactionFailureException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Could not append transaction representation to log"));
            Assert.assertTrue((boolean)Exceptions.contains((Throwable)e, (String)rootCause.getMessage(), (Class[])new Class[]{rootCause.getClass()}));
        }
    }

    @Test
    public void shouldCloseTransactionRegardlessOfWhetherOrNotItAppliedCorrectly() throws Exception {
        TransactionIdStore transactionIdStore = (TransactionIdStore)Mockito.mock(TransactionIdStore.class);
        TestableTransactionAppender appender = new TestableTransactionAppender(transactionIdStore);
        long txId = 11L;
        Mockito.when((Object)transactionIdStore.nextCommittingTransactionId()).thenReturn((Object)txId);
        IOException rootCause = new IOException("Mock exception");
        StorageEngine storageEngine = (StorageEngine)Mockito.mock(StorageEngine.class);
        ((StorageEngine)Mockito.doThrow((Throwable)new IOException(rootCause)).when((Object)storageEngine)).apply((CommandsToApply)Matchers.any(TransactionToApply.class), (TransactionApplicationMode)Matchers.any(TransactionApplicationMode.class));
        TransactionRepresentationCommitProcess commitProcess = new TransactionRepresentationCommitProcess((TransactionAppender)appender, storageEngine);
        TransactionToApply transaction = this.mockedTransaction();
        try {
            commitProcess.commit(transaction, this.commitEvent, TransactionApplicationMode.INTERNAL);
        }
        catch (TransactionFailureException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Could not apply the transaction to the store"));
            Assert.assertTrue((boolean)Exceptions.contains((Throwable)e, (String)rootCause.getMessage(), (Class[])new Class[]{rootCause.getClass()}));
        }
        ((TransactionIdStore)Mockito.verify((Object)transactionIdStore, (VerificationMode)Mockito.times((int)1))).transactionClosed(Matchers.eq((long)txId), Matchers.anyLong(), Matchers.anyLong());
    }

    @Test
    public void shouldSuccessfullyCommitTransactionWithNoCommands() throws Exception {
        long txId = 11L;
        long commitTimestamp = System.currentTimeMillis();
        TransactionIdStore transactionIdStore = (TransactionIdStore)Mockito.mock(TransactionIdStore.class);
        TestableTransactionAppender appender = new TestableTransactionAppender(transactionIdStore);
        Mockito.when((Object)transactionIdStore.nextCommittingTransactionId()).thenReturn((Object)txId);
        StorageEngine storageEngine = (StorageEngine)Mockito.mock(StorageEngine.class);
        TransactionRepresentationCommitProcess commitProcess = new TransactionRepresentationCommitProcess((TransactionAppender)appender, storageEngine);
        PhysicalTransactionRepresentation noCommandTx = new PhysicalTransactionRepresentation(Collections.emptyList());
        noCommandTx.setHeader(new byte[0], -1, -1, -1L, -1L, -1L, -1);
        commitProcess.commit(new TransactionToApply((TransactionRepresentation)noCommandTx), this.commitEvent, TransactionApplicationMode.INTERNAL);
        ((TransactionIdStore)Mockito.verify((Object)transactionIdStore)).transactionCommitted(txId, 3L, 8194639457389L);
    }

    private TransactionToApply mockedTransaction() {
        TransactionRepresentation transaction = (TransactionRepresentation)Mockito.mock(TransactionRepresentation.class);
        Mockito.when((Object)transaction.additionalHeader()).thenReturn((Object)new byte[0]);
        return new TransactionToApply(transaction);
    }
}

