/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.util.Arrays;
import java.util.Iterator;
import org.neo4j.collection.primitive.PrimitiveIntCollections;
import org.neo4j.collection.primitive.PrimitiveIntSet;
import org.neo4j.cursor.Cursor;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.impl.locking.Lock;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.storageengine.api.NodeItem;
import org.neo4j.storageengine.api.PropertyItem;
import org.neo4j.storageengine.api.RelationshipItem;

public class StubCursors {
    public static Cursor<NodeItem> asNodeCursor(long ... nodeIds) {
        NodeItem[] nodeItems = new NodeItem[nodeIds.length];
        for (int i = 0; i < nodeIds.length; ++i) {
            nodeItems[i] = new StubNodeItem(nodeIds[i], -1L, PrimitiveIntCollections.emptySet());
        }
        return StubCursors.cursor(nodeItems);
    }

    public static Cursor<NodeItem> asNodeCursor(long nodeId) {
        return StubCursors.asNodeCursor(nodeId, -1L);
    }

    public static Cursor<NodeItem> asNodeCursor(long nodeId, long propertyId) {
        return StubCursors.asNodeCursor(nodeId, propertyId, PrimitiveIntCollections.emptySet());
    }

    public static Cursor<NodeItem> asNodeCursor(long nodeId, PrimitiveIntSet labels) {
        return StubCursors.cursor(new StubNodeItem(nodeId, -1L, labels));
    }

    public static Cursor<NodeItem> asNodeCursor(long nodeId, long propertyId, PrimitiveIntSet labels) {
        return StubCursors.cursor(new StubNodeItem(nodeId, propertyId, labels));
    }

    public static RelationshipItem relationship(final long id, final int type, final long start, final long end) {
        return new RelationshipItem(){

            public long id() {
                return id;
            }

            public int type() {
                return type;
            }

            public long startNode() {
                return start;
            }

            public long endNode() {
                return end;
            }

            public long otherNode(long nodeId) {
                if (nodeId == start) {
                    return end;
                }
                if (nodeId == end) {
                    return start;
                }
                throw new IllegalStateException();
            }

            public long nextPropertyId() {
                throw new UnsupportedOperationException();
            }

            public Lock lock() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static Cursor<RelationshipItem> asRelationshipCursor(final long relId, final int type, final long startNode, final long endNode, final long propertyId) {
        return StubCursors.cursor(new RelationshipItem(){

            public long id() {
                return relId;
            }

            public int type() {
                return type;
            }

            public long startNode() {
                return startNode;
            }

            public long endNode() {
                return endNode;
            }

            public long otherNode(long nodeId) {
                return startNode == nodeId ? endNode : startNode;
            }

            public long nextPropertyId() {
                return propertyId;
            }

            public Lock lock() {
                return LockService.NO_LOCK;
            }
        });
    }

    public static PrimitiveIntSet labels(int ... labels) {
        return PrimitiveIntCollections.asSet((int[])labels);
    }

    public static Cursor<PropertyItem> asPropertyCursor(DefinedProperty ... properties) {
        return StubCursors.cursor(Iterables.map(StubCursors::asPropertyItem, Arrays.asList(properties)));
    }

    private static PropertyItem asPropertyItem(final DefinedProperty property) {
        return new PropertyItem(){

            public int propertyKeyId() {
                return property.propertyKeyId();
            }

            public Object value() {
                return property.value();
            }
        };
    }

    @SafeVarargs
    public static <T> Cursor<T> cursor(T ... items) {
        return StubCursors.cursor(Iterables.asIterable((Object[])items));
    }

    public static <T> Cursor<T> cursor(final Iterable<T> items) {
        return new Cursor<T>(){
            Iterator<T> iterator;
            T current;
            {
                this.iterator = items.iterator();
            }

            public boolean next() {
                if (this.iterator.hasNext()) {
                    this.current = this.iterator.next();
                    return true;
                }
                return false;
            }

            public void close() {
                this.iterator = items.iterator();
                this.current = null;
            }

            public T get() {
                if (this.current == null) {
                    throw new IllegalStateException();
                }
                return this.current;
            }
        };
    }

    private static class StubNodeItem
    implements NodeItem {
        private final long nodeId;
        private final long propertyId;
        private final PrimitiveIntSet labels;

        private StubNodeItem(long nodeId, long propertyId, PrimitiveIntSet labels) {
            this.nodeId = nodeId;
            this.propertyId = propertyId;
            this.labels = labels;
        }

        public long id() {
            return this.nodeId;
        }

        public boolean hasLabel(int labelId) {
            return this.labels.contains(labelId);
        }

        public long nextGroupId() {
            throw new UnsupportedOperationException("not supported");
        }

        public long nextRelationshipId() {
            throw new UnsupportedOperationException("not supported");
        }

        public long nextPropertyId() {
            return this.propertyId;
        }

        public Lock lock() {
            return LockService.NO_LOCK;
        }

        public PrimitiveIntSet labels() {
            return this.labels;
        }

        public boolean isDense() {
            throw new UnsupportedOperationException();
        }
    }
}

