/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.PropertyKeyTokenStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.TokenRecord;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class ManyPropertyKeysIT {
    private final PageCacheRule pageCacheRule = new PageCacheRule();
    private final TestDirectory testDirectory = TestDirectory.testDirectory();
    private final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    @Rule
    public final RuleChain ruleChain = RuleChain.outerRule((TestRule)this.testDirectory).around((TestRule)this.fileSystemRule).around((TestRule)this.pageCacheRule);
    private File storeDir;

    @Before
    public void setup() {
        this.storeDir = this.testDirectory.graphDbDir();
    }

    @Test
    public void creating_many_property_keys_should_have_all_loaded_the_next_restart() throws Exception {
        GraphDatabaseAPI db = this.databaseWithManyPropertyKeys(3000);
        int countBefore = this.propertyKeyCount(db);
        db.shutdown();
        db = this.database();
        this.createNodeWithProperty((GraphDatabaseService)db, this.key(2800), true);
        Assert.assertEquals((long)countBefore, (long)this.propertyKeyCount(db));
        db.shutdown();
    }

    @Test
    public void concurrently_creating_same_property_key_in_different_transactions_should_end_up_with_same_key_id() throws Exception {
        GraphDatabaseAPI db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newImpermanentDatabase();
        OtherThreadExecutor<WorkerState> worker1 = new OtherThreadExecutor<WorkerState>("w1", new WorkerState((GraphDatabaseService)db));
        OtherThreadExecutor<WorkerState> worker2 = new OtherThreadExecutor<WorkerState>("w2", new WorkerState((GraphDatabaseService)db));
        worker1.execute(new BeginTx());
        worker2.execute(new BeginTx());
        String key = "mykey";
        worker1.execute(new CreateNodeAndSetProperty(key));
        worker2.execute(new CreateNodeAndSetProperty(key));
        worker1.execute(new FinishTx());
        worker2.execute(new FinishTx());
        worker1.close();
        worker2.close();
        Assert.assertEquals((long)1L, (long)this.propertyKeyCount(db));
        db.shutdown();
    }

    private GraphDatabaseAPI database() {
        return (GraphDatabaseAPI)new TestGraphDatabaseFactory().newEmbeddedDatabase(this.storeDir.getAbsoluteFile());
    }

    private GraphDatabaseAPI databaseWithManyPropertyKeys(int propertyKeyCount) throws IOException {
        PageCache pageCache = this.pageCacheRule.getPageCache(this.fileSystemRule.get());
        StoreFactory storeFactory = new StoreFactory(this.storeDir, pageCache, this.fileSystemRule.get(), (LogProvider)NullLogProvider.getInstance());
        NeoStores neoStores = storeFactory.openAllNeoStores(true);
        PropertyKeyTokenStore store = neoStores.getPropertyKeyTokenStore();
        for (int i = 0; i < propertyKeyCount; ++i) {
            PropertyKeyTokenRecord record = new PropertyKeyTokenRecord((int)store.nextId());
            record.setInUse(true);
            Collection nameRecords = store.allocateNameRecords(PropertyStore.encodeString((String)this.key(i)));
            record.addNameRecords((Iterable)nameRecords);
            record.setNameId((int)((DynamicRecord)Iterables.first((Iterable)nameRecords)).getId());
            store.updateRecord((TokenRecord)record);
        }
        neoStores.close();
        return this.database();
    }

    private String key(int i) {
        return "key" + i;
    }

    private Node createNodeWithProperty(GraphDatabaseService db, String key, Object value) {
        try (Transaction tx = db.beginTx();){
            Node node = db.createNode();
            node.setProperty(key, value);
            tx.success();
            Node node2 = node;
            return node2;
        }
    }

    /*
     * Exception decompiling
     */
    private int propertyKeyCount(GraphDatabaseAPI db) throws TransactionFailureException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static class FinishTx
    implements OtherThreadExecutor.WorkerCommand<WorkerState, Void> {
        private FinishTx() {
        }

        @Override
        public Void doWork(WorkerState state) {
            state.tx.success();
            state.tx.close();
            return null;
        }
    }

    private static class CreateNodeAndSetProperty
    implements OtherThreadExecutor.WorkerCommand<WorkerState, Void> {
        private final String key;

        CreateNodeAndSetProperty(String key) {
            this.key = key;
        }

        @Override
        public Void doWork(WorkerState state) {
            Node node = state.db.createNode();
            node.setProperty(this.key, (Object)true);
            return null;
        }
    }

    private static class BeginTx
    implements OtherThreadExecutor.WorkerCommand<WorkerState, Void> {
        private BeginTx() {
        }

        @Override
        public Void doWork(WorkerState state) {
            state.tx = state.db.beginTx();
            return null;
        }
    }

    private static class WorkerState {
        protected final GraphDatabaseService db;
        protected Transaction tx;

        WorkerState(GraphDatabaseService db) {
            this.db = db;
        }
    }
}

