/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.labelscan;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.cursor.RawCursor;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Hit;
import org.neo4j.kernel.impl.index.labelscan.LabelScanKey;
import org.neo4j.kernel.impl.index.labelscan.LabelScanValue;
import org.neo4j.kernel.impl.index.labelscan.MutableHit;
import org.neo4j.kernel.impl.index.labelscan.NativeLabelScanReader;

public class NativeLabelScanReaderTest {
    private static final int LABEL_ID = 1;

    @Test
    public void shouldFindMultipleNodesInEachRange() throws Exception {
        GBPTree index = (GBPTree)Mockito.mock(GBPTree.class);
        RawCursor cursor = (RawCursor)Mockito.mock(RawCursor.class);
        Mockito.when((Object)cursor.next()).thenReturn((Object)true, (Object[])new Boolean[]{true, true, false});
        Mockito.when((Object)cursor.get()).thenReturn(NativeLabelScanReaderTest.hit(0L, 35010L), (Object[])new Hit[]{NativeLabelScanReaderTest.hit(1L, 520L), NativeLabelScanReaderTest.hit(3L, 8353L), null});
        Mockito.when((Object)index.seek(Matchers.any(LabelScanKey.class), Matchers.any(LabelScanKey.class))).thenReturn((Object)cursor);
        try (NativeLabelScanReader reader = new NativeLabelScanReader(index);){
            PrimitiveLongIterator iterator = reader.nodesWithLabel(1);
            Assert.assertArrayEquals((long[])new long[]{1L, 6L, 7L, 11L, 15L, 67L, 73L, 192L, 197L, 199L, 205L}, (long[])PrimitiveLongCollections.asArray((PrimitiveLongIterator)iterator));
        }
    }

    private static Hit<LabelScanKey, LabelScanValue> hit(long baseNodeId, long bits) {
        LabelScanKey key = new LabelScanKey(1, baseNodeId);
        LabelScanValue value = new LabelScanValue();
        value.bits = bits;
        return new MutableHit<LabelScanKey, LabelScanValue>(key, value);
    }
}

