/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc;

import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.proc.FieldSignature;
import org.neo4j.kernel.api.proc.Neo4jTypes;
import org.neo4j.kernel.impl.proc.MethodSignatureCompiler;
import org.neo4j.kernel.impl.proc.TypeMappers;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class MethodSignatureCompilerTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void shouldMapSimpleRecordWithString() throws Throwable {
        Method echo = ClassWithProcedureWithSimpleArgs.class.getMethod("echo", String.class);
        List signature = new MethodSignatureCompiler(new TypeMappers()).signatureFor(echo);
        MatcherAssert.assertThat((Object)signature, (Matcher)Matchers.contains((Object[])new FieldSignature[]{FieldSignature.inputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTString)}));
    }

    @Test
    public void shouldMapSimpleFunctionWithString() throws Throwable {
        Method echo = ClassWithProcedureWithSimpleArgs.class.getMethod("echo", String.class);
        List signature = new MethodSignatureCompiler(new TypeMappers()).inputTypesFor(echo);
        MatcherAssert.assertThat((Object)signature, (Matcher)Matchers.contains((Object[])new Neo4jTypes.AnyType[]{Neo4jTypes.NTString}));
    }

    @Test
    public void shouldGiveHelpfulErrorOnUnmappable() throws Throwable {
        Method echo = ClassWithProcedureWithSimpleArgs.class.getMethod("echoWithInvalidType", UnmappableRecord.class);
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage(String.format("Argument `name` at position 0 in `echoWithInvalidType` with%ntype `UnmappableRecord` cannot be converted to a Neo4j type: Don't know how to map `org.neo4j.kernel.impl.proc.MethodSignatureCompilerTest$UnmappableRecord` to the Neo4j Type System.%nPlease refer to to the documentation for full details.%nFor your reference, known types are:", new Object[0]));
        new MethodSignatureCompiler(new TypeMappers()).signatureFor(echo);
    }

    @Test
    public void shouldGiveHelpfulErrorOnMissingAnnotations() throws Throwable {
        Method echo = ClassWithProcedureWithSimpleArgs.class.getMethod("echoWithoutAnnotations", String.class, String.class);
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage(String.format("Argument at position 1 in method `echoWithoutAnnotations` is missing an `@Name` annotation.%nPlease add the annotation, recompile the class and try again.", new Object[0]));
        new MethodSignatureCompiler(new TypeMappers()).signatureFor(echo);
    }

    public static class ClassWithProcedureWithSimpleArgs {
        @Procedure
        public Stream<MyOutputRecord> echo(@Name(value="name") String in) {
            return Stream.of(new MyOutputRecord(in));
        }

        @Procedure
        public Stream<MyOutputRecord> echoWithoutAnnotations(@Name(value="name") String in1, String in2) {
            return Stream.of(new MyOutputRecord(in1 + in2));
        }

        @Procedure
        public Stream<MyOutputRecord> echoWithInvalidType(@Name(value="name") UnmappableRecord in) {
            return Stream.of(new MyOutputRecord("echo"));
        }
    }

    public static class UnmappableRecord {
        public UnmappableRecord wat;
    }

    public static class MyOutputRecord {
        public String name;

        MyOutputRecord(String name) {
            this.name = name;
        }
    }
}

