/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.record;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.api.schema.constaints.ConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.ConstraintDescriptorFactory;
import org.neo4j.kernel.api.schema.constaints.IndexBackedConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.NodeExistenceConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.NodeKeyConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.UniquenessConstraintDescriptor;
import org.neo4j.kernel.impl.store.record.ConstraintRule;
import org.neo4j.kernel.impl.store.record.SchemaRuleTestBase;

public class ConstraintRuleTest
extends SchemaRuleTestBase {
    @Test
    public void shouldCreateUniquenessConstraint() throws Exception {
        UniquenessConstraintDescriptor descriptor = ConstraintDescriptorFactory.uniqueForLabel((int)10, (int[])new int[]{30});
        ConstraintRule constraintRule = ConstraintRule.constraintRule((long)1L, (ConstraintDescriptor)descriptor);
        Assert.assertThat((Object)constraintRule.getId(), (Matcher)Matchers.equalTo((Object)1L));
        Assert.assertThat((Object)constraintRule.schema(), (Matcher)Matchers.equalTo((Object)descriptor.schema()));
        Assert.assertThat((Object)constraintRule.getConstraintDescriptor(), (Matcher)Matchers.equalTo((Object)descriptor));
        org.neo4j.test.assertion.Assert.assertException(() -> ((ConstraintRule)constraintRule).getOwnedIndex(), IllegalStateException.class);
    }

    @Test
    public void shouldCreateUniquenessConstraintWithOwnedIndex() throws Exception {
        UniquenessConstraintDescriptor descriptor = ConstraintDescriptorFactory.uniqueForLabel((int)10, (int[])new int[]{30});
        ConstraintRule constraintRule = ConstraintRule.constraintRule((long)1L, (IndexBackedConstraintDescriptor)descriptor, (long)2L);
        Assert.assertThat((Object)constraintRule.getConstraintDescriptor(), (Matcher)Matchers.equalTo((Object)descriptor));
        Assert.assertThat((Object)constraintRule.getOwnedIndex(), (Matcher)Matchers.equalTo((Object)2L));
    }

    @Test
    public void shouldCreateNodeKeyConstraint() throws Exception {
        NodeKeyConstraintDescriptor descriptor = ConstraintDescriptorFactory.nodeKeyForLabel((int)10, (int[])new int[]{30});
        ConstraintRule constraintRule = ConstraintRule.constraintRule((long)1L, (ConstraintDescriptor)descriptor);
        Assert.assertThat((Object)constraintRule.getId(), (Matcher)Matchers.equalTo((Object)1L));
        Assert.assertThat((Object)constraintRule.schema(), (Matcher)Matchers.equalTo((Object)descriptor.schema()));
        Assert.assertThat((Object)constraintRule.getConstraintDescriptor(), (Matcher)Matchers.equalTo((Object)descriptor));
        org.neo4j.test.assertion.Assert.assertException(() -> ((ConstraintRule)constraintRule).getOwnedIndex(), IllegalStateException.class);
    }

    @Test
    public void shouldCreateNodeKeyConstraintWithOwnedIndex() throws Exception {
        NodeKeyConstraintDescriptor descriptor = ConstraintDescriptorFactory.nodeKeyForLabel((int)10, (int[])new int[]{30});
        ConstraintRule constraintRule = ConstraintRule.constraintRule((long)1L, (IndexBackedConstraintDescriptor)descriptor, (long)2L);
        Assert.assertThat((Object)constraintRule.getConstraintDescriptor(), (Matcher)Matchers.equalTo((Object)descriptor));
        Assert.assertThat((Object)constraintRule.getOwnedIndex(), (Matcher)Matchers.equalTo((Object)2L));
    }

    @Test
    public void shouldCreateExistenceConstraint() throws Exception {
        NodeExistenceConstraintDescriptor descriptor = ConstraintDescriptorFactory.existsForLabel((int)10, (int[])new int[]{30});
        ConstraintRule constraintRule = ConstraintRule.constraintRule((long)1L, (ConstraintDescriptor)descriptor);
        Assert.assertThat((Object)constraintRule.getId(), (Matcher)Matchers.equalTo((Object)1L));
        Assert.assertThat((Object)constraintRule.schema(), (Matcher)Matchers.equalTo((Object)descriptor.schema()));
        Assert.assertThat((Object)constraintRule.getConstraintDescriptor(), (Matcher)Matchers.equalTo((Object)descriptor));
        org.neo4j.test.assertion.Assert.assertException(() -> ((ConstraintRule)constraintRule).getOwnedIndex(), IllegalStateException.class);
    }

    @Test
    public void indexRulesAreEqualBasedOnConstraintDescriptor() throws Exception {
        this.assertEqualityByDescriptor((ConstraintDescriptor)ConstraintDescriptorFactory.existsForLabel((int)10, (int[])new int[]{30}));
        this.assertEqualityByDescriptor(ConstraintDescriptorFactory.uniqueForLabel((int)10, (int[])new int[]{30}));
        this.assertEqualityByDescriptor((ConstraintDescriptor)ConstraintDescriptorFactory.nodeKeyForLabel((int)10, (int[])new int[]{30}));
        this.assertEqualityByDescriptor((ConstraintDescriptor)ConstraintDescriptorFactory.existsForRelType((int)20, (int[])new int[]{30}));
        this.assertEqualityByDescriptor((ConstraintDescriptor)ConstraintDescriptorFactory.existsForLabel((int)10, (int[])new int[]{30, 31}));
        this.assertEqualityByDescriptor(ConstraintDescriptorFactory.uniqueForLabel((int)10, (int[])new int[]{30, 31}));
        this.assertEqualityByDescriptor((ConstraintDescriptor)ConstraintDescriptorFactory.nodeKeyForLabel((int)10, (int[])new int[]{30, 31}));
    }

    private void assertEqualityByDescriptor(UniquenessConstraintDescriptor descriptor) {
        ConstraintRule rule1 = ConstraintRule.constraintRule((long)1L, (IndexBackedConstraintDescriptor)descriptor, (long)2L);
        ConstraintRule rule2 = ConstraintRule.constraintRule((long)2L, (ConstraintDescriptor)descriptor);
        this.assertEquality(rule1, rule2);
    }

    private void assertEqualityByDescriptor(ConstraintDescriptor descriptor) {
        ConstraintRule rule1 = ConstraintRule.constraintRule((long)1L, (ConstraintDescriptor)descriptor);
        ConstraintRule rule2 = ConstraintRule.constraintRule((long)2L, (ConstraintDescriptor)descriptor);
        this.assertEquality(rule1, rule2);
    }
}

