/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.ReaderLogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderWriter;

public class ReaderLogVersionBridgeTest {
    private final FileSystemAbstraction fs = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
    private final PhysicalLogFiles logFiles = (PhysicalLogFiles)Mockito.mock(PhysicalLogFiles.class);
    private final LogVersionedStoreChannel channel = (LogVersionedStoreChannel)Mockito.mock(LogVersionedStoreChannel.class);
    private final File file = (File)Mockito.mock(File.class);
    private final long version = 10L;

    @Test
    public void shouldOpenTheNextChannelWhenItExists() throws IOException {
        StoreChannel newStoreChannel = (StoreChannel)Mockito.mock(StoreChannel.class);
        ReaderLogVersionBridge bridge = new ReaderLogVersionBridge(this.fs, this.logFiles);
        Mockito.when((Object)this.channel.getVersion()).thenReturn((Object)10L);
        Mockito.when((Object)this.channel.getLogFormatVersion()).thenReturn((Object)6);
        Mockito.when((Object)this.logFiles.getLogFileForVersion(11L)).thenReturn((Object)this.file);
        Mockito.when((Object)this.fs.fileExists(this.file)).thenReturn((Object)true);
        Mockito.when((Object)this.fs.open(this.file, "r")).thenReturn((Object)newStoreChannel);
        Mockito.when((Object)newStoreChannel.read((ByteBuffer)Matchers.any())).then((Answer)new Answer<Integer>(){

            public Integer answer(InvocationOnMock invocationOnMock) throws Throwable {
                ByteBuffer buffer = (ByteBuffer)invocationOnMock.getArguments()[0];
                buffer.putLong(LogHeaderWriter.encodeLogVersion((long)11L));
                buffer.putLong(42L);
                return 16;
            }
        });
        LogVersionedStoreChannel result = bridge.next(this.channel);
        PhysicalLogVersionedStoreChannel expected = new PhysicalLogVersionedStoreChannel(newStoreChannel, 11L, 6);
        Assert.assertEquals((Object)expected, (Object)result);
        ((LogVersionedStoreChannel)Mockito.verify((Object)this.channel, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void shouldReturnOldChannelWhenThereIsNoNextChannel() throws IOException {
        ReaderLogVersionBridge bridge = new ReaderLogVersionBridge(this.fs, this.logFiles);
        Mockito.when((Object)this.channel.getVersion()).thenReturn((Object)10L);
        Mockito.when((Object)this.logFiles.getLogFileForVersion(11L)).thenReturn((Object)this.file);
        Mockito.when((Object)this.fs.open(this.file, "r")).thenThrow(new Throwable[]{new FileNotFoundException()});
        LogVersionedStoreChannel result = bridge.next(this.channel);
        Assert.assertEquals((Object)this.channel, (Object)result);
        ((LogVersionedStoreChannel)Mockito.verify((Object)this.channel, (VerificationMode)Mockito.never())).close();
    }

    @Test
    public void shouldReturnOldChannelWhenNextChannelHasntGottenCompleteHeaderYet() throws Exception {
        ReaderLogVersionBridge bridge = new ReaderLogVersionBridge(this.fs, this.logFiles);
        StoreChannel nextVersionWithIncompleteHeader = (StoreChannel)Mockito.mock(StoreChannel.class);
        Mockito.when((Object)nextVersionWithIncompleteHeader.read((ByteBuffer)Matchers.any(ByteBuffer.class))).thenReturn((Object)8);
        Mockito.when((Object)this.channel.getVersion()).thenReturn((Object)10L);
        Mockito.when((Object)this.fs.fileExists(this.file)).thenReturn((Object)true);
        Mockito.when((Object)this.logFiles.getLogFileForVersion(11L)).thenReturn((Object)this.file);
        Mockito.when((Object)this.fs.open(this.file, "r")).thenReturn((Object)nextVersionWithIncompleteHeader);
        LogVersionedStoreChannel result = bridge.next(this.channel);
        Assert.assertEquals((Object)this.channel, (Object)result);
        ((LogVersionedStoreChannel)Mockito.verify((Object)this.channel, (VerificationMode)Mockito.never())).close();
    }
}

