/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.command;

import java.io.IOException;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.concurrent.Work;
import org.neo4j.concurrent.WorkSync;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.api.labelscan.LabelScanWriter;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.kernel.impl.api.TransactionApplier;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.NodeUpdates;
import org.neo4j.kernel.impl.api.index.PropertyPhysicalToLogicalConverter;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.command.IndexBatchTransactionApplier;
import org.neo4j.storageengine.api.CommandsToApply;
import org.neo4j.storageengine.api.TransactionApplicationMode;

public class IndexBatchTransactionApplierTest {
    @Test
    public void shouldProvideLabelScanStoreUpdatesSortedByNodeId() throws Exception {
        IndexingService indexing = (IndexingService)Mockito.mock(IndexingService.class);
        Mockito.when((Object)indexing.convertToIndexUpdates((NodeUpdates)Matchers.any())).thenAnswer(o -> Iterables.empty());
        OrderVerifyingLabelScanWriter writer = new OrderVerifyingLabelScanWriter(10L, 15L, 20L);
        WorkSync labelScanSync = (WorkSync)Mockito.spy((Object)new WorkSync(this.singletonProvider(writer)));
        WorkSync indexUpdatesSync = new WorkSync((Object)indexing);
        TransactionToApply tx = (TransactionToApply)Mockito.mock(TransactionToApply.class);
        PropertyStore propertyStore = (PropertyStore)Mockito.mock(PropertyStore.class);
        try (IndexBatchTransactionApplier applier = new IndexBatchTransactionApplier(indexing, labelScanSync, indexUpdatesSync, (NodeStore)Mockito.mock(NodeStore.class), new PropertyPhysicalToLogicalConverter(propertyStore), TransactionApplicationMode.INTERNAL);
             TransactionApplier txApplier = applier.startTx((CommandsToApply)tx);){
            txApplier.visitNodeCommand(this.node(15L));
            txApplier.visitNodeCommand(this.node(20L));
            txApplier.visitNodeCommand(this.node(10L));
        }
        ((WorkSync)Mockito.verify((Object)labelScanSync)).apply((Work)Matchers.any());
    }

    private Supplier<LabelScanWriter> singletonProvider(LabelScanWriter writer) {
        return () -> writer;
    }

    private Command.NodeCommand node(long nodeId) {
        NodeRecord after = new NodeRecord(nodeId, true, false, (long)Record.NO_NEXT_RELATIONSHIP.intValue(), (long)Record.NO_NEXT_PROPERTY.intValue(), 0L);
        NodeLabelsField.parseLabelsField((NodeRecord)after).add(1L, null, null);
        return new Command.NodeCommand(new NodeRecord(nodeId), after);
    }

    private static class OrderVerifyingLabelScanWriter
    implements LabelScanWriter {
        private final long[] expectedNodeIds;
        private int cursor;

        OrderVerifyingLabelScanWriter(long ... expectedNodeIds) {
            this.expectedNodeIds = expectedNodeIds;
        }

        public void write(NodeLabelUpdate update) throws IOException {
            Assert.assertEquals((long)this.expectedNodeIds[this.cursor], (long)update.getNodeId());
            ++this.cursor;
        }

        public void close() throws IOException {
            Assert.assertEquals((long)this.cursor, (long)this.expectedNodeIds.length);
        }
    }
}

