/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.dbstructure;

import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.api.DataWriteOperations;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.SchemaWriteOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.TokenWriteOperations;
import org.neo4j.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.api.schema.constaints.UniquenessConstraintDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptorFactory;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.util.dbstructure.DbStructureVisitor;
import org.neo4j.kernel.impl.util.dbstructure.GraphDbStructureGuide;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.rule.ImpermanentDatabaseRule;

public class GraphDbStructureGuideTest {
    @Rule
    public ImpermanentDatabaseRule dbRule = new ImpermanentDatabaseRule();
    private GraphDatabaseService graph;
    private ThreadToStatementContextBridge bridge;
    private Transaction tx;

    @Test
    public void visitsLabelIds() throws Exception {
        DbStructureVisitor visitor = (DbStructureVisitor)Mockito.mock(DbStructureVisitor.class);
        this.graph.createNode(new Label[]{DynamicLabel.label((String)"Person")});
        this.graph.createNode(new Label[]{DynamicLabel.label((String)"Party")});
        this.graph.createNode(new Label[]{DynamicLabel.label((String)"Animal")});
        int personLabelId = this.read().labelGetForName("Person");
        int partyLabelId = this.read().labelGetForName("Party");
        int animalLabelId = this.read().labelGetForName("Animal");
        this.accept(visitor);
        ((DbStructureVisitor)Mockito.verify((Object)visitor)).visitLabel(personLabelId, "Person");
        ((DbStructureVisitor)Mockito.verify((Object)visitor)).visitLabel(partyLabelId, "Party");
        ((DbStructureVisitor)Mockito.verify((Object)visitor)).visitLabel(animalLabelId, "Animal");
    }

    @Test
    public void visitsPropertyKeyIds() throws Exception {
        DbStructureVisitor visitor = (DbStructureVisitor)Mockito.mock(DbStructureVisitor.class);
        int nameId = this.createPropertyKey("name");
        int ageId = this.createPropertyKey("age");
        int osId = this.createPropertyKey("os");
        this.accept(visitor);
        ((DbStructureVisitor)Mockito.verify((Object)visitor)).visitPropertyKey(nameId, "name");
        ((DbStructureVisitor)Mockito.verify((Object)visitor)).visitPropertyKey(ageId, "age");
        ((DbStructureVisitor)Mockito.verify((Object)visitor)).visitPropertyKey(osId, "os");
    }

    @Test
    public void visitsRelationshipTypeIds() throws Exception {
        DbStructureVisitor visitor = (DbStructureVisitor)Mockito.mock(DbStructureVisitor.class);
        Node lhs = this.graph.createNode();
        Node rhs = this.graph.createNode();
        lhs.createRelationshipTo(rhs, (RelationshipType)DynamicRelationshipType.withName((String)"KNOWS"));
        lhs.createRelationshipTo(rhs, (RelationshipType)DynamicRelationshipType.withName((String)"LOVES"));
        lhs.createRelationshipTo(rhs, (RelationshipType)DynamicRelationshipType.withName((String)"FAWNS_AT"));
        int knowsId = this.read().relationshipTypeGetForName("KNOWS");
        int lovesId = this.read().relationshipTypeGetForName("LOVES");
        int fawnsAtId = this.read().relationshipTypeGetForName("FAWNS_AT");
        this.accept(visitor);
        ((DbStructureVisitor)Mockito.verify((Object)visitor)).visitRelationshipType(knowsId, "KNOWS");
        ((DbStructureVisitor)Mockito.verify((Object)visitor)).visitRelationshipType(lovesId, "LOVES");
        ((DbStructureVisitor)Mockito.verify((Object)visitor)).visitRelationshipType(fawnsAtId, "FAWNS_AT");
    }

    @Test
    public void visitsIndexes() throws Exception {
        DbStructureVisitor visitor = (DbStructureVisitor)Mockito.mock(DbStructureVisitor.class);
        int labelId = this.createLabel("Person");
        int pkId = this.createPropertyKey("name");
        this.commitAndReOpen();
        IndexDescriptor descriptor = this.createSchemaIndex(labelId, pkId);
        this.accept(visitor);
        ((DbStructureVisitor)Mockito.verify((Object)visitor)).visitIndex(descriptor, ":Person(name)", 1.0, 0L);
    }

    @Test
    public void visitsUniqueConstraintsAndIndices() throws Exception {
        DbStructureVisitor visitor = (DbStructureVisitor)Mockito.mock(DbStructureVisitor.class);
        int labelId = this.createLabel("Person");
        int pkId = this.createPropertyKey("name");
        this.commitAndReOpen();
        UniquenessConstraintDescriptor constraint = this.createUniqueConstraint(labelId, pkId);
        IndexDescriptor descriptor = IndexDescriptorFactory.uniqueForLabel((int)labelId, (int[])new int[]{pkId});
        this.accept(visitor);
        ((DbStructureVisitor)Mockito.verify((Object)visitor)).visitIndex(descriptor, ":Person(name)", 1.0, 0L);
        ((DbStructureVisitor)Mockito.verify((Object)visitor)).visitUniqueConstraint(constraint, "CONSTRAINT ON ( person:Person ) ASSERT person.name IS UNIQUE");
    }

    @Test
    public void visitsNodeCounts() throws Exception {
        DbStructureVisitor visitor = (DbStructureVisitor)Mockito.mock(DbStructureVisitor.class);
        int personLabelId = this.createLabeledNodes("Person", 40);
        int partyLabelId = this.createLabeledNodes("Party", 20);
        int animalLabelId = this.createLabeledNodes("Animal", 30);
        this.accept(visitor);
        ((DbStructureVisitor)Mockito.verify((Object)visitor)).visitAllNodesCount(90L);
        ((DbStructureVisitor)Mockito.verify((Object)visitor)).visitNodeCount(personLabelId, "Person", 40L);
        ((DbStructureVisitor)Mockito.verify((Object)visitor)).visitNodeCount(partyLabelId, "Party", 20L);
        ((DbStructureVisitor)Mockito.verify((Object)visitor)).visitNodeCount(animalLabelId, "Animal", 30L);
    }

    @Test
    public void visitsRelCounts() throws Exception {
        DbStructureVisitor visitor = (DbStructureVisitor)Mockito.mock(DbStructureVisitor.class);
        int personLabelId = this.createLabeledNodes("Person", 40);
        int partyLabelId = this.createLabeledNodes("Party", 20);
        int knowsId = this.createRelTypeId("KNOWS");
        int lovesId = this.createRelTypeId("LOVES");
        long personNode = this.createLabeledNode(personLabelId);
        long partyNode = this.createLabeledNode(partyLabelId);
        this.createRel(personNode, knowsId, personNode);
        this.createRel(personNode, lovesId, partyNode);
        this.accept(visitor);
        ((DbStructureVisitor)Mockito.verify((Object)visitor)).visitRelCount(-1, knowsId, -1, "MATCH ()-[:KNOWS]->() RETURN count(*)", 1L);
        ((DbStructureVisitor)Mockito.verify((Object)visitor)).visitRelCount(-1, lovesId, -1, "MATCH ()-[:LOVES]->() RETURN count(*)", 1L);
        ((DbStructureVisitor)Mockito.verify((Object)visitor)).visitRelCount(-1, -1, -1, "MATCH ()-[]->() RETURN count(*)", 2L);
        ((DbStructureVisitor)Mockito.verify((Object)visitor)).visitRelCount(personLabelId, knowsId, -1, "MATCH (:Person)-[:KNOWS]->() RETURN count(*)", 1L);
        ((DbStructureVisitor)Mockito.verify((Object)visitor)).visitRelCount(-1, knowsId, personLabelId, "MATCH ()-[:KNOWS]->(:Person) RETURN count(*)", 1L);
        ((DbStructureVisitor)Mockito.verify((Object)visitor)).visitRelCount(personLabelId, lovesId, -1, "MATCH (:Person)-[:LOVES]->() RETURN count(*)", 1L);
        ((DbStructureVisitor)Mockito.verify((Object)visitor)).visitRelCount(-1, lovesId, personLabelId, "MATCH ()-[:LOVES]->(:Person) RETURN count(*)", 0L);
        ((DbStructureVisitor)Mockito.verify((Object)visitor)).visitRelCount(personLabelId, -1, -1, "MATCH (:Person)-[]->() RETURN count(*)", 2L);
        ((DbStructureVisitor)Mockito.verify((Object)visitor)).visitRelCount(-1, -1, personLabelId, "MATCH ()-[]->(:Person) RETURN count(*)", 1L);
        ((DbStructureVisitor)Mockito.verify((Object)visitor)).visitRelCount(partyLabelId, knowsId, -1, "MATCH (:Party)-[:KNOWS]->() RETURN count(*)", 0L);
        ((DbStructureVisitor)Mockito.verify((Object)visitor)).visitRelCount(-1, knowsId, partyLabelId, "MATCH ()-[:KNOWS]->(:Party) RETURN count(*)", 0L);
        ((DbStructureVisitor)Mockito.verify((Object)visitor)).visitRelCount(partyLabelId, lovesId, -1, "MATCH (:Party)-[:LOVES]->() RETURN count(*)", 0L);
        ((DbStructureVisitor)Mockito.verify((Object)visitor)).visitRelCount(-1, lovesId, partyLabelId, "MATCH ()-[:LOVES]->(:Party) RETURN count(*)", 1L);
        ((DbStructureVisitor)Mockito.verify((Object)visitor)).visitRelCount(partyLabelId, -1, -1, "MATCH (:Party)-[]->() RETURN count(*)", 0L);
        ((DbStructureVisitor)Mockito.verify((Object)visitor)).visitRelCount(-1, -1, partyLabelId, "MATCH ()-[]->(:Party) RETURN count(*)", 1L);
    }

    private void createRel(long startId, int relTypeId, long endId) throws Exception {
        this.dataWrite().relationshipCreate(relTypeId, startId, endId);
    }

    private IndexDescriptor createSchemaIndex(int labelId, int pkId) throws Exception {
        return this.schemaWrite().indexCreate(SchemaDescriptorFactory.forLabel((int)labelId, (int[])new int[]{pkId}));
    }

    private UniquenessConstraintDescriptor createUniqueConstraint(int labelId, int pkId) throws Exception {
        return this.schemaWrite().uniquePropertyConstraintCreate(SchemaDescriptorFactory.forLabel((int)labelId, (int[])new int[]{pkId}));
    }

    private int createLabeledNodes(String labelName, int amount) throws Exception {
        int labelId = this.createLabel(labelName);
        for (int i = 0; i < amount; ++i) {
            this.createLabeledNode(labelId);
        }
        return labelId;
    }

    private long createLabeledNode(int labelId) throws Exception {
        long nodeId = this.dataWrite().nodeCreate();
        this.dataWrite().nodeAddLabel(nodeId, labelId);
        return nodeId;
    }

    private int createLabel(String name) throws Exception {
        return this.tokenWrite().labelGetOrCreateForName(name);
    }

    private int createPropertyKey(String name) throws Exception {
        return this.tokenWrite().propertyKeyGetOrCreateForName(name);
    }

    private int createRelTypeId(String name) throws Exception {
        return this.tokenWrite().relationshipTypeGetOrCreateForName(name);
    }

    @Before
    public void setUp() throws InvalidTransactionTypeKernelException {
        GraphDatabaseAPI api = this.dbRule.getGraphDatabaseAPI();
        this.graph = api;
        DependencyResolver dependencyResolver = api.getDependencyResolver();
        this.bridge = (ThreadToStatementContextBridge)dependencyResolver.resolveDependency(ThreadToStatementContextBridge.class);
        this.tx = this.graph.beginTx();
    }

    @After
    public void tearDown() {
        if (this.bridge.hasTransaction()) {
            this.statement().close();
            this.tx.failure();
            this.tx.close();
        }
    }

    private Statement statement() {
        return this.bridge.get();
    }

    private ReadOperations read() {
        return this.statement().readOperations();
    }

    private TokenWriteOperations tokenWrite() throws Exception {
        return this.statement().tokenWriteOperations();
    }

    private DataWriteOperations dataWrite() throws Exception {
        return this.statement().dataWriteOperations();
    }

    private SchemaWriteOperations schemaWrite() throws Exception {
        return this.statement().schemaWriteOperations();
    }

    public void commitAndReOpen() {
        this.commit();
        this.tx = this.graph.beginTx();
    }

    public void accept(DbStructureVisitor visitor) {
        this.commitAndReOpen();
        this.graph.schema().awaitIndexesOnline(10L, TimeUnit.SECONDS);
        this.commit();
        if (this.bridge.hasTransaction()) {
            throw new IllegalStateException("Dangling transaction before running visitable");
        }
        GraphDbStructureGuide analyzer = new GraphDbStructureGuide(this.graph);
        analyzer.accept(visitor);
    }

    private void commit() {
        try {
            this.statement().close();
            this.tx.success();
        }
        finally {
            this.tx.close();
        }
    }
}

