/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.rule.concurrent;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import org.junit.Assert;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;

public class ThreadRepository
implements TestRule {
    private Repository repository;
    private final long timeout;
    private final TimeUnit unit;

    public ThreadRepository(long timeout, TimeUnit unit) {
        this.timeout = timeout;
        this.unit = unit;
    }

    public ThreadInfo execute(Task ... tasks) {
        return this.repository.createThread(null, tasks);
    }

    public ThreadInfo execute(String name, Task ... tasks) {
        return this.repository.createThread(name, tasks);
    }

    public Signal signal() {
        return new Signal(new CountDownLatch(1));
    }

    public Await await() {
        return this.await(1);
    }

    public Await await(int events) {
        return new Await(new CountDownLatch(events));
    }

    public Events events() {
        return new Events();
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                ThreadRepository.this.repository = new Repository(description);
                ArrayList<Throwable> failures = new ArrayList<Throwable>();
                try {
                    base.evaluate();
                }
                catch (Throwable failure) {
                    failures.add(failure);
                }
                finally {
                    ThreadRepository.this.completeThreads(failures);
                }
                MultipleFailureException.assertEmpty(failures);
            }
        };
    }

    private void completeThreads() throws Throwable {
        ArrayList<Throwable> failures = new ArrayList<Throwable>();
        this.completeThreads(failures);
        MultipleFailureException.assertEmpty(failures);
    }

    private void completeThreads(List<Throwable> failures) {
        if (this.repository != null) {
            this.repository.completeAll(failures);
        }
        this.repository = null;
    }

    private static class ThreadStillRunningException
    extends Exception {
        ThreadStillRunningException(TaskThread thread) {
            super('\"' + thread.getName() + "\"; state=" + (Object)((Object)thread.getState()) + "; blockedOn=" + thread.blocker());
            this.setStackTrace(thread.getStackTrace());
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }

    private static class TaskThread
    extends Thread
    implements ThreadInfo {
        private final Task[] tasks;
        private Exception failure;

        TaskThread(String name, Task[] tasks) {
            super(name);
            this.tasks = tasks;
        }

        void complete(List<Throwable> failures, long timeout, TimeUnit unit) throws InterruptedException {
            this.join(unit.toMillis(timeout));
            if (this.isAlive()) {
                failures.add(new ThreadStillRunningException(this));
            }
            if (this.failure != null) {
                failures.add(this.failure);
            }
        }

        @Override
        public void run() {
            try {
                for (Task task : this.tasks) {
                    task.perform();
                }
            }
            catch (Exception e) {
                this.failure = e;
            }
        }

        @Override
        public Object blocker() {
            return LockSupport.getBlocker(this);
        }
    }

    private class Repository {
        private final Description description;
        private int i;
        private final List<TaskThread> threads = new ArrayList<TaskThread>();

        Repository(Description description) {
            this.description = description;
        }

        synchronized TaskThread createThread(String name, Task[] tasks) {
            TaskThread thread = new TaskThread(this.nextName(name), tasks);
            this.threads.add(thread);
            thread.start();
            return thread;
        }

        private String nextName(String name) {
            return this.description.getMethodName() + "-" + ++this.i + (name == null ? "" : ":" + name);
        }

        void completeAll(List<Throwable> failures) {
            for (TaskThread thread : this.threads) {
                try {
                    thread.complete(failures, ThreadRepository.this.timeout, ThreadRepository.this.unit);
                }
                catch (InterruptedException interrupted) {
                    failures.add(interrupted);
                }
            }
        }
    }

    public class Events {
        private final List<String> collected = new CopyOnWriteArrayList<String>();

        private Events() {
        }

        public Task trigger(final String event) {
            return new Task(){

                @Override
                public void perform() throws Exception {
                    Events.this.collected.add(event);
                }
            };
        }

        public void assertInOrder(String ... events) throws Exception {
            try {
                ThreadRepository.this.completeThreads();
            }
            catch (Error | Exception ok) {
                throw ok;
            }
            catch (Throwable throwable) {
                throw new Exception("Unexpected Throwable", throwable);
            }
            Object[] actual = this.collected.toArray(new String[events.length]);
            Assert.assertArrayEquals((Object[])events, (Object[])actual);
        }

        public List<String> snapshot() {
            return new ArrayList<String>(this.collected);
        }
    }

    public static class Await
    implements Task {
        private final CountDownLatch latch;

        private Await(CountDownLatch latch) {
            this.latch = latch;
        }

        public Signal signal() {
            return new Signal(this.latch);
        }

        public void release() {
            this.latch.countDown();
        }

        @Override
        public void perform() throws Exception {
            this.latch.await();
        }
    }

    public static class Signal
    implements Task {
        private final CountDownLatch latch;

        private Signal(CountDownLatch latch) {
            this.latch = latch;
        }

        public Await await() {
            return new Await(this.latch);
        }

        public void awaitNow() throws InterruptedException {
            this.latch.await();
        }

        @Override
        public void perform() throws Exception {
            this.latch.countDown();
        }
    }

    public static interface ThreadInfo {
        public StackTraceElement[] getStackTrace();

        public Object blocker();

        public Thread.State getState();
    }

    public static interface Task {
        public void perform() throws Exception;
    }
}

