/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import java.util.Arrays;
import java.util.Collection;
import java.util.Random;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.unsafe.impl.batchimport.cache.LongArray;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;

@RunWith(value=Parameterized.class)
public class LongArrayTest {
    private final NumberArrayFactory factory;
    private final long seed = System.currentTimeMillis();
    private final Random random = new Random(this.seed);
    private LongArray array;

    @Test
    public void shouldHandleSomeRandomSetAndGet() throws Exception {
        int length = this.random.nextInt(100000) + 100;
        long defaultValue = this.random.nextInt(2) - 1;
        LongArray array = this.newArray(length, defaultValue);
        long[] expected = new long[length];
        Arrays.fill(expected, defaultValue);
        int operations = this.random.nextInt(1000) + 10;
        block4: for (int i = 0; i < operations; ++i) {
            int index = this.random.nextInt(length);
            long value = this.random.nextLong();
            switch (this.random.nextInt(3)) {
                case 0: {
                    array.set((long)index, value);
                    expected[index] = value;
                    continue block4;
                }
                case 1: {
                    Assert.assertEquals((String)("Seed:" + this.seed), (long)expected[index], (long)array.get((long)index));
                    continue block4;
                }
                default: {
                    int items = Math.min(this.random.nextInt(10) + 1, length - index);
                    int toIndex = (index + length / 2) % (length - items);
                    array.swap((long)index, (long)toIndex, items);
                    this.swap(expected, index, toIndex, items);
                }
            }
        }
    }

    @Test
    public void shouldHandleMultipleCallsToClose() throws Exception {
        LongArray array = this.newArray(10, -1L);
        array.close();
        array.close();
    }

    private void swap(long[] expected, int fromIndex, int toIndex, int items) {
        for (int i = 0; i < items; ++i) {
            long fromValue = expected[fromIndex + i];
            expected[fromIndex + i] = expected[toIndex + i];
            expected[toIndex + i] = fromValue;
        }
    }

    @Parameterized.Parameters
    public static Collection<NumberArrayFactory> data() {
        return Arrays.asList(NumberArrayFactory.HEAP, NumberArrayFactory.OFF_HEAP);
    }

    public LongArrayTest(NumberArrayFactory factory) {
        this.factory = factory;
    }

    private LongArray newArray(int length, long defaultValue) {
        this.array = this.factory.newLongArray((long)length, defaultValue);
        return this.array;
    }

    @After
    public void after() {
        this.array.close();
    }
}

