/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.labelscan;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.cursor.RawCursor;
import org.neo4j.index.internal.gbptree.Hit;
import org.neo4j.kernel.impl.index.labelscan.LabelScanKey;
import org.neo4j.kernel.impl.index.labelscan.LabelScanValue;

class LabelScanValueIterator
extends PrimitiveLongCollections.PrimitiveLongBaseIterator {
    private final RawCursor<Hit<LabelScanKey, LabelScanValue>, IOException> cursor;
    private long baseNodeId;
    private long bits;
    private int prevLabel = -1;
    private long prevRange = -1L;

    LabelScanValueIterator(RawCursor<Hit<LabelScanKey, LabelScanValue>, IOException> cursor) {
        this.cursor = cursor;
    }

    protected boolean fetchNext() {
        Hit hit;
        while (true) {
            if (this.bits != 0L) {
                return this.nextFromCurrent();
            }
            try {
                if (!this.cursor.next()) {
                    return false;
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            hit = (Hit)this.cursor.get();
            this.baseNodeId = ((LabelScanKey)hit.key()).idRange * 64L;
            this.bits = ((LabelScanValue)hit.value()).bits;
            assert (this.keysInOrder((LabelScanKey)hit.key()));
        }
    }

    private boolean keysInOrder(LabelScanKey key) {
        assert (key.labelId >= this.prevLabel) : "Expected to get ordered results, got " + key + " where previous label was " + this.prevLabel;
        assert (key.idRange > this.prevRange) : "Expected to get ordered results, got " + key + " where previous range was " + this.prevRange;
        this.prevLabel = key.labelId;
        this.prevRange = key.idRange;
        return true;
    }

    private boolean nextFromCurrent() {
        int delta = Long.numberOfTrailingZeros(this.bits);
        this.bits &= this.bits - 1L;
        return this.next(this.baseNodeId + (long)delta);
    }
}

