/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.GraphDatabaseServiceCleaner;
import org.neo4j.test.rule.ImpermanentDatabaseRule;

public class CreateAndDeleteNodesIT {
    @Rule
    public ImpermanentDatabaseRule dbRule = new ImpermanentDatabaseRule();

    @Test
    public void addingALabelUsingAValidIdentifierShouldSucceed() throws Exception {
        GraphDatabaseAPI dataBase = this.dbRule.getGraphDatabaseAPI();
        try (Transaction bobTransaction = dataBase.beginTx();){
            Node myNode = dataBase.createNode();
            myNode.setProperty("Name", (Object)"Bob");
            myNode.createRelationshipTo(dataBase.createNode(), (RelationshipType)RelTypes.ASD);
            bobTransaction.success();
        }
        GraphDatabaseServiceCleaner.cleanupAllRelationshipsAndNodes((GraphDatabaseService)dataBase);
    }

    static enum RelTypes implements RelationshipType
    {
        ASD;

    }
}

