/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.io.File;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.kernel.api.impl.labelscan.LabelScanStoreTest;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.api.labelscan.LabelScanWriter;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.storageengine.api.schema.LabelScanReader;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.EmbeddedDatabaseRule;
import org.neo4j.test.rule.RandomRule;

public abstract class LabelScanStoreStartupIT {
    private static final Label LABEL = Label.label((String)"testLabel");
    @Rule
    public final DatabaseRule dbRule = new EmbeddedDatabaseRule(this.getClass()){

        @Override
        protected void configure(GraphDatabaseBuilder builder) {
            LabelScanStoreStartupIT.this.addSpecificConfig(builder);
        }
    };
    @Rule
    public final RandomRule random = new RandomRule();
    private int labelId;

    protected abstract void addSpecificConfig(GraphDatabaseBuilder var1);

    @Test
    public void scanStoreStartWithoutExistentIndex() throws IOException {
        LabelScanStore labelScanStore = this.getLabelScanStore();
        labelScanStore.shutdown();
        this.deleteLabelScanStoreFiles(this.dbRule.getStoreDirFile());
        labelScanStore.init();
        labelScanStore.start();
        this.checkLabelScanStoreAccessible(labelScanStore);
    }

    @Test
    public void scanStoreRecreateCorruptedIndexOnStartup() throws IOException {
        LabelScanStore labelScanStore = this.getLabelScanStore();
        this.createTestNode();
        long[] labels = this.readNodesForLabel(labelScanStore);
        Assert.assertEquals((String)"Label scan store see 1 label for node", (long)1L, (long)labels.length);
        labelScanStore.force(IOLimiter.unlimited());
        labelScanStore.shutdown();
        this.corruptLabelScanStoreFiles(this.dbRule.getStoreDirFile());
        labelScanStore.init();
        labelScanStore.start();
        long[] rebuildLabels = this.readNodesForLabel(labelScanStore);
        Assert.assertArrayEquals((String)"Store should rebuild corrupted index", (long[])labels, (long[])rebuildLabels);
    }

    private LabelScanStore getLabelScanStore() {
        return (LabelScanStore)this.dbRule.getDependencyResolver().resolveDependency(LabelScanStore.class);
    }

    private long[] readNodesForLabel(LabelScanStore labelScanStore) {
        try (LabelScanReader reader = labelScanStore.newReader();){
            long[] lArray = PrimitiveLongCollections.asArray((PrimitiveLongIterator)reader.nodesWithLabel(this.labelId));
            return lArray;
        }
    }

    private Node createTestNode() {
        Node node;
        try (Transaction transaction = this.dbRule.beginTx();){
            node = this.dbRule.createNode(LABEL);
            this.labelId = ((ThreadToStatementContextBridge)this.dbRule.getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class)).getKernelTransactionBoundToThisThread(true).acquireStatement().readOperations().labelGetForName(LABEL.name());
            transaction.success();
        }
        return node;
    }

    protected void scrambleFile(File file) throws IOException {
        LabelScanStoreTest.scrambleFile(this.random.random(), file);
    }

    protected abstract void corruptLabelScanStoreFiles(File var1) throws IOException;

    protected abstract void deleteLabelScanStoreFiles(File var1) throws IOException;

    private void checkLabelScanStoreAccessible(LabelScanStore labelScanStore) throws IOException {
        int labelId = 1;
        try (LabelScanWriter labelScanWriter = labelScanStore.newWriter();){
            labelScanWriter.write(NodeLabelUpdate.labelChanges((long)1L, (long[])new long[0], (long[])new long[]{labelId}));
        }
        var4_4 = null;
        try (LabelScanReader labelScanReader = labelScanStore.newReader();){
            Assert.assertEquals((long)1L, (long)labelScanReader.nodesWithLabel(labelId).next());
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
    }
}

