/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import org.junit.Test;
import org.neo4j.graphdb.AbstractMandatoryTransactionsTest;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipFacadeMethods;
import org.neo4j.graphdb.RelationshipType;

public class MandatoryTransactionsForRelationshipTest
extends AbstractMandatoryTransactionsTest<Relationship> {
    @Test
    public void shouldRequireTransactionsWhenCallingMethodsOnRelationshipFacade() throws Exception {
        MandatoryTransactionsForRelationshipTest.assertFacadeMethodsThrowNotInTransaction(this.obtainEntity(), RelationshipFacadeMethods.ALL_RELATIONSHIP_FACADE_METHODS);
    }

    @Test
    public void shouldTerminateWhenCallingMethodsOnRelationshipFacade() throws Exception {
        this.assertFacadeMethodsThrowAfterTerminate(RelationshipFacadeMethods.ALL_RELATIONSHIP_FACADE_METHODS);
    }

    @Override
    protected Relationship obtainEntityInTransaction(GraphDatabaseService graphDatabaseService) {
        return graphDatabaseService.createNode().createRelationshipTo(graphDatabaseService.createNode(), RelationshipType.withName((String)"foo"));
    }
}

