/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;

public class NodePropertyAccessor
implements PropertyAccessor {
    private final Map<Long, Map<Integer, Object>> nodePropertyMap = new HashMap<Long, Map<Integer, Object>>();

    NodePropertyAccessor(long nodeId, LabelSchemaDescriptor schema, Object ... values) {
        this.addNode(nodeId, schema, values);
    }

    public void addNode(long nodeId, LabelSchemaDescriptor schema, Object ... values) {
        HashMap<Integer, Object> propertyMap = new HashMap<Integer, Object>();
        for (int i = 0; i < schema.getPropertyIds().length; ++i) {
            propertyMap.put(schema.getPropertyIds()[i], values[i]);
        }
        this.nodePropertyMap.put(nodeId, propertyMap);
    }

    public Property getProperty(long nodeId, int propertyKeyId) throws EntityNotFoundException {
        if (this.nodePropertyMap.containsKey(nodeId)) {
            Object value = this.nodePropertyMap.get(nodeId).get(propertyKeyId);
            if (value == null) {
                return Property.noNodeProperty((long)nodeId, (int)propertyKeyId);
            }
            return Property.property((int)propertyKeyId, (Object)value);
        }
        return Property.noNodeProperty((long)nodeId, (int)propertyKeyId);
    }
}

