/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.LabelSchemaSupplier;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.impl.api.index.NodeUpdates;
import org.neo4j.kernel.impl.api.index.PropertyLoader;

public class NodeUpdatesTest {
    private static final long nodeId = 0L;
    private static final int labelId = 0;
    private static final int propertyKeyId1 = 0;
    private static final int propertyKeyId2 = 1;
    private static final long[] labels = new long[]{0L};
    private static final long[] empty = new long[0];
    private static final LabelSchemaDescriptor index1 = SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{0});
    private static final LabelSchemaDescriptor index2 = SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{1});
    private static final LabelSchemaDescriptor index12 = SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{0, 1});
    private static final List<LabelSchemaDescriptor> indexes = Arrays.asList(index1, index2, index12);
    private static final DefinedProperty property1 = Property.stringProperty((int)0, (String)"Neo");
    private static final DefinedProperty property2 = Property.longProperty((int)1, (long)100L);
    private static final Object[] values12 = new Object[]{property1.value(), property2.value()};

    @Test
    public void shouldNotGenerateUpdatesForEmptyNodeUpdates() {
        NodeUpdates updates = NodeUpdates.forNode((long)0L).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(indexes, this.assertNoLoading()), (Matcher)Matchers.emptyIterable());
    }

    @Test
    public void shouldNotGenerateUpdateForMultipleExistingPropertiesAndLabels() {
        NodeUpdates updates = NodeUpdates.forNode((long)0L, (long[])labels).buildWithExistingProperties(new DefinedProperty[]{property1, property2});
        MatcherAssert.assertThat((Object)updates.forIndexKeys(indexes, this.assertNoLoading()), (Matcher)Matchers.emptyIterable());
    }

    @Test
    public void shouldNotGenerateUpdatesForLabelAdditionWithNoProperties() {
        NodeUpdates updates = NodeUpdates.forNode((long)0L, (long[])empty, (long[])labels).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(indexes, this.propertyLoader(new DefinedProperty[0])), (Matcher)Matchers.emptyIterable());
    }

    @Test
    public void shouldGenerateUpdateForLabelAdditionWithExistingProperty() {
        NodeUpdates updates = NodeUpdates.forNode((long)0L, (long[])empty, (long[])labels).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(indexes, this.propertyLoader(property1)), (Matcher)Matchers.containsInAnyOrder((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.add((long)0L, (LabelSchemaSupplier)index1, (Object[])new Object[]{property1.value()})}));
    }

    @Test
    public void shouldGenerateUpdatesForLabelAdditionWithExistingProperties() {
        NodeUpdates updates = NodeUpdates.forNode((long)0L, (long[])empty, (long[])labels).buildWithExistingProperties(new DefinedProperty[]{property1, property2});
        MatcherAssert.assertThat((Object)updates.forIndexKeys(indexes, this.propertyLoader(property1, property2)), (Matcher)Matchers.containsInAnyOrder((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.add((long)0L, (LabelSchemaSupplier)index1, (Object[])new Object[]{property1.value()}), IndexEntryUpdate.add((long)0L, (LabelSchemaSupplier)index2, (Object[])new Object[]{property2.value()}), IndexEntryUpdate.add((long)0L, (LabelSchemaSupplier)index12, (Object[])values12)}));
    }

    @Test
    public void shouldNotGenerateUpdatesForLabelRemovalWithNoProperties() {
        NodeUpdates updates = NodeUpdates.forNode((long)0L, (long[])labels, (long[])empty).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(indexes, this.propertyLoader(new DefinedProperty[0])), (Matcher)Matchers.emptyIterable());
    }

    @Test
    public void shouldGenerateUpdateForLabelRemovalWithExistingProperty() {
        NodeUpdates updates = NodeUpdates.forNode((long)0L, (long[])labels, (long[])empty).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(indexes, this.propertyLoader(property1)), (Matcher)Matchers.containsInAnyOrder((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.remove((long)0L, (LabelSchemaSupplier)index1, (Object[])new Object[]{property1.value()})}));
    }

    @Test
    public void shouldGenerateUpdatesForLabelRemovalWithExistingProperties() {
        NodeUpdates updates = NodeUpdates.forNode((long)0L, (long[])labels, (long[])empty).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(indexes, this.propertyLoader(property1, property2)), (Matcher)Matchers.containsInAnyOrder((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.remove((long)0L, (LabelSchemaSupplier)index1, (Object[])new Object[]{property1.value()}), IndexEntryUpdate.remove((long)0L, (LabelSchemaSupplier)index2, (Object[])new Object[]{property2.value()}), IndexEntryUpdate.remove((long)0L, (LabelSchemaSupplier)index12, (Object[])values12)}));
    }

    @Test
    public void shouldNotGenerateUpdatesForPropertyAdditionWithNoLabels() {
        NodeUpdates updates = NodeUpdates.forNode((long)0L).added(property1.propertyKeyId(), property1.value()).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(indexes, this.assertNoLoading()), (Matcher)Matchers.emptyIterable());
    }

    @Test
    public void shouldGenerateUpdatesForSinglePropertyAdditionWithLabels() {
        NodeUpdates updates = NodeUpdates.forNode((long)0L, (long[])labels).added(property1.propertyKeyId(), property1.value()).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(indexes, this.propertyLoader(new DefinedProperty[0])), (Matcher)Matchers.containsInAnyOrder((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.add((long)0L, (LabelSchemaSupplier)index1, (Object[])new Object[]{property1.value()})}));
    }

    @Test
    public void shouldGenerateUpdatesForMultiplePropertyAdditionWithLabels() {
        NodeUpdates updates = NodeUpdates.forNode((long)0L, (long[])labels).added(property1.propertyKeyId(), property1.value()).added(property2.propertyKeyId(), property2.value()).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(indexes, this.propertyLoader(property1, property2)), (Matcher)Matchers.containsInAnyOrder((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.add((long)0L, (LabelSchemaSupplier)index1, (Object[])new Object[]{property1.value()}), IndexEntryUpdate.add((long)0L, (LabelSchemaSupplier)index2, (Object[])new Object[]{property2.value()}), IndexEntryUpdate.add((long)0L, (LabelSchemaSupplier)index12, (Object[])values12)}));
    }

    @Test
    public void shouldNotGenerateUpdatesForLabelAddAndPropertyRemove() {
        NodeUpdates updates = NodeUpdates.forNode((long)0L, (long[])empty, (long[])labels).removed(property1.propertyKeyId(), property1.value()).removed(property2.propertyKeyId(), property2.value()).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(indexes, this.assertNoLoading()), (Matcher)Matchers.emptyIterable());
    }

    @Test
    public void shouldNotGenerateUpdatesForLabelRemoveAndPropertyAdd() {
        NodeUpdates updates = NodeUpdates.forNode((long)0L, (long[])labels, (long[])empty).added(property1.propertyKeyId(), property1.value()).added(property2.propertyKeyId(), property2.value()).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(indexes, this.assertNoLoading()), (Matcher)Matchers.emptyIterable());
    }

    @Test
    public void shouldNotLoadPropertyForLabelsAndNoPropertyChanges() {
        NodeUpdates updates = NodeUpdates.forNode((long)0L, (long[])labels).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(Collections.singleton(index1), this.assertNoLoading()), (Matcher)Matchers.emptyIterable());
    }

    @Test
    public void shouldNotLoadPropertyForNoLabelsAndButPropertyAddition() {
        NodeUpdates updates = NodeUpdates.forNode((long)0L, (long[])empty).added(property1.propertyKeyId(), property1.value()).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(Collections.singleton(index1), this.assertNoLoading()), (Matcher)Matchers.emptyIterable());
    }

    private PropertyLoader propertyLoader(DefinedProperty ... properties) {
        HashMap<Integer, Object> propertyMap = new HashMap<Integer, Object>();
        for (DefinedProperty p : properties) {
            propertyMap.put(p.propertyKeyId(), p.value());
        }
        return (nodeId1, propertyIds, sink) -> {
            for (int propertyId : propertyIds) {
                if (!propertyMap.containsKey(propertyId)) continue;
                sink.onProperty(propertyId, propertyMap.get(propertyId));
                propertyIds.remove(propertyId);
            }
        };
    }

    private PropertyLoader assertNoLoading() {
        return (nodeId1, propertyIds, sink) -> Assert.fail((String)"Should never attempt to load properties!");
    }
}

