/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;

public class DefinedPropertyTest {
    @Test
    public void shouldSortStringPropertiesWithSameValueByPropertyKeyId() {
        DefinedProperty p1 = Property.stringProperty((int)1, (String)"x");
        DefinedProperty p2 = Property.stringProperty((int)2, (String)"x");
        Assert.assertThat((Object)this.compare(p1, p2), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0)));
    }

    @Test
    public void shouldSortStringPropertiesWithDifferentValueByPropertyKeyId() {
        DefinedProperty p1 = Property.stringProperty((int)1, (String)"x");
        DefinedProperty p2 = Property.stringProperty((int)2, (String)"y");
        Assert.assertThat((Object)this.compare(p1, p2), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0)));
    }

    @Test
    public void shouldSortStringPropertiesWithSamePropertyKeyIdByValue() {
        DefinedProperty p1 = Property.stringProperty((int)1, (String)"x");
        DefinedProperty p2 = Property.stringProperty((int)1, (String)"y");
        Assert.assertThat((Object)this.compare(p1, p2), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0)));
    }

    @Test
    public void shouldSortIntPropertiesWithSameValueByPropertyKeyId() {
        DefinedProperty p1 = Property.intProperty((int)1, (int)10);
        DefinedProperty p2 = Property.intProperty((int)2, (int)10);
        Assert.assertThat((Object)this.compare(p1, p2), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0)));
    }

    @Test
    public void shouldSortIntPropertiesWithDifferentValueByPropertyKeyId() {
        DefinedProperty p1 = Property.intProperty((int)1, (int)10);
        DefinedProperty p2 = Property.intProperty((int)2, (int)20);
        Assert.assertThat((Object)this.compare(p1, p2), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0)));
    }

    @Test
    public void shouldSortIntPropertiesWithSamePropertyKeyIdByValue() {
        DefinedProperty p1 = Property.intProperty((int)1, (int)10);
        DefinedProperty p2 = Property.intProperty((int)1, (int)20);
        Assert.assertThat((Object)this.compare(p1, p2), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0)));
    }

    @Test
    public void shouldSortDoublePropertiesWithSameValueByPropertyKeyId() {
        DefinedProperty p1 = Property.doubleProperty((int)1, (double)10.0);
        DefinedProperty p2 = Property.doubleProperty((int)2, (double)10.0);
        Assert.assertThat((Object)this.compare(p1, p2), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0)));
    }

    @Test
    public void shouldSortDoublePropertiesWithDifferentValueByPropertyKeyId() {
        DefinedProperty p1 = Property.doubleProperty((int)1, (double)10.0);
        DefinedProperty p2 = Property.doubleProperty((int)2, (double)20.0);
        Assert.assertThat((Object)this.compare(p1, p2), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0)));
    }

    @Test
    public void shouldSortDoublePropertiesWithSamePropertyKeyIdByValue() {
        DefinedProperty p1 = Property.doubleProperty((int)1, (double)10.0);
        DefinedProperty p2 = Property.doubleProperty((int)1, (double)20.0);
        Assert.assertThat((Object)this.compare(p1, p2), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0)));
    }

    @Test
    public void shouldSortIntAndDoublePropertiesWithSamePropertyKeyIdByValue() {
        DefinedProperty p1 = Property.intProperty((int)1, (int)10);
        DefinedProperty p2 = Property.doubleProperty((int)1, (double)20.0);
        Assert.assertThat((Object)this.compare(p1, p2), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0)));
    }

    @Test
    public void shouldSortDoubleAndStringPropertiesWithSamePropertyKeyIdByValue() {
        DefinedProperty p1 = Property.doubleProperty((int)1, (double)10.0);
        DefinedProperty p2 = Property.stringProperty((int)1, (String)"20");
        Assert.assertThat((Object)this.compare(p1, p2), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
    }

    @Test
    public void shouldSortStringAndIntPropertiesWithSamePropertyKeyIdByValue() {
        DefinedProperty p1 = Property.stringProperty((int)1, (String)"10");
        DefinedProperty p2 = Property.intProperty((int)1, (int)20);
        Assert.assertThat((Object)this.compare(p1, p2), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0)));
    }

    @Test
    public void shouldFindIntAndDoubleEqualForPropertiesWithSamePropertyKeyIdAndValue() {
        DefinedProperty p1 = Property.intProperty((int)1, (int)10);
        DefinedProperty p2 = Property.doubleProperty((int)1, (double)10.0);
        Assert.assertThat((Object)this.compare(p1, p2), (Matcher)Matchers.equalTo((Object)0));
    }

    @Test
    public void shouldSortLazyStringAndNonLazyStringPropertiesByValue() {
        DefinedProperty p1 = Property.lazyStringProperty((int)1, () -> "x");
        DefinedProperty p2 = Property.stringProperty((int)1, (String)"y");
        Assert.assertThat((Object)this.compare(p1, p2), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0)));
    }

    private int compare(DefinedProperty leftProperty, DefinedProperty rightProperty) {
        int leftComparison = DefinedProperty.COMPARATOR.compare(leftProperty, rightProperty);
        int rightComparison = DefinedProperty.COMPARATOR.compare(rightProperty, leftProperty);
        Assert.assertThat((Object)this.sign(leftComparison), (Matcher)Matchers.equalTo((Object)(-this.sign(rightComparison))));
        return leftComparison;
    }

    private int sign(int value) {
        return value == 0 ? 0 : (value < 0 ? -1 : 1);
    }
}

