/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.builtinprocs;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptorFactory;
import org.neo4j.kernel.builtinprocs.IndexProcedures;
import org.neo4j.kernel.builtinprocs.StubKernelTransaction;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingMode;
import org.neo4j.storageengine.api.schema.SchemaRule;

public class ResampleIndexProcedureTest {
    private final ReadOperations operations = (ReadOperations)Mockito.mock(ReadOperations.class);
    private final IndexingService indexingService = (IndexingService)Mockito.mock(IndexingService.class);
    private final IndexProcedures procedure = new IndexProcedures((KernelTransaction)new StubKernelTransaction(this.operations), this.indexingService);

    @Test
    public void shouldThrowAnExceptionIfTheLabelDoesntExist() throws ProcedureException {
        Mockito.when((Object)this.operations.labelGetForName("NonExistentLabel")).thenReturn((Object)-1);
        try {
            this.procedure.resampleIndex(":NonExistentLabel(prop)");
            Assert.fail((String)"Expected an exception");
        }
        catch (ProcedureException e) {
            Assert.assertThat((Object)e.status(), (Matcher)Matchers.is((Object)Status.Schema.LabelAccessFailed));
        }
    }

    @Test
    public void shouldThrowAnExceptionIfThePropertyKeyDoesntExist() throws ProcedureException {
        Mockito.when((Object)this.operations.propertyKeyGetForName("nonExistentProperty")).thenReturn((Object)-1);
        try {
            this.procedure.resampleIndex(":Label(nonExistentProperty)");
            Assert.fail((String)"Expected an exception");
        }
        catch (ProcedureException e) {
            Assert.assertThat((Object)e.status(), (Matcher)Matchers.is((Object)Status.Schema.PropertyKeyAccessFailed));
        }
    }

    @Test
    public void shouldLookUpTheIndexByLabelIdAndPropertyKeyId() throws ProcedureException, SchemaRuleNotFoundException, IndexNotFoundKernelException {
        IndexDescriptor index = IndexDescriptorFactory.forLabel((int)0, (int[])new int[]{0});
        Mockito.when((Object)this.operations.labelGetForName(org.mockito.Matchers.anyString())).thenReturn((Object)123);
        Mockito.when((Object)this.operations.propertyKeyGetForName(org.mockito.Matchers.anyString())).thenReturn((Object)456);
        Mockito.when((Object)this.operations.indexGetForSchema((LabelSchemaDescriptor)org.mockito.Matchers.anyObject())).thenReturn((Object)index);
        this.procedure.resampleIndex(":Person(name)");
        ((ReadOperations)Mockito.verify((Object)this.operations)).indexGetForSchema(SchemaDescriptorFactory.forLabel((int)123, (int[])new int[]{456}));
    }

    @Test
    public void shouldLookUpTheCompositeIndexByLabelIdAndPropertyKeyId() throws ProcedureException, SchemaRuleNotFoundException, IndexNotFoundKernelException {
        IndexDescriptor index = IndexDescriptorFactory.forLabel((int)0, (int[])new int[]{0, 1});
        Mockito.when((Object)this.operations.labelGetForName(org.mockito.Matchers.anyString())).thenReturn((Object)123);
        Mockito.when((Object)this.operations.propertyKeyGetForName("name")).thenReturn((Object)0);
        Mockito.when((Object)this.operations.propertyKeyGetForName("lastName")).thenReturn((Object)1);
        Mockito.when((Object)this.operations.indexGetForSchema(SchemaDescriptorFactory.forLabel((int)123, (int[])new int[]{0, 1}))).thenReturn((Object)index);
        this.procedure.resampleIndex(":Person(name, lastName)");
        ((ReadOperations)Mockito.verify((Object)this.operations)).indexGetForSchema(SchemaDescriptorFactory.forLabel((int)123, (int[])new int[]{0, 1}));
    }

    @Test
    public void shouldThrowAnExceptionIfTheIndexDoesNotExist() throws SchemaRuleNotFoundException, IndexNotFoundKernelException {
        Mockito.when((Object)this.operations.labelGetForName(org.mockito.Matchers.anyString())).thenReturn((Object)0);
        Mockito.when((Object)this.operations.propertyKeyGetForName(org.mockito.Matchers.anyString())).thenReturn((Object)0);
        Mockito.when((Object)this.operations.indexGetForSchema((LabelSchemaDescriptor)org.mockito.Matchers.any())).thenThrow(new Throwable[]{new SchemaRuleNotFoundException(SchemaRule.Kind.INDEX_RULE, (SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{0}))});
        try {
            this.procedure.resampleIndex(":Person(name)");
            Assert.fail((String)"Expected an exception");
        }
        catch (ProcedureException e) {
            Assert.assertThat((Object)e.status(), (Matcher)Matchers.is((Object)Status.Schema.IndexNotFound));
        }
    }

    @Test
    public void shouldTriggerResampling() throws SchemaRuleNotFoundException, ProcedureException, IndexNotFoundKernelException {
        IndexDescriptor index = IndexDescriptorFactory.forLabel((int)123, (int[])new int[]{456});
        Mockito.when((Object)this.operations.indexGetForSchema((LabelSchemaDescriptor)org.mockito.Matchers.anyObject())).thenReturn((Object)index);
        this.procedure.resampleIndex(":Person(name)");
        ((IndexingService)Mockito.verify((Object)this.indexingService)).triggerIndexSampling(index.schema(), IndexSamplingMode.TRIGGER_REBUILD_ALL);
    }
}

