/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.builtinprocs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.collection.RawIterator;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.SchemaWriteOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.proc.ProcedureSignature;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;

public class SchemaProcedureIT
extends KernelIntegrationTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void testEmptyGraph() throws Throwable {
        RawIterator stream = this.procedureCallOpsInNewTx().procedureCallRead(ProcedureSignature.procedureName((String[])new String[]{"db", "schema"}), new Object[0]);
        MatcherAssert.assertThat((Object)Iterators.asList((RawIterator)stream), (Matcher)Matchers.contains((Matcher)IsEqual.equalTo((Object)new Object[]{new ArrayList(), new ArrayList()})));
    }

    @Test
    public void testLabelIndex() throws Throwable {
        Statement statement = this.statementInNewTransaction((SecurityContext)AnonymousContext.writeToken());
        long nodeId = statement.dataWriteOperations().nodeCreate();
        int labelId = statement.tokenWriteOperations().labelGetOrCreateForName("Person");
        statement.dataWriteOperations().nodeAddLabel(nodeId, labelId);
        int propertyIdName = statement.tokenWriteOperations().propertyKeyGetOrCreateForName("name");
        int propertyIdAge = statement.tokenWriteOperations().propertyKeyGetOrCreateForName("age");
        statement.dataWriteOperations().nodeSetProperty(nodeId, DefinedProperty.stringProperty((int)propertyIdName, (String)"Emil"));
        this.commit();
        SchemaWriteOperations schemaOps = this.schemaWriteOperationsInNewTransaction();
        schemaOps.indexCreate(SchemaDescriptorFactory.forLabel((int)labelId, (int[])new int[]{propertyIdName}));
        schemaOps.uniquePropertyConstraintCreate(SchemaDescriptorFactory.forLabel((int)labelId, (int[])new int[]{propertyIdAge}));
        this.commit();
        RawIterator stream = this.procedureCallOpsInNewTx().procedureCallRead(ProcedureSignature.procedureName((String[])new String[]{"db", "schema"}), new Object[0]);
        while (stream.hasNext()) {
            Object[] next = (Object[])stream.next();
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            ArrayList nodes = (ArrayList)next[0];
            Assert.assertTrue((nodes.size() == 1 ? 1 : 0) != 0);
            MatcherAssert.assertThat((Object)((Node)nodes.get(0)).getLabels(), (Matcher)Matchers.contains((Matcher)IsEqual.equalTo((Object)Label.label((String)"Person"))));
            Assert.assertEquals((Object)new String("Person"), ((Node)nodes.get(0)).getAllProperties().get("name"));
            Assert.assertEquals(Arrays.asList("name"), ((Node)nodes.get(0)).getAllProperties().get("indexes"));
            Assert.assertEquals(Arrays.asList("CONSTRAINT ON ( person:Person ) ASSERT person.age IS UNIQUE"), ((Node)nodes.get(0)).getAllProperties().get("constraints"));
        }
    }

    @Test
    public void testRelationShip() throws Throwable {
        Statement statement = this.statementInNewTransaction((SecurityContext)AnonymousContext.writeToken());
        long nodeIdPerson = statement.dataWriteOperations().nodeCreate();
        int labelIdPerson = statement.tokenWriteOperations().labelGetOrCreateForName("Person");
        statement.dataWriteOperations().nodeAddLabel(nodeIdPerson, labelIdPerson);
        long nodeIdLocation = statement.dataWriteOperations().nodeCreate();
        int labelIdLocation = statement.tokenWriteOperations().labelGetOrCreateForName("Location");
        statement.dataWriteOperations().nodeAddLabel(nodeIdLocation, labelIdLocation);
        int relationshipTypeId = statement.tokenWriteOperations().relationshipTypeGetOrCreateForName("LIVES_IN");
        statement.dataWriteOperations().relationshipCreate(relationshipTypeId, nodeIdPerson, nodeIdLocation);
        this.commit();
        RawIterator stream = this.procedureCallOpsInNewTx().procedureCallRead(ProcedureSignature.procedureName((String[])new String[]{"db", "schema"}), new Object[0]);
        while (stream.hasNext()) {
            Object[] next = (Object[])stream.next();
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            LinkedList relationships = (LinkedList)next[1];
            Assert.assertTrue((relationships.size() == 1 ? 1 : 0) != 0);
            Assert.assertEquals((Object)"LIVES_IN", (Object)((Relationship)relationships.get(0)).getType().name());
            MatcherAssert.assertThat((Object)((Relationship)relationships.get(0)).getStartNode().getLabels(), (Matcher)Matchers.contains((Matcher)IsEqual.equalTo((Object)Label.label((String)"Person"))));
            MatcherAssert.assertThat((Object)((Relationship)relationships.get(0)).getEndNode().getLabels(), (Matcher)Matchers.contains((Matcher)IsEqual.equalTo((Object)Label.label((String)"Location"))));
        }
    }
}

