/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.helpers.ListenSocketAddress;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.Settings;

public class AdvertisedAddressSettingsTest {
    private static Setting<ListenSocketAddress> listen_address_setting = Settings.listenAddress((String)"listen_address", (int)1234);
    private static Setting<AdvertisedSocketAddress> advertised_address_setting = Settings.advertisedAddress((String)"advertised_address", listen_address_setting);

    @Test
    public void shouldParseExplicitSettingValueWhenProvided() throws Exception {
        Map config = MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.default_advertised_address.name(), "server1.example.com", advertised_address_setting.name(), "server1.internal:4000"});
        AdvertisedSocketAddress advertisedSocketAddress = (AdvertisedSocketAddress)advertised_address_setting.apply(config::get);
        Assert.assertEquals((Object)"server1.internal", (Object)advertisedSocketAddress.getHostname());
        Assert.assertEquals((long)4000L, (long)advertisedSocketAddress.getPort());
    }

    @Test
    public void shouldCombineDefaultHostnameWithPortFromListenAddressSettingWhenNoValueProvided() throws Exception {
        Map config = MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.default_advertised_address.name(), "server1.example.com"});
        AdvertisedSocketAddress advertisedSocketAddress = (AdvertisedSocketAddress)advertised_address_setting.apply(config::get);
        Assert.assertEquals((Object)"server1.example.com", (Object)advertisedSocketAddress.getHostname());
        Assert.assertEquals((long)1234L, (long)advertisedSocketAddress.getPort());
    }

    @Test
    public void shouldCombineDefaultHostnameWithExplicitPortWhenOnlyAPortProvided() throws Exception {
        Map config = MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.default_advertised_address.name(), "server1.example.com", advertised_address_setting.name(), ":4000"});
        AdvertisedSocketAddress advertisedSocketAddress = (AdvertisedSocketAddress)advertised_address_setting.apply(config::get);
        Assert.assertEquals((Object)"server1.example.com", (Object)advertisedSocketAddress.getHostname());
        Assert.assertEquals((long)4000L, (long)advertisedSocketAddress.getPort());
    }
}

