/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.neo4j.graphdb.config.InvalidSettingException;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.Connector;
import org.neo4j.kernel.configuration.HttpConnector;
import org.neo4j.kernel.configuration.HttpConnectorValidator;

public class HttpConnectorValidatorTest {
    HttpConnectorValidator cv = new HttpConnectorValidator();
    @Rule
    public ExpectedException expected = ExpectedException.none();
    Consumer<String> warningConsumer = (Consumer)Mockito.mock(Consumer.class);

    @Test
    public void doesNotValidateUnrelatedStuff() throws Exception {
        Assert.assertEquals((long)0L, (long)this.cv.validate(MapUtil.stringMap((String[])new String[]{"dbms.connector.bolt.enabled", "true", "dbms.blabla.boo", "123"}), this.warningConsumer).size());
    }

    @Test
    public void onlyEnabledRequiredWhenNameIsHttpOrHttps() throws Exception {
        String httpEnabled = "dbms.connector.http.enabled";
        String httpsEnabled = "dbms.connector.https.enabled";
        Assert.assertEquals((Object)MapUtil.stringMap((String[])new String[]{httpEnabled, "true"}), (Object)this.cv.validate(MapUtil.stringMap((String[])new String[]{httpEnabled, "true"}), this.warningConsumer));
        Assert.assertEquals((Object)MapUtil.stringMap((String[])new String[]{httpsEnabled, "true"}), (Object)this.cv.validate(MapUtil.stringMap((String[])new String[]{httpsEnabled, "true"}), this.warningConsumer));
    }

    @Test
    public void requiresTypeWhenNameIsNotHttpOrHttps() throws Exception {
        String randomEnabled = "dbms.connector.bla.enabled";
        String randomType = "dbms.connector.bla.type";
        Assert.assertEquals((Object)MapUtil.stringMap((String[])new String[]{randomEnabled, "true", randomType, Connector.ConnectorType.HTTP.name()}), (Object)this.cv.validate(MapUtil.stringMap((String[])new String[]{randomEnabled, "true", randomType, Connector.ConnectorType.HTTP.name()}), this.warningConsumer));
        this.expected.expect(InvalidSettingException.class);
        this.expected.expectMessage("Missing mandatory value for 'dbms.connector.bla.type'");
        this.cv.validate(MapUtil.stringMap((String[])new String[]{randomEnabled, "true"}), this.warningConsumer);
    }

    @Test
    public void warnsWhenNameIsNotHttpOrHttps() throws Exception {
        String randomEnabled = "dbms.connector.bla.enabled";
        String randomType = "dbms.connector.bla.type";
        this.cv.validate(MapUtil.stringMap((String[])new String[]{randomEnabled, "true", randomType, "HTTP"}), this.warningConsumer);
        ((Consumer)Mockito.verify(this.warningConsumer)).accept(String.format("Warning: connectors with names other than [http,https,bolt] are%ndeprecated and support for them will be removed in a future%nversion of Neo4j. Offending lines in neo4j.conf:%n%n%s", String.format(">  %s%n>  %s%n", randomEnabled, randomType)));
    }

    @Test
    public void errorsOnInvalidConnectorSetting1() throws Exception {
        String invalidSetting = "dbms.connector.bla.0.enabled";
        this.expected.expect(InvalidSettingException.class);
        this.expected.expectMessage("Invalid connector setting: dbms.connector.bla.0.enabled");
        this.cv.validate(MapUtil.stringMap((String[])new String[]{invalidSetting, "true"}), this.warningConsumer);
    }

    @Test
    public void errorsOnInvalidConnectorSetting2() throws Exception {
        String invalidSetting = "dbms.connector.http.foobar";
        this.expected.expect(InvalidSettingException.class);
        this.expected.expectMessage("Invalid connector setting: dbms.connector.http.foobar");
        this.cv.validate(MapUtil.stringMap((String[])new String[]{invalidSetting, "true"}), this.warningConsumer);
    }

    @Test
    public void validatesEncryption() throws Exception {
        String key = "dbms.connector.bla.encryption";
        String type = "dbms.connector.bla.type";
        Assert.assertEquals((Object)MapUtil.stringMap((String[])new String[]{key, HttpConnector.Encryption.NONE.name(), type, Connector.ConnectorType.HTTP.name()}), (Object)this.cv.validate(MapUtil.stringMap((String[])new String[]{key, HttpConnector.Encryption.NONE.name(), type, Connector.ConnectorType.HTTP.name()}), this.warningConsumer));
        Assert.assertEquals((Object)MapUtil.stringMap((String[])new String[]{key, HttpConnector.Encryption.TLS.name(), type, Connector.ConnectorType.HTTP.name()}), (Object)this.cv.validate(MapUtil.stringMap((String[])new String[]{key, HttpConnector.Encryption.TLS.name(), type, Connector.ConnectorType.HTTP.name()}), this.warningConsumer));
        this.expected.expect(InvalidSettingException.class);
        this.expected.expectMessage("Bad value 'BOBO' for setting 'dbms.connector.bla.encryption': must be one of [NONE, TLS] case sensitive");
        this.cv.validate(MapUtil.stringMap((String[])new String[]{key, "BOBO", type, Connector.ConnectorType.HTTP.name()}), this.warningConsumer);
    }

    @Test
    public void httpsConnectorCanOnlyHaveTLS() throws Exception {
        String key = "dbms.connector.https.encryption";
        Assert.assertEquals((Object)MapUtil.stringMap((String[])new String[]{key, HttpConnector.Encryption.TLS.name()}), (Object)this.cv.validate(MapUtil.stringMap((String[])new String[]{key, HttpConnector.Encryption.TLS.name()}), this.warningConsumer));
        this.expected.expect(InvalidSettingException.class);
        this.expected.expectMessage("'dbms.connector.https.encryption' is only allowed to be 'TLS'; not 'NONE'");
        this.cv.validate(MapUtil.stringMap((String[])new String[]{key, HttpConnector.Encryption.NONE.name()}), this.warningConsumer);
    }

    @Test
    public void httpConnectorCanNotHaveTLS() throws Exception {
        String key = "dbms.connector.http.encryption";
        Assert.assertEquals((Object)MapUtil.stringMap((String[])new String[]{key, HttpConnector.Encryption.NONE.name()}), (Object)this.cv.validate(MapUtil.stringMap((String[])new String[]{key, HttpConnector.Encryption.NONE.name()}), this.warningConsumer));
        this.expected.expect(InvalidSettingException.class);
        this.expected.expectMessage("'dbms.connector.http.encryption' is only allowed to be 'NONE'; not 'TLS'");
        this.cv.validate(MapUtil.stringMap((String[])new String[]{key, HttpConnector.Encryption.TLS.name()}), this.warningConsumer);
    }

    @Test
    public void validatesAddress() throws Exception {
        String key = "dbms.connector.http.address";
        Assert.assertEquals((Object)MapUtil.stringMap((String[])new String[]{key, "localhost:123"}), (Object)this.cv.validate(MapUtil.stringMap((String[])new String[]{key, "localhost:123"}), this.warningConsumer));
        key = "dbms.connector.bla.address";
        String type = "dbms.connector.bla.type";
        Assert.assertEquals((Object)MapUtil.stringMap((String[])new String[]{key, "localhost:123", type, Connector.ConnectorType.HTTP.name()}), (Object)this.cv.validate(MapUtil.stringMap((String[])new String[]{key, "localhost:123", type, Connector.ConnectorType.HTTP.name()}), this.warningConsumer));
        Assert.assertEquals((Object)MapUtil.stringMap((String[])new String[]{key, "localhost:123", type, Connector.ConnectorType.HTTP.name()}), (Object)this.cv.validate(MapUtil.stringMap((String[])new String[]{key, "localhost:123", type, Connector.ConnectorType.HTTP.name()}), this.warningConsumer));
        this.expected.expect(InvalidSettingException.class);
        this.expected.expectMessage("Setting \"dbms.connector.bla.address\" must be in the format \"hostname:port\" or \":port\". \"BOBO\" does not conform to these formats");
        this.cv.validate(MapUtil.stringMap((String[])new String[]{key, "BOBO", type, Connector.ConnectorType.HTTP.name()}), this.warningConsumer);
    }

    @Test
    public void validatesListenAddress() throws Exception {
        String key = "dbms.connector.http.listen_address";
        Assert.assertEquals((Object)MapUtil.stringMap((String[])new String[]{key, "localhost:123"}), (Object)this.cv.validate(MapUtil.stringMap((String[])new String[]{key, "localhost:123"}), this.warningConsumer));
        key = "dbms.connector.bla.listen_address";
        String type = "dbms.connector.bla.type";
        Assert.assertEquals((Object)MapUtil.stringMap((String[])new String[]{key, "localhost:123", type, Connector.ConnectorType.HTTP.name()}), (Object)this.cv.validate(MapUtil.stringMap((String[])new String[]{key, "localhost:123", type, Connector.ConnectorType.HTTP.name()}), this.warningConsumer));
        Assert.assertEquals((Object)MapUtil.stringMap((String[])new String[]{key, "localhost:123", type, Connector.ConnectorType.HTTP.name()}), (Object)this.cv.validate(MapUtil.stringMap((String[])new String[]{key, "localhost:123", type, Connector.ConnectorType.HTTP.name()}), this.warningConsumer));
        this.expected.expect(InvalidSettingException.class);
        this.expected.expectMessage("Setting \"dbms.connector.bla.listen_address\" must be in the format \"hostname:port\" or \":port\". \"BOBO\" does not conform to these formats");
        this.cv.validate(MapUtil.stringMap((String[])new String[]{key, "BOBO", type, Connector.ConnectorType.HTTP.name()}), this.warningConsumer);
    }

    @Test
    public void validatesAdvertisedAddress() throws Exception {
        String key = "dbms.connector.http.advertised_address";
        Assert.assertEquals((Object)MapUtil.stringMap((String[])new String[]{key, "localhost:123"}), (Object)this.cv.validate(MapUtil.stringMap((String[])new String[]{key, "localhost:123"}), this.warningConsumer));
        key = "dbms.connector.bla.advertised_address";
        String type = "dbms.connector.bla.type";
        Assert.assertEquals((Object)MapUtil.stringMap((String[])new String[]{key, "localhost:123", type, Connector.ConnectorType.HTTP.name()}), (Object)this.cv.validate(MapUtil.stringMap((String[])new String[]{key, "localhost:123", type, Connector.ConnectorType.HTTP.name()}), this.warningConsumer));
        Assert.assertEquals((Object)MapUtil.stringMap((String[])new String[]{key, "localhost:123", type, Connector.ConnectorType.HTTP.name()}), (Object)this.cv.validate(MapUtil.stringMap((String[])new String[]{key, "localhost:123", type, Connector.ConnectorType.HTTP.name()}), this.warningConsumer));
        this.expected.expect(InvalidSettingException.class);
        this.expected.expectMessage("Setting \"dbms.connector.bla.advertised_address\" must be in the format \"hostname:port\" or \":port\". \"BOBO\" does not conform to these formats");
        this.cv.validate(MapUtil.stringMap((String[])new String[]{key, "BOBO", type, Connector.ConnectorType.HTTP.name()}), this.warningConsumer);
    }

    @Test
    public void validatesType() throws Exception {
        String type = "dbms.connector.bla.type";
        this.expected.expect(InvalidSettingException.class);
        this.expected.expectMessage("'dbms.connector.bla.type' must be one of BOLT, HTTP; not 'BOBO'");
        this.cv.validate(MapUtil.stringMap((String[])new String[]{type, "BOBO"}), this.warningConsumer);
    }

    @Test
    public void setsDeprecationFlagOnAddress() throws Exception {
        Setting setting = (Setting)this.cv.getSettingFor("dbms.connector.http.address", Collections.emptyMap()).orElseThrow(() -> new RuntimeException("missing setting!"));
        Assert.assertTrue((boolean)setting.deprecated());
        Assert.assertEquals(Optional.of("dbms.connector.http.listen_address"), (Object)setting.replacement());
    }

    @Test
    public void setsDeprecationFlagOnEncryption() throws Exception {
        Setting setting = (Setting)this.cv.getSettingFor("dbms.connector.http.encryption", Collections.emptyMap()).orElseThrow(() -> new RuntimeException("missing setting!"));
        Assert.assertTrue((boolean)setting.deprecated());
        Assert.assertEquals(Optional.empty(), (Object)setting.replacement());
    }

    @Test
    public void sdfa() throws Exception {
        Setting setting = (Setting)this.cv.getSettingFor("dbms.connector.http.type", Collections.emptyMap()).orElseThrow(() -> new RuntimeException("missing setting!"));
        Assert.assertTrue((boolean)setting.deprecated());
        Assert.assertEquals(Optional.empty(), (Object)setting.replacement());
    }

    @Test
    public void setsDeprecationFlagOnType() throws Exception {
        Setting setting = (Setting)this.cv.getSettingFor("dbms.connector.http.type", Collections.emptyMap()).orElseThrow(() -> new RuntimeException("missing setting!"));
        Assert.assertTrue((boolean)setting.deprecated());
        Assert.assertEquals(Optional.empty(), (Object)setting.replacement());
    }

    @Test
    public void setsDeprecationFlagOnCustomNamedHttpConnectors() throws Exception {
        List settings = this.cv.settings(MapUtil.stringMap((String[])new String[]{"dbms.connector.0.type", "HTTP", "dbms.connector.0.enabled", "false", "dbms.connector.0.listen_address", "1.2.3.4:123", "dbms.connector.0.advertised_address", "localhost:123", "dbms.connector.0.encryption", HttpConnector.Encryption.NONE.toString()}));
        Assert.assertEquals((long)5L, (long)settings.size());
        for (Setting s : settings) {
            Assert.assertTrue((String)("every setting should be deprecated: " + s.name()), (boolean)s.deprecated());
            String[] parts = s.name().split("\\.");
            if ("encryption".equals(parts[3]) || "type".equals(parts[3])) continue;
            Assert.assertEquals(Optional.of(String.format("%s.%s.%s.%s", parts[0], parts[1], "http", parts[3])), (Object)s.replacement());
        }
    }

    @Test
    public void setsDeprecationFlagOnCustomNamedHttpsConnectors() throws Exception {
        List settings = this.cv.settings(MapUtil.stringMap((String[])new String[]{"dbms.connector.0.type", "HTTP", "dbms.connector.0.enabled", "false", "dbms.connector.0.listen_address", "1.2.3.4:123", "dbms.connector.0.advertised_address", "localhost:123", "dbms.connector.0.encryption", HttpConnector.Encryption.TLS.toString()}));
        Assert.assertEquals((long)5L, (long)settings.size());
        for (Setting s : settings) {
            Assert.assertTrue((String)("every setting should be deprecated: " + s.name()), (boolean)s.deprecated());
            String[] parts = s.name().split("\\.");
            if ("encryption".equals(parts[3]) || "type".equals(parts[3])) continue;
            Assert.assertEquals(Optional.of(String.format("%s.%s.%s.%s", parts[0], parts[1], "https", parts[3])), (Object)s.replacement());
        }
    }
}

