/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.io.File;
import java.net.URI;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.config.BaseSetting;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.config.InvalidSettingException;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.Settings;

public class SettingsTest {
    @Test
    public void parsesAbsolutePaths() {
        File absolutePath = new File("some/path").getAbsoluteFile();
        File thePath = (File)Settings.PATH.apply(absolutePath.toString());
        Assert.assertEquals((Object)absolutePath, (Object)thePath);
    }

    @Test
    public void doesntAllowRelativePaths() {
        File relativePath = new File("some/path");
        try {
            Settings.PATH.apply(relativePath.toString());
            Assert.fail((String)"Expected an exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void pathSettingsProvideDefaultValues() {
        File theDefault = new File("/some/path").getAbsoluteFile();
        Setting setting = Settings.pathSetting((String)"some.setting", (String)theDefault.getAbsolutePath());
        Assert.assertThat((Object)setting.from((Configuration)Config.empty()), (Matcher)Matchers.is((Object)theDefault));
    }

    @Test
    public void pathSettingsAreNullIfThereIsNoValueAndNoDefault() {
        Setting setting = Settings.pathSetting((String)"some.setting", (String)Settings.NO_DEFAULT);
        Assert.assertThat((Object)setting.from((Configuration)Config.empty()), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void shouldHaveAUsefulToStringWhichIsUsedAsTheValidValuesInDocumentation() {
        Assert.assertThat((Object)Settings.pathSetting((String)"", (String)Settings.NO_DEFAULT).toString(), (Matcher)Matchers.containsString((String)"A filesystem path"));
    }

    @Test
    public void testInteger() {
        BaseSetting setting = Settings.setting((String)"foo", (Function)Settings.INTEGER, (String)"3");
        Assert.assertThat((Object)setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"foo", "4"}))), (Matcher)CoreMatchers.equalTo((Object)4));
        try {
            setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"foo", "bar"})));
            Assert.fail();
        }
        catch (InvalidSettingException invalidSettingException) {
            // empty catch block
        }
    }

    @Test
    public void testList() {
        BaseSetting setting = Settings.setting((String)"foo", (Function)Settings.list((String)",", (Function)Settings.INTEGER), (String)"1,2,3,4");
        Assert.assertThat((Object)((List)setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[0])))).toString(), (Matcher)CoreMatchers.equalTo((Object)"[1, 2, 3, 4]"));
        BaseSetting setting2 = Settings.setting((String)"foo", (Function)Settings.list((String)",", (Function)Settings.INTEGER), (String)"1,2,3,4,");
        Assert.assertThat((Object)((List)setting2.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[0])))).toString(), (Matcher)CoreMatchers.equalTo((Object)"[1, 2, 3, 4]"));
        BaseSetting setting3 = Settings.setting((String)"foo", (Function)Settings.list((String)",", (Function)Settings.INTEGER), (String)"");
        Assert.assertThat((Object)((List)setting3.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[0])))).toString(), (Matcher)CoreMatchers.equalTo((Object)"[]"));
        BaseSetting setting4 = Settings.setting((String)"foo", (Function)Settings.list((String)",", (Function)Settings.INTEGER), (String)"1,    2,3, 4,   5  ");
        Assert.assertThat((Object)((List)setting4.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[0])))).toString(), (Matcher)CoreMatchers.equalTo((Object)"[1, 2, 3, 4, 5]"));
        BaseSetting setting5 = Settings.setting((String)"foo", (Function)Settings.list((String)",", (Function)Settings.INTEGER), (String)"1,    2,3, 4,   ");
        Assert.assertThat((Object)((List)setting5.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[0])))).toString(), (Matcher)CoreMatchers.equalTo((Object)"[1, 2, 3, 4]"));
    }

    @Test
    public void testStringList() {
        BaseSetting setting1 = Settings.setting((String)"apa", (Function)Settings.STRING_LIST, (String)"foo,bar,baz");
        Assert.assertEquals(Arrays.asList("foo", "bar", "baz"), (Object)setting1.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[0]))));
        BaseSetting setting2 = Settings.setting((String)"apa", (Function)Settings.STRING_LIST, (String)"foo,  bar, BAZ   ");
        Assert.assertEquals(Arrays.asList("foo", "bar", "BAZ"), (Object)setting2.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[0]))));
        BaseSetting setting3 = Settings.setting((String)"apa", (Function)Settings.STRING_LIST, (String)"");
        Assert.assertEquals(Collections.emptyList(), (Object)setting3.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[0]))));
    }

    @Test
    public void testMin() {
        BaseSetting setting = Settings.setting((String)"foo", (Function)Settings.INTEGER, (String)"3", (BiFunction[])new BiFunction[]{Settings.min((Comparable)Integer.valueOf(2))});
        Assert.assertThat((Object)setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"foo", "4"}))), (Matcher)CoreMatchers.equalTo((Object)4));
        try {
            setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"foo", "1"})));
            Assert.fail();
        }
        catch (InvalidSettingException invalidSettingException) {
            // empty catch block
        }
    }

    @Test
    public void testMax() {
        BaseSetting setting = Settings.setting((String)"foo", (Function)Settings.INTEGER, (String)"3", (BiFunction[])new BiFunction[]{Settings.max((Comparable)Integer.valueOf(5))});
        Assert.assertThat((Object)setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"foo", "4"}))), (Matcher)CoreMatchers.equalTo((Object)4));
        try {
            setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"foo", "7"})));
            Assert.fail();
        }
        catch (InvalidSettingException invalidSettingException) {
            // empty catch block
        }
    }

    @Test
    public void testRange() {
        BaseSetting setting = Settings.setting((String)"foo", (Function)Settings.INTEGER, (String)"3", (BiFunction[])new BiFunction[]{Settings.range((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(5))});
        Assert.assertThat((Object)setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"foo", "4"}))), (Matcher)CoreMatchers.equalTo((Object)4));
        try {
            setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"foo", "1"})));
            Assert.fail();
        }
        catch (InvalidSettingException invalidSettingException) {
            // empty catch block
        }
        try {
            setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"foo", "6"})));
            Assert.fail();
        }
        catch (InvalidSettingException invalidSettingException) {
            // empty catch block
        }
    }

    @Test
    public void testMatches() {
        BaseSetting setting = Settings.setting((String)"foo", (Function)Settings.STRING, (String)"abc", (BiFunction[])new BiFunction[]{Settings.matches((String)"a*b*c*")});
        Assert.assertThat((Object)setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"foo", "aaabbbccc"}))), (Matcher)CoreMatchers.equalTo((Object)"aaabbbccc"));
        try {
            setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"foo", "cba"})));
            Assert.fail();
        }
        catch (InvalidSettingException invalidSettingException) {
            // empty catch block
        }
    }

    @Test(expected=InvalidSettingException.class)
    public void testDurationWithBrokenDefault() {
        BaseSetting setting = Settings.setting((String)"foo.bar", (Function)Settings.DURATION, (String)"1s", (BiFunction[])new BiFunction[]{Settings.min((Comparable)((Comparable)Settings.DURATION.apply("3s")))});
        setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[0])));
    }

    @Test(expected=InvalidSettingException.class)
    public void testDurationWithValueNotWithinConstraint() {
        BaseSetting setting = Settings.setting((String)"foo.bar", (Function)Settings.DURATION, (String)"3s", (BiFunction[])new BiFunction[]{Settings.min((Comparable)((Comparable)Settings.DURATION.apply("3s")))});
        setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"foo.bar", "2s"})));
    }

    @Test
    public void testDuration() {
        BaseSetting setting = Settings.setting((String)"foo.bar", (Function)Settings.DURATION, (String)"3s", (BiFunction[])new BiFunction[]{Settings.min((Comparable)((Comparable)Settings.DURATION.apply("3s")))});
        Assert.assertThat((Object)setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"foo.bar", "4s"}))), (Matcher)CoreMatchers.equalTo((Object)Duration.ofSeconds(4L)));
    }

    @Test
    public void testDefault() {
        BaseSetting setting = Settings.setting((String)"foo", (Function)Settings.INTEGER, (String)"3");
        Assert.assertThat((Object)setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[0]))), (Matcher)CoreMatchers.equalTo((Object)3));
    }

    @Test
    public void testMandatory() {
        BaseSetting setting = Settings.setting((String)"foo", (Function)Settings.INTEGER, (String)Settings.MANDATORY);
        try {
            setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[0])));
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testPaths() {
        File directory = new File("myDirectory");
        BaseSetting home = Settings.setting((String)"home", (Function)Settings.PATH, (String)directory.getAbsolutePath());
        BaseSetting config = Settings.setting((String)"config", (Function)Settings.PATH, (String)new File(directory, "config.properties").getAbsolutePath(), (BiFunction[])new BiFunction[]{Settings.basePath((Setting)home), Settings.isFile});
        Assert.assertThat((Object)((File)config.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[0])))).getAbsolutePath(), (Matcher)CoreMatchers.equalTo((Object)new File(directory, "config.properties").getAbsolutePath()));
    }

    @Test
    public void testInheritOneLevel() {
        BaseSetting root = Settings.setting((String)"root", (Function)Settings.INTEGER, (String)"4");
        Setting setting = Settings.setting((String)"foo", (Function)Settings.INTEGER, (Setting)root);
        Assert.assertThat((Object)setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"foo", "1"}))), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[0]))), (Matcher)CoreMatchers.equalTo((Object)4));
    }

    @Test
    public void testInheritHierarchy() {
        BaseSetting a = Settings.setting((String)"A", (Function)Settings.STRING, (String)"A");
        BaseSetting b = Settings.setting((String)"B", (Function)Settings.STRING, (String)"B", (Setting)a, (BiFunction[])new BiFunction[0]);
        BaseSetting c = Settings.setting((String)"C", (Function)Settings.STRING, (String)"C", (Setting)b, (BiFunction[])new BiFunction[0]);
        Setting d = Settings.setting((String)"D", (Function)Settings.STRING, (Setting)b);
        Setting e = Settings.setting((String)"E", (Function)Settings.STRING, (Setting)d);
        Assert.assertThat((Object)c.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"C", "X"}))), (Matcher)CoreMatchers.equalTo((Object)"X"));
        Assert.assertThat((Object)c.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"B", "X"}))), (Matcher)CoreMatchers.equalTo((Object)"X"));
        Assert.assertThat((Object)c.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"A", "X"}))), (Matcher)CoreMatchers.equalTo((Object)"X"));
        Assert.assertThat((Object)c.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"A", "Y", "B", "X"}))), (Matcher)CoreMatchers.equalTo((Object)"X"));
        Assert.assertThat((Object)d.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[0]))), (Matcher)CoreMatchers.equalTo((Object)"B"));
        Assert.assertThat((Object)e.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[0]))), (Matcher)CoreMatchers.equalTo((Object)"B"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMandatoryApplyToInherited() {
        BaseSetting x = Settings.setting((String)"X", (Function)Settings.STRING, (String)Settings.NO_DEFAULT);
        BaseSetting y = Settings.setting((String)"Y", (Function)Settings.STRING, (String)Settings.MANDATORY, (Setting)x, (BiFunction[])new BiFunction[0]);
        y.apply(always -> null);
    }

    @Test
    public void testLogicalLogRotationThreshold() throws Exception {
        Setting setting = GraphDatabaseSettings.logical_log_rotation_threshold;
        long defaultValue = (Long)setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[0])));
        long megaValue = (Long)setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{setting.name(), "10M"})));
        long gigaValue = (Long)setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{setting.name(), "10g"})));
        Assert.assertThat((Object)defaultValue, (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
        Assert.assertEquals((long)0xA00000L, (long)megaValue);
        Assert.assertEquals((long)0x280000000L, (long)gigaValue);
    }

    @Test
    public void testNormalizedRelativeURI() throws Exception {
        BaseSetting uri = Settings.setting((String)"mySetting", (Function)Settings.NORMALIZED_RELATIVE_URI, (String)"http://localhost:7474///db///data///");
        Assert.assertThat((Object)((URI)uri.apply(always -> null)).toString(), (Matcher)CoreMatchers.equalTo((Object)"/db/data"));
    }

    public static <From, To> Function<From, To> map(Map<From, To> map) {
        return from -> map.get(from);
    }
}

