/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration.ssl;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ssl.SslPolicyConfig;
import org.neo4j.ssl.ClientAuth;
import org.neo4j.test.rule.TestDirectory;

public class SslPolicyConfigTest {
    @Rule
    public TestDirectory testDirectory = TestDirectory.testDirectory();

    @Test
    public void shouldFindPolicyDefaults() throws Exception {
        Config config = Config.empty();
        Map params = MapUtil.stringMap((String[])new String[0]);
        String policyName = "XYZ";
        SslPolicyConfig policyConfig = new SslPolicyConfig(policyName);
        File homeDir = this.testDirectory.directory("home");
        params.put(GraphDatabaseSettings.neo4j_home.name(), homeDir.getAbsolutePath());
        params.put(policyConfig.base_directory.name(), "certificates/XYZ");
        config.augment(params);
        File privateKey = new File(homeDir, "certificates/XYZ/private.key");
        File publicCertificate = new File(homeDir, "certificates/XYZ/public.crt");
        File trustedDir = new File(homeDir, "certificates/XYZ/trusted");
        File revokedDir = new File(homeDir, "certificates/XYZ/revoked");
        File privateKeyFromConfig = (File)policyConfig.private_key.from((Configuration)config);
        File publicCertificateFromConfig = (File)policyConfig.public_certificate.from((Configuration)config);
        File trustedDirFromConfig = (File)policyConfig.trusted_dir.from((Configuration)config);
        File revokedDirFromConfig = (File)policyConfig.revoked_dir.from((Configuration)config);
        String privateKeyPassword = (String)policyConfig.private_key_password.from((Configuration)config);
        boolean allowKeyGeneration = (Boolean)policyConfig.allow_key_generation.from((Configuration)config);
        boolean trustAll = (Boolean)policyConfig.trust_all.from((Configuration)config);
        List tlsVersions = (List)policyConfig.tls_versions.from((Configuration)config);
        List ciphers = (List)policyConfig.ciphers.from((Configuration)config);
        ClientAuth clientAuth = (ClientAuth)policyConfig.client_auth.from((Configuration)config);
        Assert.assertEquals((Object)privateKey, (Object)privateKeyFromConfig);
        Assert.assertEquals((Object)publicCertificate, (Object)publicCertificateFromConfig);
        Assert.assertEquals((Object)trustedDir, (Object)trustedDirFromConfig);
        Assert.assertEquals((Object)revokedDir, (Object)revokedDirFromConfig);
        Assert.assertEquals(null, (Object)privateKeyPassword);
        Assert.assertFalse((boolean)allowKeyGeneration);
        Assert.assertFalse((boolean)trustAll);
        Assert.assertEquals(Arrays.asList("TLSv1.2", "TLSv1.1", "TLSv1"), (Object)tlsVersions);
        Assert.assertNull((Object)ciphers);
        Assert.assertEquals((Object)ClientAuth.REQUIRE, (Object)clientAuth);
    }

    @Test
    public void shouldFindPolicyOverrides() throws Exception {
        Config config = Config.empty();
        Map params = MapUtil.stringMap((String[])new String[0]);
        String policyName = "XYZ";
        SslPolicyConfig policyConfig = new SslPolicyConfig(policyName);
        File homeDir = this.testDirectory.directory("home");
        params.put(GraphDatabaseSettings.neo4j_home.name(), homeDir.getAbsolutePath());
        params.put(policyConfig.base_directory.name(), "certificates/XYZ");
        File privateKey = this.testDirectory.directory("/path/to/my.key");
        File publicCertificate = this.testDirectory.directory("/path/to/my.crt");
        File trustedDir = this.testDirectory.directory("/some/other/path/to/trusted");
        File revokedDir = this.testDirectory.directory("/some/other/path/to/revoked");
        params.put(policyConfig.private_key.name(), privateKey.getAbsolutePath());
        params.put(policyConfig.public_certificate.name(), publicCertificate.getAbsolutePath());
        params.put(policyConfig.trusted_dir.name(), trustedDir.getAbsolutePath());
        params.put(policyConfig.revoked_dir.name(), revokedDir.getAbsolutePath());
        params.put(policyConfig.allow_key_generation.name(), "true");
        params.put(policyConfig.trust_all.name(), "true");
        params.put(policyConfig.private_key_password.name(), "setecastronomy");
        params.put(policyConfig.tls_versions.name(), "TLSv1.1,TLSv1.2");
        params.put(policyConfig.ciphers.name(), "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384,TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384");
        params.put(policyConfig.client_auth.name(), "optional");
        config.augment(params);
        File privateKeyFromConfig = (File)policyConfig.private_key.from((Configuration)config);
        File publicCertificateFromConfig = (File)policyConfig.public_certificate.from((Configuration)config);
        File trustedDirFromConfig = (File)policyConfig.trusted_dir.from((Configuration)config);
        File revokedDirFromConfig = (File)policyConfig.revoked_dir.from((Configuration)config);
        String privateKeyPassword = (String)policyConfig.private_key_password.from((Configuration)config);
        boolean allowKeyGeneration = (Boolean)policyConfig.allow_key_generation.from((Configuration)config);
        boolean trustAll = (Boolean)policyConfig.trust_all.from((Configuration)config);
        List tlsVersions = (List)policyConfig.tls_versions.from((Configuration)config);
        List ciphers = (List)policyConfig.ciphers.from((Configuration)config);
        ClientAuth clientAuth = (ClientAuth)policyConfig.client_auth.from((Configuration)config);
        Assert.assertEquals((Object)privateKey, (Object)privateKeyFromConfig);
        Assert.assertEquals((Object)publicCertificate, (Object)publicCertificateFromConfig);
        Assert.assertEquals((Object)trustedDir, (Object)trustedDirFromConfig);
        Assert.assertEquals((Object)revokedDir, (Object)revokedDirFromConfig);
        Assert.assertTrue((boolean)allowKeyGeneration);
        Assert.assertTrue((boolean)trustAll);
        Assert.assertEquals((Object)"setecastronomy", (Object)privateKeyPassword);
        Assert.assertEquals(Arrays.asList("TLSv1.1", "TLSv1.2"), (Object)tlsVersions);
        Assert.assertEquals(Arrays.asList("TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384"), (Object)ciphers);
        Assert.assertEquals((Object)ClientAuth.OPTIONAL, (Object)clientAuth);
    }

    @Test
    public void shouldFailWithIncompletePathOverrides() throws Exception {
        Config config = Config.empty();
        Map params = MapUtil.stringMap((String[])new String[0]);
        String policyName = "XYZ";
        SslPolicyConfig policyConfig = new SslPolicyConfig(policyName);
        File homeDir = this.testDirectory.directory("home");
        params.put(GraphDatabaseSettings.neo4j_home.name(), homeDir.getAbsolutePath());
        params.put(policyConfig.base_directory.name(), "certificates");
        params.put(policyConfig.private_key.name(), "my.key");
        params.put(policyConfig.public_certificate.name(), "path/to/my.crt");
        config.augment(params);
        try {
            policyConfig.private_key.from((Configuration)config);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            policyConfig.public_certificate.from((Configuration)config);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

