/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration.ssl;

import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.config.InvalidSettingException;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.ssl.SslPolicyConfigValidator;

public class SslPolicyConfigValidatorTest {
    private Consumer<String> warnings = (Consumer)Mockito.mock(Consumer.class);

    @Test
    public void shouldAcceptAllValidPolicyKeys() {
        SslPolicyConfigValidator validator = new SslPolicyConfigValidator();
        Map<String, String> originalParams = SslPolicyConfigValidatorTest.params("dbms.ssl.policy.default.base_directory", "xyz", "dbms.ssl.policy.default.allow_key_generation", "xyz", "dbms.ssl.policy.default.trust_all", "xyz", "dbms.ssl.policy.default.private_key", "xyz", "dbms.ssl.policy.default.private_key_password", "xyz", "dbms.ssl.policy.default.public_certificate", "xyz", "dbms.ssl.policy.default.trusted_dir", "xyz", "dbms.ssl.policy.default.revoked_dir", "xyz", "dbms.ssl.policy.default.client_auth", "xyz", "dbms.ssl.policy.default.tls_versions", "xyz", "dbms.ssl.policy.default.ciphers", "xyz");
        Map validatedParams = validator.validate(originalParams, this.warnings);
        Assert.assertEquals(originalParams, (Object)validatedParams);
    }

    @Test
    public void shouldThrowOnUnknownPolicySetting() {
        SslPolicyConfigValidator validator = new SslPolicyConfigValidator();
        Map<String, String> originalParams = SslPolicyConfigValidatorTest.params("dbms.ssl.policy.default.color", "blue");
        try {
            validator.validate(originalParams, this.warnings);
            Assert.fail();
        }
        catch (InvalidSettingException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Invalid setting name"));
        }
    }

    @Test
    public void shouldThrowOnDirectPolicySetting() {
        SslPolicyConfigValidator validator = new SslPolicyConfigValidator();
        Map<String, String> originalParams = SslPolicyConfigValidatorTest.params("dbms.ssl.policy.base_directory", "path");
        try {
            validator.validate(originalParams, this.warnings);
            Assert.fail();
        }
        catch (InvalidSettingException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Invalid setting name"));
        }
    }

    @Test
    public void shouldIgnoreUnknownNonPolicySettings() throws Exception {
        SslPolicyConfigValidator validator = new SslPolicyConfigValidator();
        Map<String, String> originalParams = SslPolicyConfigValidatorTest.params("dbms.ssl.unknown", "xyz", "dbms.ssl.something", "xyz", "dbms.unrelated.totally", "xyz");
        Map validatedParams = validator.validate(originalParams, this.warnings);
        Assert.assertTrue((boolean)validatedParams.isEmpty());
    }

    @Test
    public void shouldComplainWhenMissingMandatoryBaseDirectory() {
        SslPolicyConfigValidator validator = new SslPolicyConfigValidator();
        Map<String, String> originalParams = SslPolicyConfigValidatorTest.params("dbms.ssl.policy.default.private_key", "private.key", "dbms.ssl.policy.default.public_certificate", "public.crt");
        try {
            validator.validate(originalParams, this.warnings);
            Assert.fail();
        }
        catch (InvalidSettingException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Missing mandatory setting"));
        }
    }

    private static Map<String, String> params(String ... params) {
        return Collections.unmodifiableMap(MapUtil.stringMap((String[])params));
    }
}

