/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.extension;

import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.extension.KernelExtensions;
import org.neo4j.kernel.extension.UnsatisfiedDependencyStrategy;
import org.neo4j.kernel.impl.spi.KernelContext;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.impl.util.UnsatisfiedDependencyException;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class KernelExtensionsTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldConsultUnsatisfiedDependencyHandler() throws Exception {
        KernelContext context = (KernelContext)Mockito.mock(KernelContext.class);
        UnsatisfiedDependencyStrategy handler = (UnsatisfiedDependencyStrategy)Mockito.mock(UnsatisfiedDependencyStrategy.class);
        Dependencies dependencies = new Dependencies();
        TestingExtensionFactory extensionFactory = new TestingExtensionFactory();
        KernelExtensions extensions = new KernelExtensions(context, this.extensions(extensionFactory), dependencies, handler);
        LifeSupport life = new LifeSupport();
        life.add((Lifecycle)extensions);
        try {
            life.start();
            ((UnsatisfiedDependencyStrategy)Mockito.verify((Object)handler)).handle((KernelExtensionFactory)Matchers.eq((Object)((Object)extensionFactory)), (UnsatisfiedDependencyException)Matchers.any(UnsatisfiedDependencyException.class));
        }
        finally {
            life.shutdown();
        }
    }

    private Iterable<KernelExtensionFactory<?>> extensions(TestingExtensionFactory extension) {
        return Iterables.iterable((Object[])new TestingExtensionFactory[]{extension});
    }

    private static class TestingExtension
    extends LifecycleAdapter {
        TestingExtension(JobScheduler jobScheduler) {
        }
    }

    private static class TestingExtensionFactory
    extends KernelExtensionFactory<TestingDependencies> {
        TestingExtensionFactory() {
            super("testing");
        }

        public Lifecycle newInstance(KernelContext context, TestingDependencies dependencies) throws Throwable {
            return new TestingExtension(dependencies.jobScheduler());
        }
    }

    private static interface TestingDependencies {
        public JobScheduler jobScheduler();
    }
}

