/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.extension.dependency;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.dependency.NamedLabelScanStoreSelectionStrategy;
import org.neo4j.kernel.impl.api.scan.LabelScanStoreProvider;

public class NamedLabelScanStoreSelectionStrategyTest {
    @Test
    public void shouldSelectSpecificallyConfiguredProviderWhenSingle() throws Exception {
        NamedLabelScanStoreSelectionStrategy strategy = this.strategy(GraphDatabaseSettings.LabelIndex.NATIVE);
        LabelScanStoreProvider single = this.provider(GraphDatabaseSettings.LabelIndex.NATIVE, this.store(false));
        LabelScanStoreProvider selected = this.select(strategy, single);
        Assert.assertSame((Object)single, (Object)selected);
    }

    @Test
    public void shouldSelectSpecificallyConfiguredProviderAmongMultiple() throws Exception {
        NamedLabelScanStoreSelectionStrategy strategy = this.strategy(GraphDatabaseSettings.LabelIndex.LUCENE);
        LabelScanStoreProvider nativeProvider = this.provider(GraphDatabaseSettings.LabelIndex.NATIVE, this.store(false));
        LabelScanStoreProvider luceneProvider = this.provider(GraphDatabaseSettings.LabelIndex.LUCENE, this.store(false));
        LabelScanStoreProvider selected = this.select(strategy, nativeProvider, luceneProvider);
        Assert.assertSame((Object)luceneProvider, (Object)selected);
    }

    @Test
    public void shouldFailOnMissingSpecificallyConfiguredProvider() throws Exception {
        NamedLabelScanStoreSelectionStrategy strategy = this.strategy(GraphDatabaseSettings.LabelIndex.LUCENE);
        LabelScanStoreProvider nativeProvider = this.provider(GraphDatabaseSettings.LabelIndex.NATIVE, this.store(false));
        try {
            this.select(strategy, nativeProvider);
            Assert.fail((String)"Should've failed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void shouldAutoSelectSingleProviderWithPresentStore() throws Exception {
        NamedLabelScanStoreSelectionStrategy strategy = this.strategy(GraphDatabaseSettings.LabelIndex.AUTO);
        LabelScanStoreProvider nativeProvider = this.provider(GraphDatabaseSettings.LabelIndex.NATIVE, this.store(true));
        LabelScanStoreProvider selected = this.select(strategy, nativeProvider);
        Assert.assertSame((Object)nativeProvider, (Object)selected);
    }

    @Test
    public void shouldAutoSelectSingleProviderWithPresentStoreAmongMultipleProviders() throws Exception {
        NamedLabelScanStoreSelectionStrategy strategy = this.strategy(GraphDatabaseSettings.LabelIndex.AUTO);
        LabelScanStoreProvider nativeProvider = this.provider(GraphDatabaseSettings.LabelIndex.NATIVE, this.store(false));
        LabelScanStoreProvider luceneProvider = this.provider(GraphDatabaseSettings.LabelIndex.LUCENE, this.store(true));
        LabelScanStoreProvider selected = this.select(strategy, nativeProvider, luceneProvider);
        Assert.assertSame((Object)luceneProvider, (Object)selected);
    }

    @Test
    public void shouldAutoSelectDefaultProviderIfNoProviderWithPresentStore() throws Exception {
        NamedLabelScanStoreSelectionStrategy strategy = this.strategy(GraphDatabaseSettings.LabelIndex.AUTO);
        LabelScanStoreProvider nativeProvider = this.provider(GraphDatabaseSettings.LabelIndex.NATIVE, this.store(false));
        LabelScanStoreProvider luceneProvider = this.provider(GraphDatabaseSettings.LabelIndex.LUCENE, this.store(false));
        LabelScanStoreProvider selected = this.select(strategy, nativeProvider, luceneProvider);
        Assert.assertEquals((Object)GraphDatabaseSettings.label_index.getDefaultValue(), (Object)selected.getName());
    }

    @Test
    public void shouldFailAutoSelectIfMultipleProvidersWithPresentStore() throws Exception {
        NamedLabelScanStoreSelectionStrategy strategy = this.strategy(GraphDatabaseSettings.LabelIndex.AUTO);
        LabelScanStoreProvider nativeProvider = this.provider(GraphDatabaseSettings.LabelIndex.NATIVE, this.store(true));
        LabelScanStoreProvider luceneProvider = this.provider(GraphDatabaseSettings.LabelIndex.LUCENE, this.store(true));
        try {
            this.select(strategy, nativeProvider, luceneProvider);
            Assert.fail((String)"Should've failed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void shouldFailAutoSelectIfNoProviderWithPresentStoreAndSomeReportedIOException() throws Exception {
        NamedLabelScanStoreSelectionStrategy strategy = this.strategy(GraphDatabaseSettings.LabelIndex.AUTO);
        LabelScanStoreProvider nativeProvider = this.provider(GraphDatabaseSettings.LabelIndex.NATIVE, this.store(false));
        LabelScanStoreProvider luceneProvider = this.provider(GraphDatabaseSettings.LabelIndex.LUCENE, this.store(null));
        try {
            this.select(strategy, nativeProvider, luceneProvider);
            Assert.fail((String)"Should've failed");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof IOException));
        }
    }

    @Test
    public void shouldAutoSelectProviderWithPresentStoreEvenIfSomeOtherReportedIOException() throws Exception {
        NamedLabelScanStoreSelectionStrategy strategy = this.strategy(GraphDatabaseSettings.LabelIndex.AUTO);
        LabelScanStoreProvider nativeProvider = this.provider(GraphDatabaseSettings.LabelIndex.NATIVE, this.store(true));
        LabelScanStoreProvider luceneProvider = this.provider(GraphDatabaseSettings.LabelIndex.LUCENE, this.store(null));
        LabelScanStoreProvider selected = this.select(strategy, nativeProvider, luceneProvider);
        Assert.assertSame((Object)nativeProvider, (Object)selected);
    }

    private NamedLabelScanStoreSelectionStrategy strategy(GraphDatabaseSettings.LabelIndex index) {
        return new NamedLabelScanStoreSelectionStrategy(Config.defaults().augment(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.label_index.name(), index.name()})));
    }

    private LabelScanStoreProvider provider(GraphDatabaseSettings.LabelIndex index, LabelScanStore store) {
        return new LabelScanStoreProvider(index.name(), store);
    }

    private LabelScanStore store(Boolean present) throws IOException {
        LabelScanStore store = (LabelScanStore)Mockito.mock(LabelScanStore.class);
        if (present == null) {
            Mockito.when((Object)store.hasStore()).thenThrow(new Class[]{IOException.class});
        } else {
            Mockito.when((Object)store.hasStore()).thenReturn((Object)present);
        }
        return store;
    }

    private LabelScanStoreProvider select(NamedLabelScanStoreSelectionStrategy strategy, LabelScanStoreProvider ... among) {
        return (LabelScanStoreProvider)strategy.select(LabelScanStoreProvider.class, Iterables.iterable((Object[])among));
    }
}

