/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Iterator;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.schema.AlreadyConstrainedException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyIndexedException;
import org.neo4j.kernel.api.exceptions.schema.DropIndexFailureException;
import org.neo4j.kernel.api.exceptions.schema.IllegalTokenNameException;
import org.neo4j.kernel.api.exceptions.schema.IndexBelongsToConstraintException;
import org.neo4j.kernel.api.exceptions.schema.NoSuchIndexException;
import org.neo4j.kernel.api.exceptions.schema.RepeatedPropertyInCompositeSchemaException;
import org.neo4j.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptorFactory;
import org.neo4j.kernel.impl.api.DataIntegrityValidatingStatementOperations;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.StatementOperationsTestHelper;
import org.neo4j.kernel.impl.api.operations.KeyWriteOperations;
import org.neo4j.kernel.impl.api.operations.SchemaReadOperations;
import org.neo4j.kernel.impl.api.operations.SchemaWriteOperations;

public class DataIntegrityValidatingStatementOperationsTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();
    LabelSchemaDescriptor descriptor = SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{7});
    IndexDescriptor index = IndexDescriptorFactory.forLabel((int)0, (int[])new int[]{7});
    IndexDescriptor uniqueIndex = IndexDescriptorFactory.uniqueForLabel((int)0, (int[])new int[]{7});
    private SchemaReadOperations innerRead;
    private SchemaWriteOperations innerWrite;
    private KeyWriteOperations innerKeyWrite;
    private DataIntegrityValidatingStatementOperations ops;
    private final KernelStatement state = StatementOperationsTestHelper.mockedState();

    @Before
    public void setup() {
        this.innerKeyWrite = (KeyWriteOperations)Mockito.mock(KeyWriteOperations.class);
        this.innerRead = (SchemaReadOperations)Mockito.mock(SchemaReadOperations.class);
        this.innerWrite = (SchemaWriteOperations)Mockito.mock(SchemaWriteOperations.class);
        this.ops = new DataIntegrityValidatingStatementOperations(this.innerKeyWrite, this.innerRead, this.innerWrite);
    }

    @Test
    public void shouldDisallowReAddingIndex() throws Exception {
        Mockito.when((Object)this.innerRead.indexGetForSchema(this.state, this.descriptor)).thenReturn((Object)this.index);
        try {
            this.ops.indexCreate(this.state, this.descriptor);
            Assert.fail((String)"Should have thrown exception.");
        }
        catch (AlreadyIndexedException alreadyIndexedException) {
            // empty catch block
        }
        ((SchemaWriteOperations)Mockito.verify((Object)this.innerWrite, (VerificationMode)Mockito.never())).indexCreate((KernelStatement)Matchers.eq((Object)this.state), (LabelSchemaDescriptor)Matchers.anyObject());
    }

    @Test
    public void shouldDisallowAddingIndexWhenConstraintIndexExists() throws Exception {
        Mockito.when((Object)this.innerRead.indexGetForSchema(this.state, this.descriptor)).thenReturn((Object)this.uniqueIndex);
        try {
            this.ops.indexCreate(this.state, this.descriptor);
            Assert.fail((String)"Should have thrown exception.");
        }
        catch (AlreadyConstrainedException alreadyConstrainedException) {
            // empty catch block
        }
        ((SchemaWriteOperations)Mockito.verify((Object)this.innerWrite, (VerificationMode)Mockito.never())).indexCreate((KernelStatement)Matchers.eq((Object)this.state), (LabelSchemaDescriptor)Matchers.anyObject());
    }

    @Test
    public void shouldDisallowDroppingIndexThatDoesNotExist() throws Exception {
        Mockito.when((Object)this.innerRead.indexGetForSchema(this.state, this.descriptor)).thenReturn(null);
        try {
            this.ops.indexDrop(this.state, this.index);
            Assert.fail((String)"Should have thrown exception.");
        }
        catch (DropIndexFailureException e) {
            Assert.assertThat((Object)e.getCause(), (Matcher)IsInstanceOf.instanceOf(NoSuchIndexException.class));
        }
        ((SchemaWriteOperations)Mockito.verify((Object)this.innerWrite, (VerificationMode)Mockito.never())).indexCreate((KernelStatement)Matchers.eq((Object)this.state), (LabelSchemaDescriptor)Matchers.anyObject());
    }

    @Test
    public void shouldDisallowDroppingIndexWhenConstraintIndexExists() throws Exception {
        Mockito.when((Object)this.innerRead.indexGetForSchema(this.state, this.descriptor)).thenReturn((Object)this.uniqueIndex);
        try {
            this.ops.indexDrop(this.state, this.index);
            Assert.fail((String)"Should have thrown exception.");
        }
        catch (DropIndexFailureException e) {
            Assert.assertThat((Object)e.getCause(), (Matcher)IsInstanceOf.instanceOf(IndexBelongsToConstraintException.class));
        }
        ((SchemaWriteOperations)Mockito.verify((Object)this.innerWrite, (VerificationMode)Mockito.never())).indexCreate((KernelStatement)Matchers.eq((Object)this.state), (LabelSchemaDescriptor)Matchers.anyObject());
    }

    @Test
    public void shouldDisallowDroppingConstraintIndexThatDoesNotExists() throws Exception {
        Mockito.when((Object)this.innerRead.indexGetForSchema(this.state, this.descriptor)).thenReturn((Object)this.uniqueIndex);
        try {
            this.ops.indexDrop(this.state, this.index);
            Assert.fail((String)"Should have thrown exception.");
        }
        catch (DropIndexFailureException e) {
            Assert.assertThat((Object)e.getCause(), (Matcher)IsInstanceOf.instanceOf(IndexBelongsToConstraintException.class));
        }
        ((SchemaWriteOperations)Mockito.verify((Object)this.innerWrite, (VerificationMode)Mockito.never())).indexCreate((KernelStatement)Matchers.eq((Object)this.state), (LabelSchemaDescriptor)Matchers.anyObject());
    }

    @Test
    public void shouldDisallowDroppingConstraintIndexThatIsReallyJustRegularIndex() throws Exception {
        Mockito.when((Object)this.innerRead.indexGetForSchema(this.state, this.descriptor)).thenReturn((Object)this.uniqueIndex);
        try {
            this.ops.indexDrop(this.state, this.index);
            Assert.fail((String)"Should have thrown exception.");
        }
        catch (DropIndexFailureException e) {
            Assert.assertThat((Object)e.getCause(), (Matcher)IsInstanceOf.instanceOf(IndexBelongsToConstraintException.class));
        }
        ((SchemaWriteOperations)Mockito.verify((Object)this.innerWrite, (VerificationMode)Mockito.never())).indexCreate((KernelStatement)Matchers.eq((Object)this.state), (LabelSchemaDescriptor)Matchers.anyObject());
    }

    @Test
    public void shouldDisallowNullOrEmptyPropertyKey() throws Exception {
        try {
            this.ops.propertyKeyGetOrCreateForName((Statement)this.state, null);
            Assert.fail((String)"Should not be able to create null property key");
        }
        catch (IllegalTokenNameException illegalTokenNameException) {
            // empty catch block
        }
        try {
            this.ops.propertyKeyGetOrCreateForName((Statement)this.state, "");
            Assert.fail((String)"Should not be able to create empty property key");
        }
        catch (IllegalTokenNameException illegalTokenNameException) {
            // empty catch block
        }
    }

    @Test
    public void shouldDisallowNullOrEmptyLabelName() throws Exception {
        try {
            this.ops.labelGetOrCreateForName((Statement)this.state, null);
            Assert.fail((String)"Should not be able to create null label");
        }
        catch (IllegalTokenNameException illegalTokenNameException) {
            // empty catch block
        }
        try {
            this.ops.labelGetOrCreateForName((Statement)this.state, "");
            Assert.fail((String)"Should not be able to create empty label");
        }
        catch (IllegalTokenNameException illegalTokenNameException) {
            // empty catch block
        }
    }

    @Test(expected=SchemaKernelException.class)
    public void shouldFailInvalidLabelNames() throws Exception {
        this.ops.labelGetOrCreateForName((Statement)this.state, "");
    }

    @Test(expected=SchemaKernelException.class)
    public void shouldFailOnNullLabel() throws Exception {
        this.ops.labelGetOrCreateForName((Statement)this.state, null);
    }

    @Test(expected=RepeatedPropertyInCompositeSchemaException.class)
    public void shouldFailIndexCreateOnRepeatedPropertyId() throws Exception {
        this.ops.indexCreate(this.state, SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{1, 1}));
    }

    @Test(expected=RepeatedPropertyInCompositeSchemaException.class)
    public void shouldFailNodeExistenceCreateOnRepeatedPropertyId() throws Exception {
        this.ops.nodePropertyExistenceConstraintCreate(this.state, SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{1, 1}));
    }

    @Test(expected=RepeatedPropertyInCompositeSchemaException.class)
    public void shouldFailRelExistenceCreateOnRepeatedPropertyId() throws Exception {
        this.ops.relationshipPropertyExistenceConstraintCreate(this.state, SchemaDescriptorFactory.forRelType((int)0, (int[])new int[]{1, 1}));
    }

    @Test(expected=RepeatedPropertyInCompositeSchemaException.class)
    public void shouldFailUniquenessCreateOnRepeatedPropertyId() throws Exception {
        this.ops.uniquePropertyConstraintCreate(this.state, SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{1, 1}));
    }

    @SafeVarargs
    private static <T> Answer<Iterator<T>> withIterator(final T ... content) {
        return new Answer<Iterator<T>>(){

            public Iterator<T> answer(InvocationOnMock invocationOnMock) throws Throwable {
                return Iterators.iterator((Object[])content);
            }
        };
    }
}

