/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.time.Clock;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.LockSupport;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.graphdb.DatabaseShutdownException;
import org.neo4j.graphdb.security.AuthorizationExpiredException;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.KernelTransactionHandle;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.KernelTransactions;
import org.neo4j.kernel.impl.api.KernelTransactionsSnapshot;
import org.neo4j.kernel.impl.api.LegacyIndexProviderLookup;
import org.neo4j.kernel.impl.api.SchemaWriteGuard;
import org.neo4j.kernel.impl.api.StatementOperationContainer;
import org.neo4j.kernel.impl.api.TestKernelTransactionHandle;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionHooks;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.factory.AccessCapability;
import org.neo4j.kernel.impl.factory.CanWrite;
import org.neo4j.kernel.impl.index.IndexConfigStore;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.SimpleStatementLocksFactory;
import org.neo4j.kernel.impl.locking.StatementLocksFactory;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.impl.store.TransactionId;
import org.neo4j.kernel.impl.transaction.TransactionHeaderInformationFactory;
import org.neo4j.kernel.impl.transaction.TransactionMonitor;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.kernel.monitoring.tracing.Tracers;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageStatement;
import org.neo4j.storageengine.api.StoreReadLayer;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.storageengine.api.lock.ResourceLocker;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.test.Race;
import org.neo4j.test.rule.concurrent.OtherThreadRule;

public class KernelTransactionsTest {
    @Rule
    public final OtherThreadRule<Void> t2 = new OtherThreadRule("T2-" + this.getClass().getName());
    @Rule
    public final ExpectedException expectedException = ExpectedException.none();
    private static final Clock clock = Clock.systemUTC();
    private static AvailabilityGuard availabilityGuard;

    @Before
    public void setUp() {
        availabilityGuard = new AvailabilityGuard(clock, (Log)NullLog.getInstance());
    }

    @Test
    public void shouldListActiveTransactions() throws Throwable {
        KernelTransactions transactions = KernelTransactionsTest.newTestKernelTransactions();
        KernelTransaction first = this.getKernelTransaction(transactions);
        KernelTransaction second = this.getKernelTransaction(transactions);
        KernelTransaction third = this.getKernelTransaction(transactions);
        first.close();
        Assert.assertThat((Object)transactions.activeTransactions(), (Matcher)CoreMatchers.equalTo((Object)Iterators.asSet((Object[])new KernelTransactionHandle[]{KernelTransactionsTest.newHandle(second), KernelTransactionsTest.newHandle(third)})));
    }

    @Test
    public void shouldDisposeTransactionsWhenAsked() throws Throwable {
        KernelTransactions transactions = KernelTransactionsTest.newKernelTransactions();
        transactions.disposeAll();
        KernelTransaction first = this.getKernelTransaction(transactions);
        KernelTransaction second = this.getKernelTransaction(transactions);
        KernelTransaction leftOpen = this.getKernelTransaction(transactions);
        first.close();
        second.close();
        transactions.disposeAll();
        KernelTransaction postDispose = this.getKernelTransaction(transactions);
        Assert.assertThat((Object)postDispose, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)first)));
        Assert.assertThat((Object)postDispose, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)second)));
        Assert.assertTrue((leftOpen.getReasonIfTerminated() != null ? 1 : 0) != 0);
    }

    @Test
    public void shouldIncludeRandomBytesInAdditionalHeader() throws Throwable {
        TransactionRepresentation[] transactionRepresentation = new TransactionRepresentation[1];
        KernelTransactions registry = KernelTransactionsTest.newKernelTransactions(KernelTransactionsTest.newRememberingCommitProcess(transactionRepresentation));
        try (KernelTransaction transaction = this.getKernelTransaction(registry);){
            ((KernelTransactionImplementation)transaction).txState().nodeDoCreate(0L);
            transaction.success();
        }
        byte[] additionalHeader = transactionRepresentation[0].additionalHeader();
        Assert.assertNotNull((Object)additionalHeader);
        Assert.assertTrue((additionalHeader.length > 0 ? 1 : 0) != 0);
    }

    @Test
    public void shouldReuseClosedTransactionObjects() throws Throwable {
        KernelTransactions transactions = KernelTransactionsTest.newKernelTransactions();
        KernelTransaction a = this.getKernelTransaction(transactions);
        a.close();
        KernelTransaction b = this.getKernelTransaction(transactions);
        Assert.assertSame((Object)a, (Object)b);
    }

    @Test
    public void shouldTellWhenTransactionsFromSnapshotHaveBeenClosed() throws Throwable {
        KernelTransactions transactions = KernelTransactionsTest.newKernelTransactions();
        KernelTransaction a = this.getKernelTransaction(transactions);
        KernelTransaction b = this.getKernelTransaction(transactions);
        KernelTransaction c = this.getKernelTransaction(transactions);
        KernelTransactionsSnapshot snapshot = transactions.get();
        Assert.assertFalse((boolean)snapshot.allClosed());
        a.close();
        Assert.assertFalse((boolean)snapshot.allClosed());
        c.close();
        KernelTransaction d = this.getKernelTransaction(transactions);
        Assert.assertFalse((boolean)snapshot.allClosed());
        b.close();
        Assert.assertTrue((boolean)snapshot.allClosed());
    }

    @Test
    public void shouldBeAbleToSnapshotDuringHeavyLoad() throws Throwable {
        KernelTransactions transactions = KernelTransactionsTest.newKernelTransactions();
        Race race = new Race();
        int threads = 50;
        AtomicBoolean end = new AtomicBoolean();
        AtomicReferenceArray snapshots = new AtomicReferenceArray(50);
        int i = 0;
        while (i < 50) {
            int threadIndex = i++;
            race.addContestant(() -> {
                ThreadLocalRandom random = ThreadLocalRandom.current();
                while (!end.get()) {
                    try {
                        KernelTransaction transaction = this.getKernelTransaction(transactions);
                        Throwable throwable = null;
                        try {
                            LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(random.nextInt(3)));
                            if (snapshots.get(threadIndex) != null) continue;
                            snapshots.set(threadIndex, transactions.get());
                            LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(random.nextInt(3)));
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (transaction == null) continue;
                            if (throwable != null) {
                                try {
                                    transaction.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            transaction.close();
                        }
                    }
                    catch (TransactionFailureException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        race.addContestant(() -> {
            ThreadLocalRandom random = ThreadLocalRandom.current();
            int snapshotsLeft = 1000;
            while (snapshotsLeft > 0) {
                int threadIndex = random.nextInt(50);
                KernelTransactionsSnapshot snapshot = (KernelTransactionsSnapshot)snapshots.get(threadIndex);
                if (snapshot == null || !snapshot.allClosed()) continue;
                --snapshotsLeft;
                snapshots.set(threadIndex, null);
            }
            end.set(true);
        });
        race.go();
    }

    @Test
    public void transactionCloseRemovesTxFromActiveTransactions() throws Throwable {
        KernelTransactions kernelTransactions = KernelTransactionsTest.newTestKernelTransactions();
        KernelTransaction tx1 = this.getKernelTransaction(kernelTransactions);
        KernelTransaction tx2 = this.getKernelTransaction(kernelTransactions);
        KernelTransaction tx3 = this.getKernelTransaction(kernelTransactions);
        tx1.close();
        tx3.close();
        Assert.assertEquals((Object)Iterators.asSet((Object[])new KernelTransactionHandle[]{KernelTransactionsTest.newHandle(tx2)}), (Object)kernelTransactions.activeTransactions());
    }

    @Test
    public void disposeAllMarksAllTransactionsForTermination() throws Throwable {
        KernelTransactions kernelTransactions = KernelTransactionsTest.newKernelTransactions();
        KernelTransaction tx1 = this.getKernelTransaction(kernelTransactions);
        KernelTransaction tx2 = this.getKernelTransaction(kernelTransactions);
        KernelTransaction tx3 = this.getKernelTransaction(kernelTransactions);
        kernelTransactions.disposeAll();
        Assert.assertEquals((Object)Status.General.DatabaseUnavailable, tx1.getReasonIfTerminated().get());
        Assert.assertEquals((Object)Status.General.DatabaseUnavailable, tx2.getReasonIfTerminated().get());
        Assert.assertEquals((Object)Status.General.DatabaseUnavailable, tx3.getReasonIfTerminated().get());
    }

    @Test
    public void transactionClosesUnderlyingStoreStatementWhenDisposed() throws Throwable {
        StorageStatement storeStatement1 = (StorageStatement)Mockito.mock(StorageStatement.class);
        StorageStatement storeStatement2 = (StorageStatement)Mockito.mock(StorageStatement.class);
        StorageStatement storeStatement3 = (StorageStatement)Mockito.mock(StorageStatement.class);
        KernelTransactions kernelTransactions = KernelTransactionsTest.newKernelTransactions((TransactionCommitProcess)Mockito.mock(TransactionCommitProcess.class), storeStatement1, storeStatement2, storeStatement3);
        KernelTransactionsTest.startAndCloseTransaction(kernelTransactions);
        Executors.newSingleThreadExecutor().submit(() -> KernelTransactionsTest.startAndCloseTransaction(kernelTransactions)).get();
        Executors.newSingleThreadExecutor().submit(() -> KernelTransactionsTest.startAndCloseTransaction(kernelTransactions)).get();
        kernelTransactions.disposeAll();
        ((StorageStatement)Mockito.verify((Object)storeStatement1)).close();
        ((StorageStatement)Mockito.verify((Object)storeStatement2)).close();
        ((StorageStatement)Mockito.verify((Object)storeStatement3)).close();
    }

    @Test
    public void threadThatBlocksNewTxsCantStartNewTxs() throws Throwable {
        KernelTransactions kernelTransactions = KernelTransactionsTest.newKernelTransactions();
        kernelTransactions.blockNewTransactions();
        try {
            kernelTransactions.newInstance(KernelTransaction.Type.implicit, (SecurityContext)AnonymousContext.write(), 0L);
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)CoreMatchers.instanceOf(IllegalStateException.class));
        }
    }

    @Test
    public void blockNewTransactions() throws Throwable {
        KernelTransactions kernelTransactions = KernelTransactionsTest.newKernelTransactions();
        kernelTransactions.blockNewTransactions();
        Future<KernelTransaction> txOpener = this.t2.execute(state -> kernelTransactions.newInstance(KernelTransaction.Type.explicit, (SecurityContext)AnonymousContext.write(), 0L));
        this.t2.get().waitUntilWaiting(location -> location.isAt(KernelTransactions.class, "newInstance"));
        KernelTransactionsTest.assertNotDone(txOpener);
        kernelTransactions.unblockNewTransactions();
        Assert.assertNotNull((Object)txOpener.get(2L, TimeUnit.SECONDS));
    }

    @Test
    public void unblockNewTransactionsFromWrongThreadThrows() throws Throwable {
        KernelTransactions kernelTransactions = KernelTransactionsTest.newKernelTransactions();
        kernelTransactions.blockNewTransactions();
        Future<KernelTransaction> txOpener = this.t2.execute(state -> kernelTransactions.newInstance(KernelTransaction.Type.explicit, (SecurityContext)AnonymousContext.write(), 0L));
        this.t2.get().waitUntilWaiting(location -> location.isAt(KernelTransactions.class, "newInstance"));
        KernelTransactionsTest.assertNotDone(txOpener);
        Future<?> wrongUnblocker = KernelTransactionsTest.unblockTxsInSeparateThread(kernelTransactions);
        try {
            wrongUnblocker.get(2L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)CoreMatchers.instanceOf(ExecutionException.class));
            Assert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(IllegalStateException.class));
        }
        KernelTransactionsTest.assertNotDone(txOpener);
        kernelTransactions.unblockNewTransactions();
        Assert.assertNotNull((Object)txOpener.get(2L, TimeUnit.SECONDS));
    }

    @Test
    public void shouldNotLeakTransactionOnSecurityContextFreezeFailure() throws Throwable {
        KernelTransactions kernelTransactions = KernelTransactionsTest.newKernelTransactions();
        SecurityContext securityContext = (SecurityContext)Mockito.mock(SecurityContext.class);
        Mockito.when((Object)securityContext.freeze()).thenThrow(new Throwable[]{new AuthorizationExpiredException("Freeze failed.")});
        org.neo4j.test.assertion.Assert.assertException(() -> kernelTransactions.newInstance(KernelTransaction.Type.explicit, securityContext, 0L), AuthorizationExpiredException.class, "Freeze failed.");
        Assert.assertThat((String)"We should not have any transaction", (Object)kernelTransactions.activeTransactions(), (Matcher)CoreMatchers.is((Matcher)org.hamcrest.Matchers.empty()));
    }

    @Test
    public void exceptionWhenStartingNewTransactionOnShutdownInstance() throws Throwable {
        KernelTransactions kernelTransactions = KernelTransactionsTest.newKernelTransactions();
        SecurityContext securityContext = (SecurityContext)Mockito.mock(SecurityContext.class);
        availabilityGuard.shutdown();
        this.expectedException.expect(DatabaseShutdownException.class);
        kernelTransactions.newInstance(KernelTransaction.Type.explicit, securityContext, 0L);
    }

    @Test
    public void exceptionWhenStartingNewTransactionOnStoppedKernelTransactions() throws Throwable {
        KernelTransactions kernelTransactions = KernelTransactionsTest.newKernelTransactions();
        SecurityContext securityContext = (SecurityContext)Mockito.mock(SecurityContext.class);
        this.t2.execute(state -> {
            this.stopKernelTransactions(kernelTransactions);
            return null;
        }).get();
        this.expectedException.expect(IllegalStateException.class);
        kernelTransactions.newInstance(KernelTransaction.Type.explicit, securityContext, 0L);
    }

    @Test
    public void startNewTransactionOnRestartedKErnelTransactions() throws Throwable {
        KernelTransactions kernelTransactions = KernelTransactionsTest.newKernelTransactions();
        SecurityContext securityContext = (SecurityContext)Mockito.mock(SecurityContext.class);
        kernelTransactions.stop();
        kernelTransactions.start();
        Assert.assertNotNull((String)"New transaction created by restarted kernel transactions component.", (Object)kernelTransactions.newInstance(KernelTransaction.Type.explicit, securityContext, 0L));
    }

    private void stopKernelTransactions(KernelTransactions kernelTransactions) {
        try {
            kernelTransactions.stop();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private static void startAndCloseTransaction(KernelTransactions kernelTransactions) {
        try {
            kernelTransactions.newInstance(KernelTransaction.Type.explicit, SecurityContext.AUTH_DISABLED, 0L).close();
        }
        catch (TransactionFailureException e) {
            throw new RuntimeException(e);
        }
    }

    private static KernelTransactions newKernelTransactions() throws Throwable {
        return KernelTransactionsTest.newKernelTransactions((TransactionCommitProcess)Mockito.mock(TransactionCommitProcess.class));
    }

    private static KernelTransactions newTestKernelTransactions() throws Throwable {
        return KernelTransactionsTest.newKernelTransactions(true, (TransactionCommitProcess)Mockito.mock(TransactionCommitProcess.class), (StorageStatement)Mockito.mock(StorageStatement.class), new StorageStatement[0]);
    }

    private static KernelTransactions newKernelTransactions(TransactionCommitProcess commitProcess) throws Throwable {
        return KernelTransactionsTest.newKernelTransactions(false, commitProcess, (StorageStatement)Mockito.mock(StorageStatement.class), new StorageStatement[0]);
    }

    private static KernelTransactions newKernelTransactions(TransactionCommitProcess commitProcess, StorageStatement firstStoreStatements, StorageStatement ... otherStorageStatements) throws Throwable {
        return KernelTransactionsTest.newKernelTransactions(false, commitProcess, firstStoreStatements, otherStorageStatements);
    }

    private static KernelTransactions newKernelTransactions(boolean testKernelTransactions, TransactionCommitProcess commitProcess, StorageStatement firstStoreStatements, StorageStatement ... otherStorageStatements) throws Throwable {
        Locks locks = (Locks)Mockito.mock(Locks.class);
        Mockito.when((Object)locks.newClient()).thenReturn(Mockito.mock(Locks.Client.class));
        StoreReadLayer readLayer = (StoreReadLayer)Mockito.mock(StoreReadLayer.class);
        Mockito.when((Object)readLayer.newStatement()).thenReturn((Object)firstStoreStatements, (Object[])otherStorageStatements);
        StorageEngine storageEngine = (StorageEngine)Mockito.mock(StorageEngine.class);
        Mockito.when((Object)storageEngine.storeReadLayer()).thenReturn((Object)readLayer);
        ((StorageEngine)Mockito.doAnswer(invocation -> {
            ((Collection)invocation.getArgumentAt(0, Collection.class)).add(Mockito.mock(StorageCommand.class));
            return null;
        }).when((Object)storageEngine)).createCommands(Matchers.anyCollection(), (ReadableTransactionState)Matchers.any(ReadableTransactionState.class), (StorageStatement)Matchers.any(StorageStatement.class), (ResourceLocker)Matchers.any(ResourceLocker.class), Matchers.anyLong());
        return KernelTransactionsTest.newKernelTransactions(locks, storageEngine, commitProcess, testKernelTransactions);
    }

    private static KernelTransactions newKernelTransactions(Locks locks, StorageEngine storageEngine, TransactionCommitProcess commitProcess, boolean testKernelTransactions) throws Throwable {
        LifeSupport life = new LifeSupport();
        life.start();
        TransactionIdStore transactionIdStore = (TransactionIdStore)Mockito.mock(TransactionIdStore.class);
        Mockito.when((Object)transactionIdStore.getLastCommittedTransaction()).thenReturn((Object)new TransactionId(0L, 0L, 0L));
        Tracers tracers = new Tracers("null", (Log)NullLog.getInstance(), new Monitors(), (JobScheduler)Mockito.mock(JobScheduler.class));
        SimpleStatementLocksFactory statementLocksFactory = new SimpleStatementLocksFactory(locks);
        StatementOperationContainer statementOperationsContianer = new StatementOperationContainer(null, null);
        TestKernelTransactions transactions = testKernelTransactions ? KernelTransactionsTest.createTestTransactions(storageEngine, commitProcess, transactionIdStore, tracers, (StatementLocksFactory)statementLocksFactory, statementOperationsContianer, clock, availabilityGuard) : KernelTransactionsTest.createTransactions(storageEngine, commitProcess, transactionIdStore, tracers, (StatementLocksFactory)statementLocksFactory, statementOperationsContianer, clock, availabilityGuard);
        transactions.start();
        return transactions;
    }

    private static KernelTransactions createTransactions(StorageEngine storageEngine, TransactionCommitProcess commitProcess, TransactionIdStore transactionIdStore, Tracers tracers, StatementLocksFactory statementLocksFactory, StatementOperationContainer statementOperationsContianer, Clock clock, AvailabilityGuard availabilityGuard) {
        return new KernelTransactions(statementLocksFactory, null, statementOperationsContianer, null, TransactionHeaderInformationFactory.DEFAULT, commitProcess, null, null, new TransactionHooks(), (TransactionMonitor)Mockito.mock(TransactionMonitor.class), availabilityGuard, tracers, storageEngine, new Procedures(), transactionIdStore, clock, (AccessCapability)new CanWrite());
    }

    private static TestKernelTransactions createTestTransactions(StorageEngine storageEngine, TransactionCommitProcess commitProcess, TransactionIdStore transactionIdStore, Tracers tracers, StatementLocksFactory statementLocksFactory, StatementOperationContainer statementOperationsContianer, Clock clock, AvailabilityGuard availabilityGuard) {
        return new TestKernelTransactions(statementLocksFactory, null, statementOperationsContianer, null, TransactionHeaderInformationFactory.DEFAULT, commitProcess, null, null, new TransactionHooks(), (TransactionMonitor)Mockito.mock(TransactionMonitor.class), availabilityGuard, tracers, storageEngine, new Procedures(), transactionIdStore, clock, (AccessCapability)new CanWrite());
    }

    private static TransactionCommitProcess newRememberingCommitProcess(TransactionRepresentation[] slot) throws TransactionFailureException {
        TransactionCommitProcess commitProcess = (TransactionCommitProcess)Mockito.mock(TransactionCommitProcess.class);
        Mockito.when((Object)commitProcess.commit((TransactionToApply)Matchers.any(TransactionToApply.class), (CommitEvent)Matchers.any(CommitEvent.class), (TransactionApplicationMode)Matchers.any(TransactionApplicationMode.class))).then(invocation -> {
            slot[0] = ((TransactionToApply)invocation.getArguments()[0]).transactionRepresentation();
            return 1L;
        });
        return commitProcess;
    }

    private static Future<?> unblockTxsInSeparateThread(KernelTransactions kernelTransactions) {
        return Executors.newSingleThreadExecutor().submit(() -> ((KernelTransactions)kernelTransactions).unblockNewTransactions());
    }

    private static void assertNotDone(Future<?> future) {
        Assert.assertFalse((boolean)future.isDone());
    }

    private static KernelTransactionHandle newHandle(KernelTransaction tx) {
        return new TestKernelTransactionHandle(tx);
    }

    private KernelTransaction getKernelTransaction(KernelTransactions transactions) {
        return transactions.newInstance(KernelTransaction.Type.implicit, (SecurityContext)AnonymousContext.none(), 0L);
    }

    private static class TestKernelTransactions
    extends KernelTransactions {
        TestKernelTransactions(StatementLocksFactory statementLocksFactory, ConstraintIndexCreator constraintIndexCreator, StatementOperationContainer statementOperationsContianer, SchemaWriteGuard schemaWriteGuard, TransactionHeaderInformationFactory txHeaderFactory, TransactionCommitProcess transactionCommitProcess, IndexConfigStore indexConfigStore, LegacyIndexProviderLookup legacyIndexProviderLookup, TransactionHooks hooks, TransactionMonitor transactionMonitor, AvailabilityGuard availabilityGuard, Tracers tracers, StorageEngine storageEngine, Procedures procedures, TransactionIdStore transactionIdStore, Clock clock, AccessCapability accessCapability) {
            super(statementLocksFactory, constraintIndexCreator, statementOperationsContianer, schemaWriteGuard, txHeaderFactory, transactionCommitProcess, indexConfigStore, legacyIndexProviderLookup, hooks, transactionMonitor, availabilityGuard, tracers, storageEngine, procedures, transactionIdStore, clock, accessCapability);
        }

        KernelTransactionHandle createHandle(KernelTransactionImplementation tx) {
            return new TestKernelTransactionHandle((KernelTransaction)tx);
        }
    }
}

