/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.api.LegacyBatchIndexApplier;
import org.neo4j.kernel.impl.api.LegacyIndexApplierLookup;
import org.neo4j.kernel.impl.api.TransactionApplier;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.index.IndexCommand;
import org.neo4j.kernel.impl.index.IndexConfigStore;
import org.neo4j.kernel.impl.index.IndexDefineCommand;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.Commitment;
import org.neo4j.kernel.impl.transaction.log.FakeCommitment;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.util.IdOrderingQueue;
import org.neo4j.kernel.impl.util.SynchronizedArrayIdOrderingQueue;
import org.neo4j.kernel.lifecycle.LifeRule;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.storageengine.api.CommandsToApply;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.test.Race;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class LegacyBatchIndexApplierTest {
    @Rule
    public final LifeRule life = new LifeRule(true);
    @Rule
    public final EphemeralFileSystemRule fs = new EphemeralFileSystemRule();

    @Test
    public void shouldOnlyCreateOneApplierPerProvider() throws Exception {
        Map names = MapUtil.genericMap((Object[])new Object[]{"first", 0, "second", 1});
        Map keys = MapUtil.genericMap((Object[])new Object[]{"key", 0});
        String applierName = "test-applier";
        Commitment commitment = (Commitment)Mockito.mock(Commitment.class);
        Mockito.when((Object)commitment.hasLegacyIndexChanges()).thenReturn((Object)true);
        IndexConfigStore config = this.newIndexConfigStore(names, applierName);
        LegacyIndexApplierLookup applierLookup = (LegacyIndexApplierLookup)Mockito.mock(LegacyIndexApplierLookup.class);
        Mockito.when((Object)applierLookup.newApplier(Matchers.anyString(), Matchers.anyBoolean())).thenReturn(Mockito.mock(TransactionApplier.class));
        try (LegacyBatchIndexApplier applier = new LegacyBatchIndexApplier(config, applierLookup, IdOrderingQueue.BYPASS, TransactionApplicationMode.INTERNAL);){
            TransactionToApply tx = new TransactionToApply(null, 2L);
            tx.commitment(commitment, 2L);
            try (TransactionApplier txApplier = applier.startTx((CommandsToApply)tx);){
                IndexDefineCommand definitions = LegacyBatchIndexApplierTest.definitions(names, keys);
                txApplier.visitIndexDefineCommand(definitions);
                txApplier.visitIndexAddNodeCommand(LegacyBatchIndexApplierTest.addNodeToIndex(definitions, "first"));
                txApplier.visitIndexAddNodeCommand(LegacyBatchIndexApplierTest.addNodeToIndex(definitions, "second"));
                txApplier.visitIndexAddRelationshipCommand(LegacyBatchIndexApplierTest.addRelationshipToIndex(definitions, "second"));
            }
        }
        ((LegacyIndexApplierLookup)Mockito.verify((Object)applierLookup, (VerificationMode)Mockito.times((int)1))).newApplier((String)Matchers.eq((Object)applierName), Matchers.anyBoolean());
    }

    @Test
    public void shouldOrderTransactionsMakingLegacyIndexChanges() throws Throwable {
        Map names = MapUtil.genericMap((Object[])new Object[]{"first", 0, "second", 1});
        Map keys = MapUtil.genericMap((Object[])new Object[]{"key", 0});
        String applierName = "test-applier";
        LegacyIndexApplierLookup applierLookup = (LegacyIndexApplierLookup)Mockito.mock(LegacyIndexApplierLookup.class);
        Mockito.when((Object)applierLookup.newApplier(Matchers.anyString(), Matchers.anyBoolean())).thenReturn(Mockito.mock(TransactionApplier.class));
        IndexConfigStore config = this.newIndexConfigStore(names, applierName);
        SynchronizedArrayIdOrderingQueue queue = new SynchronizedArrayIdOrderingQueue(10);
        AtomicLong lastAppliedTxId = new AtomicLong(-1L);
        Race race = new Race();
        long i = 0L;
        while (i < 100L) {
            long txId = i++;
            race.addContestant(() -> {
                try (LegacyBatchIndexApplier applier = new LegacyBatchIndexApplier(config, applierLookup, (IdOrderingQueue)queue, TransactionApplicationMode.INTERNAL);){
                    TransactionToApply txToApply = new TransactionToApply((TransactionRepresentation)new PhysicalTransactionRepresentation(new ArrayList()));
                    FakeCommitment commitment = new FakeCommitment(txId, (TransactionIdStore)Mockito.mock(TransactionIdStore.class));
                    commitment.setHasLegacyIndexChanges(true);
                    txToApply.commitment((Commitment)commitment, txId);
                    TransactionApplier txApplier = applier.startTx((CommandsToApply)txToApply);
                    Thread.sleep(ThreadLocalRandom.current().nextInt(5));
                    Assert.assertTrue((boolean)lastAppliedTxId.compareAndSet(txId - 1L, txId));
                    txApplier.close();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            queue.offer(txId);
        }
        race.go();
    }

    private static IndexCommand.AddRelationshipCommand addRelationshipToIndex(IndexDefineCommand definitions, String indexName) {
        IndexCommand.AddRelationshipCommand command = new IndexCommand.AddRelationshipCommand();
        command.init(definitions.getOrAssignIndexNameId(indexName), 0L, 0, null, 1L, 2L);
        return command;
    }

    private static IndexCommand.AddNodeCommand addNodeToIndex(IndexDefineCommand definitions, String indexName) {
        IndexCommand.AddNodeCommand command = new IndexCommand.AddNodeCommand();
        command.init(definitions.getOrAssignIndexNameId(indexName), 0L, 0, null);
        return command;
    }

    private static IndexDefineCommand definitions(Map<String, Integer> names, Map<String, Integer> keys) {
        IndexDefineCommand definitions = new IndexDefineCommand();
        definitions.init(names, keys);
        return definitions;
    }

    private IndexConfigStore newIndexConfigStore(Map<String, Integer> names, String providerName) {
        File dir = new File("conf");
        EphemeralFileSystemAbstraction fileSystem = (EphemeralFileSystemAbstraction)this.fs.get();
        fileSystem.mkdirs(dir);
        IndexConfigStore store = (IndexConfigStore)this.life.add((Lifecycle)new IndexConfigStore(dir, (FileSystemAbstraction)fileSystem));
        for (Map.Entry<String, Integer> name : names.entrySet()) {
            store.set(Node.class, name.getKey(), MapUtil.stringMap((String[])new String[]{"provider", providerName}));
            store.set(Relationship.class, name.getKey(), MapUtil.stringMap((String[])new String[]{"provider", providerName}));
        }
        return store;
    }
}

