/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Function;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.legacyindex.AutoIndexingKernelException;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.api.schema.constaints.ConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.ConstraintDescriptorFactory;
import org.neo4j.kernel.api.schema.constaints.UniquenessConstraintDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptorFactory;
import org.neo4j.kernel.api.txstate.LegacyIndexTransactionState;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.api.txstate.TxStateHolder;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.LockingStatementOperations;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.TwoPhaseNodeForRelationshipLockingTest;
import org.neo4j.kernel.impl.api.operations.EntityReadOperations;
import org.neo4j.kernel.impl.api.operations.EntityWriteOperations;
import org.neo4j.kernel.impl.api.operations.SchemaReadOperations;
import org.neo4j.kernel.impl.api.operations.SchemaStateOperations;
import org.neo4j.kernel.impl.api.operations.SchemaWriteOperations;
import org.neo4j.kernel.impl.api.state.TxState;
import org.neo4j.kernel.impl.factory.AccessCapability;
import org.neo4j.kernel.impl.factory.CanWrite;
import org.neo4j.kernel.impl.locking.LockTracer;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.kernel.impl.locking.SimpleStatementLocks;
import org.neo4j.kernel.impl.locking.StatementLocks;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.storageengine.api.StorageStatement;
import org.neo4j.storageengine.api.lock.ResourceType;

public class LockingStatementOperationsTest {
    private final LockingStatementOperations lockingOps;
    private final EntityReadOperations entityReadOps;
    private final EntityWriteOperations entityWriteOps;
    private final SchemaReadOperations schemaReadOps;
    private final SchemaWriteOperations schemaWriteOps;
    private final Locks.Client locks = (Locks.Client)Mockito.mock(Locks.Client.class);
    private final InOrder order;
    private final KernelTransactionImplementation transaction = (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class);
    private final TxState txState = new TxState();
    private final KernelStatement state = new KernelStatement(this.transaction, (TxStateHolder)new SimpleTxStateHolder(this.txState), (StorageStatement)Mockito.mock(StorageStatement.class), new Procedures(), (AccessCapability)new CanWrite(), LockTracer.NONE);
    private final SchemaStateOperations schemaStateOps;
    private final LabelSchemaDescriptor descriptor = SchemaDescriptorFactory.forLabel((int)123, (int[])new int[]{456});

    public LockingStatementOperationsTest() {
        Mockito.when((Object)this.transaction.getReasonIfTerminated()).thenReturn(Optional.empty());
        this.entityReadOps = (EntityReadOperations)Mockito.mock(EntityReadOperations.class);
        this.entityWriteOps = (EntityWriteOperations)Mockito.mock(EntityWriteOperations.class);
        this.schemaReadOps = (SchemaReadOperations)Mockito.mock(SchemaReadOperations.class);
        this.schemaWriteOps = (SchemaWriteOperations)Mockito.mock(SchemaWriteOperations.class);
        this.schemaStateOps = (SchemaStateOperations)Mockito.mock(SchemaStateOperations.class);
        this.order = Mockito.inOrder((Object[])new Object[]{this.locks, this.entityWriteOps, this.schemaReadOps, this.schemaWriteOps, this.schemaStateOps});
        this.lockingOps = new LockingStatementOperations(this.entityReadOps, this.entityWriteOps, this.schemaReadOps, this.schemaWriteOps, this.schemaStateOps);
        this.state.initialize((StatementLocks)new SimpleStatementLocks(this.locks), null, PageCursorTracer.NULL);
        this.state.acquire();
    }

    @Test
    public void shouldAcquireEntityWriteLockBeforeAddingLabelToNode() throws Exception {
        this.lockingOps.nodeAddLabel(this.state, 123L, 456);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{123L});
        ((EntityWriteOperations)this.order.verify((Object)this.entityWriteOps)).nodeAddLabel(this.state, 123L, 456);
    }

    @Test
    public void shouldNotAcquireEntityWriteLockBeforeAddingLabelToJustCreatedNode() throws Exception {
        this.txState.nodeDoCreate(123L);
        this.lockingOps.nodeAddLabel(this.state, 123L, 456);
        ((Locks.Client)this.order.verify((Object)this.locks, Mockito.never())).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{123L});
        ((EntityWriteOperations)this.order.verify((Object)this.entityWriteOps)).nodeAddLabel(this.state, 123L, 456);
    }

    @Test
    public void shouldAcquireSchemaReadLockBeforeAddingLabelToNode() throws Exception {
        this.lockingOps.nodeAddLabel(this.state, 123L, 456);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.SCHEMA, new long[]{ResourceTypes.schemaResource()});
        ((EntityWriteOperations)this.order.verify((Object)this.entityWriteOps)).nodeAddLabel(this.state, 123L, 456);
    }

    @Test
    public void shouldAcquireEntityWriteLockBeforeSettingPropertyOnNode() throws Exception {
        DefinedProperty property = Property.property((int)8, (Object)9);
        this.lockingOps.nodeSetProperty(this.state, 123L, property);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{123L});
        ((EntityWriteOperations)this.order.verify((Object)this.entityWriteOps)).nodeSetProperty(this.state, 123L, property);
    }

    @Test
    public void shouldNotAcquireEntityWriteLockBeforeSettingPropertyOnJustCreatedNode() throws Exception {
        this.txState.nodeDoCreate(123L);
        DefinedProperty property = Property.property((int)8, (Object)9);
        this.lockingOps.nodeSetProperty(this.state, 123L, property);
        ((Locks.Client)this.order.verify((Object)this.locks, Mockito.never())).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{123L});
        ((EntityWriteOperations)this.order.verify((Object)this.entityWriteOps)).nodeSetProperty(this.state, 123L, property);
    }

    @Test
    public void shouldAcquireSchemaReadLockBeforeSettingPropertyOnNode() throws Exception {
        DefinedProperty property = Property.property((int)8, (Object)9);
        this.lockingOps.nodeSetProperty(this.state, 123L, property);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.SCHEMA, new long[]{ResourceTypes.schemaResource()});
        ((EntityWriteOperations)this.order.verify((Object)this.entityWriteOps)).nodeSetProperty(this.state, 123L, property);
    }

    @Test
    public void shouldAcquireEntityWriteLockBeforeDeletingNode() throws EntityNotFoundException, AutoIndexingKernelException, InvalidTransactionTypeKernelException {
        this.lockingOps.nodeDelete(this.state, 123L);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{123L});
        ((EntityWriteOperations)this.order.verify((Object)this.entityWriteOps)).nodeDelete(this.state, 123L);
    }

    @Test
    public void shouldNotAcquireEntityWriteLockBeforeDeletingJustCreatedNode() throws Exception {
        this.txState.nodeDoCreate(123L);
        this.lockingOps.nodeDelete(this.state, 123L);
        ((Locks.Client)this.order.verify((Object)this.locks, Mockito.never())).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{123L});
        ((EntityWriteOperations)this.order.verify((Object)this.entityWriteOps)).nodeDelete(this.state, 123L);
    }

    @Test
    public void shouldAcquireSchemaWriteLockBeforeAddingIndexRule() throws Exception {
        LabelSchemaDescriptor descriptor = SchemaDescriptorFactory.forLabel((int)123, (int[])new int[]{456});
        IndexDescriptor index = IndexDescriptorFactory.forLabel((int)123, (int[])new int[]{456});
        Mockito.when((Object)this.schemaWriteOps.indexCreate(this.state, descriptor)).thenReturn((Object)index);
        IndexDescriptor result = this.lockingOps.indexCreate(this.state, descriptor);
        Assert.assertSame((Object)index, (Object)result);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.SCHEMA, new long[]{ResourceTypes.schemaResource()});
        ((SchemaWriteOperations)this.order.verify((Object)this.schemaWriteOps)).indexCreate(this.state, descriptor);
    }

    @Test
    public void shouldAcquireSchemaWriteLockBeforeRemovingIndexRule() throws Exception {
        IndexDescriptor index = IndexDescriptorFactory.forLabel((int)0, (int[])new int[]{0});
        this.lockingOps.indexDrop(this.state, index);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.SCHEMA, new long[]{ResourceTypes.schemaResource()});
        ((SchemaWriteOperations)this.order.verify((Object)this.schemaWriteOps)).indexDrop(this.state, index);
    }

    @Test
    public void shouldAcquireSchemaReadLockBeforeGettingIndexRules() throws Exception {
        Iterator rules = Collections.emptyIterator();
        Mockito.when((Object)this.schemaReadOps.indexesGetAll(this.state)).thenReturn(rules);
        Iterator result = this.lockingOps.indexesGetAll(this.state);
        Assert.assertSame(rules, (Object)result);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.SCHEMA, new long[]{ResourceTypes.schemaResource()});
        ((SchemaReadOperations)this.order.verify((Object)this.schemaReadOps)).indexesGetAll(this.state);
    }

    @Test
    public void shouldAcquireSchemaWriteLockBeforeCreatingUniquenessConstraint() throws Exception {
        UniquenessConstraintDescriptor constraint = ConstraintDescriptorFactory.uniqueForSchema((SchemaDescriptor)this.descriptor);
        Mockito.when((Object)this.schemaWriteOps.uniquePropertyConstraintCreate(this.state, this.descriptor)).thenReturn((Object)constraint);
        UniquenessConstraintDescriptor result = this.lockingOps.uniquePropertyConstraintCreate(this.state, this.descriptor);
        Assert.assertSame((Object)constraint, (Object)result);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.SCHEMA, new long[]{ResourceTypes.schemaResource()});
        ((SchemaWriteOperations)this.order.verify((Object)this.schemaWriteOps)).uniquePropertyConstraintCreate(this.state, this.descriptor);
    }

    @Test
    public void shouldAcquireSchemaWriteLockBeforeDroppingConstraint() throws Exception {
        UniquenessConstraintDescriptor constraint = ConstraintDescriptorFactory.uniqueForSchema((SchemaDescriptor)this.descriptor);
        this.lockingOps.constraintDrop(this.state, (ConstraintDescriptor)constraint);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.SCHEMA, new long[]{ResourceTypes.schemaResource()});
        ((SchemaWriteOperations)this.order.verify((Object)this.schemaWriteOps)).constraintDrop(this.state, (ConstraintDescriptor)constraint);
    }

    @Test
    public void shouldAcquireSchemaReadLockBeforeGettingConstraintsByLabelAndProperty() throws Exception {
        Mockito.when((Object)this.schemaReadOps.constraintsGetForSchema(this.state, (SchemaDescriptor)this.descriptor)).thenReturn(Collections.emptyIterator());
        Iterator result = this.lockingOps.constraintsGetForSchema(this.state, (SchemaDescriptor)this.descriptor);
        MatcherAssert.assertThat((Object)Iterators.asList((Iterator)result), (Matcher)org.hamcrest.Matchers.empty());
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.SCHEMA, new long[]{ResourceTypes.schemaResource()});
        ((SchemaReadOperations)this.order.verify((Object)this.schemaReadOps)).constraintsGetForSchema(this.state, (SchemaDescriptor)this.descriptor);
    }

    @Test
    public void shouldAcquireSchemaReadLockBeforeGettingConstraintsByLabel() throws Exception {
        Mockito.when((Object)this.schemaReadOps.constraintsGetForLabel(this.state, 123)).thenReturn(Collections.emptyIterator());
        Iterator result = this.lockingOps.constraintsGetForLabel(this.state, 123);
        MatcherAssert.assertThat((Object)Iterators.asList((Iterator)result), (Matcher)org.hamcrest.Matchers.empty());
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.SCHEMA, new long[]{ResourceTypes.schemaResource()});
        ((SchemaReadOperations)this.order.verify((Object)this.schemaReadOps)).constraintsGetForLabel(this.state, 123);
    }

    @Test
    public void shouldAcquireSchemaReadLockBeforeGettingAllConstraints() throws Exception {
        Mockito.when((Object)this.schemaReadOps.constraintsGetAll(this.state)).thenReturn(Collections.emptyIterator());
        Iterator result = this.lockingOps.constraintsGetAll(this.state);
        MatcherAssert.assertThat((Object)Iterators.asList((Iterator)result), (Matcher)org.hamcrest.Matchers.empty());
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.SCHEMA, new long[]{ResourceTypes.schemaResource()});
        ((SchemaReadOperations)this.order.verify((Object)this.schemaReadOps)).constraintsGetAll(this.state);
    }

    @Test
    public void shouldAcquireSchemaReadLockBeforeUpdatingSchemaState() throws Exception {
        Function<Object, Object> creator = from -> null;
        this.lockingOps.schemaStateGetOrCreate(this.state, null, creator);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.SCHEMA, new long[]{ResourceTypes.schemaResource()});
        ((SchemaStateOperations)this.order.verify((Object)this.schemaStateOps)).schemaStateGetOrCreate(this.state, null, creator);
    }

    @Test
    public void shouldAcquireSchemaReadLockBeforeCheckingSchemaState() throws Exception {
        this.lockingOps.schemaStateContains(this.state, null);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.SCHEMA, new long[]{ResourceTypes.schemaResource()});
        ((SchemaStateOperations)this.order.verify((Object)this.schemaStateOps)).schemaStateContains(this.state, null);
    }

    @Test
    public void shouldAcquireSchemaReadLockBeforeFlushingSchemaState() throws Exception {
        this.lockingOps.schemaStateFlush(this.state);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.SCHEMA, new long[]{ResourceTypes.schemaResource()});
        ((SchemaStateOperations)this.order.verify((Object)this.schemaStateOps)).schemaStateFlush(this.state);
    }

    @Test
    public void shouldAcquireEntityWriteLockCreatingRelationship() throws Exception {
        this.lockingOps.relationshipCreate(this.state, 1, 2L, 3L);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{2L});
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{3L});
        ((EntityWriteOperations)this.order.verify((Object)this.entityWriteOps)).relationshipCreate(this.state, 1, 2L, 3L);
    }

    @Test
    public void shouldAcquireNodeLocksWhenCreatingRelationshipInOrderOfAscendingId() throws Exception {
        long lowId = 3L;
        long highId = 5L;
        this.lockingOps.relationshipCreate(this.state, 0, lowId, highId);
        InOrder lockingOrder = Mockito.inOrder((Object[])new Object[]{this.locks});
        ((Locks.Client)lockingOrder.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{lowId});
        ((Locks.Client)lockingOrder.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{highId});
        lockingOrder.verifyNoMoreInteractions();
        Mockito.reset((Object[])new Locks.Client[]{this.locks});
        this.lockingOps.relationshipCreate(this.state, 0, highId, lowId);
        lockingOrder = Mockito.inOrder((Object[])new Object[]{this.locks});
        ((Locks.Client)lockingOrder.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{lowId});
        ((Locks.Client)lockingOrder.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{highId});
        lockingOrder.verifyNoMoreInteractions();
    }

    @Test
    public void shouldAcquireNodeLocksWhenDeletingRelationshipInOrderOfAscendingId() throws Exception {
        long relationshipId = 10L;
        long lowId = 3L;
        long highId = 5L;
        ((EntityReadOperations)Mockito.doAnswer(invocation -> {
            RelationshipVisitor visitor = (RelationshipVisitor)invocation.getArguments()[2];
            visitor.visit(10L, 0, 3L, 5L);
            return null;
        }).when((Object)this.entityReadOps)).relationshipVisit((KernelStatement)Matchers.any(KernelStatement.class), Matchers.anyLong(), (RelationshipVisitor)Matchers.any(RelationshipVisitor.class));
        this.lockingOps.relationshipDelete(this.state, 10L);
        InOrder lockingOrder = Mockito.inOrder((Object[])new Object[]{this.locks});
        ((Locks.Client)lockingOrder.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{3L});
        ((Locks.Client)lockingOrder.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{5L});
        ((Locks.Client)lockingOrder.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.RELATIONSHIP, new long[]{10L});
        lockingOrder.verifyNoMoreInteractions();
        Mockito.reset((Object[])new Locks.Client[]{this.locks});
        ((EntityReadOperations)Mockito.doAnswer(invocation -> {
            RelationshipVisitor visitor = (RelationshipVisitor)invocation.getArguments()[2];
            visitor.visit(10L, 0, 5L, 3L);
            return null;
        }).when((Object)this.entityReadOps)).relationshipVisit((KernelStatement)Matchers.any(KernelStatement.class), Matchers.anyLong(), (RelationshipVisitor)Matchers.any(RelationshipVisitor.class));
        this.lockingOps.relationshipDelete(this.state, 10L);
        lockingOrder = Mockito.inOrder((Object[])new Object[]{this.locks});
        ((Locks.Client)lockingOrder.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{3L});
        ((Locks.Client)lockingOrder.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{5L});
        ((Locks.Client)lockingOrder.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.RELATIONSHIP, new long[]{10L});
        lockingOrder.verifyNoMoreInteractions();
    }

    @Test
    public void shouldAcquireEntityWriteLockBeforeSettingPropertyOnRelationship() throws Exception {
        DefinedProperty property = Property.property((int)8, (Object)9);
        this.lockingOps.relationshipSetProperty(this.state, 123L, property);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.RELATIONSHIP, new long[]{123L});
        ((EntityWriteOperations)this.order.verify((Object)this.entityWriteOps)).relationshipSetProperty(this.state, 123L, property);
    }

    @Test
    public void shouldNotAcquireEntityWriteLockBeforeSettingPropertyOnJustCreatedRelationship() throws Exception {
        this.txState.relationshipDoCreate(123L, 1, 2L, 3L);
        DefinedProperty property = Property.property((int)8, (Object)9);
        this.lockingOps.relationshipSetProperty(this.state, 123L, property);
        ((Locks.Client)this.order.verify((Object)this.locks, Mockito.never())).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.RELATIONSHIP, new long[]{123L});
        ((EntityWriteOperations)this.order.verify((Object)this.entityWriteOps)).relationshipSetProperty(this.state, 123L, property);
    }

    @Test
    public void detachDeleteNodeWithoutRelationshipsExclusivelyLockNode() throws KernelException {
        long nodeId = 1L;
        TwoPhaseNodeForRelationshipLockingTest.returnRelationships(this.entityReadOps, this.state, nodeId, false, new TwoPhaseNodeForRelationshipLockingTest.RelationshipData[0]);
        this.lockingOps.nodeDetachDelete(this.state, nodeId);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{nodeId});
        ((Locks.Client)this.order.verify((Object)this.locks, Mockito.times((int)0))).releaseExclusive((ResourceType)ResourceTypes.NODE, nodeId);
        ((EntityWriteOperations)this.order.verify((Object)this.entityWriteOps)).nodeDetachDelete(this.state, nodeId);
    }

    @Test
    public void detachDeleteNodeExclusivelyLockNodes() throws KernelException {
        long nodeId = 1L;
        TwoPhaseNodeForRelationshipLockingTest.RelationshipData relationship = new TwoPhaseNodeForRelationshipLockingTest.RelationshipData(1L, nodeId, 2L);
        TwoPhaseNodeForRelationshipLockingTest.returnRelationships(this.entityReadOps, this.state, nodeId, false, relationship);
        this.lockingOps.nodeDetachDelete(this.state, nodeId);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{relationship.startNodeId});
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{relationship.endNodeId});
        ((Locks.Client)this.order.verify((Object)this.locks, Mockito.times((int)0))).releaseExclusive((ResourceType)ResourceTypes.NODE, relationship.startNodeId);
        ((Locks.Client)this.order.verify((Object)this.locks, Mockito.times((int)0))).releaseExclusive((ResourceType)ResourceTypes.NODE, relationship.endNodeId);
        ((EntityWriteOperations)this.order.verify((Object)this.entityWriteOps)).nodeDetachDelete(this.state, nodeId);
    }

    private static class SimpleTxStateHolder
    implements TxStateHolder {
        private final TxState txState;

        private SimpleTxStateHolder(TxState txState) {
            this.txState = txState;
        }

        public TransactionState txState() {
            return this.txState;
        }

        public LegacyIndexTransactionState legacyIndexTxState() {
            return null;
        }

        public boolean hasTxStateWithChanges() {
            return this.txState.hasChanges();
        }
    }
}

