/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.index.Index;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageEngine;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.ImpermanentDatabaseRule;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.Workers;

public class TransactionRepresentationCommitProcessIT {
    private static final String INDEX_NAME = "index";
    private static final int TOTAL_ACTIVE_THREADS = 6;
    @Rule
    public final DatabaseRule db = new ImpermanentDatabaseRule().withSetting(GraphDatabaseSettings.check_point_interval_time, "10ms");

    @Test(timeout=15000L)
    public void commitDuringContinuousCheckpointing() throws Exception {
        Index index;
        try (Transaction tx = this.db.beginTx();){
            index = this.db.index().forNodes(INDEX_NAME, MapUtil.stringMap((String[])new String[]{"provider", "test-dummy-neo-index"}));
            tx.success();
        }
        final AtomicBoolean done = new AtomicBoolean();
        Workers workers = new Workers(this.getClass().getSimpleName());
        for (int i = 0; i < 6; ++i) {
            workers.start(new Runnable(){
                private final ThreadLocalRandom random = ThreadLocalRandom.current();

                @Override
                public void run() {
                    while (!done.get()) {
                        try (Transaction tx = TransactionRepresentationCommitProcessIT.this.db.beginTx();){
                            Node node = TransactionRepresentationCommitProcessIT.this.db.createNode();
                            index.add((PropertyContainer)node, "key", (Object)node.getId());
                            tx.success();
                        }
                        this.randomSleep();
                    }
                }

                private void randomSleep() {
                    try {
                        Thread.sleep(this.random.nextInt(50));
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        Thread.sleep(TimeUnit.SECONDS.toMillis(2L));
        done.set(true);
        workers.awaitAndThrowOnError(RuntimeException.class);
        NeoStores neoStores = this.getDependency(RecordStorageEngine.class).testAccessNeoStores();
        Assert.assertThat((String)"Count store should be rotated once at least", (Object)neoStores.getCounts().txId(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
        long lastRotationTx = this.getDependency(CheckPointer.class).forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("test"));
        Assert.assertEquals((String)"NeoStore last closed transaction id should be equal last count store rotation transaction id.", (long)neoStores.getMetaDataStore().getLastClosedTransactionId(), (long)lastRotationTx);
        Assert.assertEquals((String)"Last closed transaction should be last rotated tx in count store", (long)neoStores.getMetaDataStore().getLastClosedTransactionId(), (long)neoStores.getCounts().txId());
    }

    private <T> T getDependency(Class<T> clazz) {
        return (T)this.db.getDependencyResolver().resolveDependency(clazz);
    }
}

