/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Test;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.ContractCheckingIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexProxyAdapter;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.SchemaIndexTestHelper;
import org.neo4j.test.DoubleLatch;
import org.neo4j.test.ThreadTestUtils;

public class ContractCheckingIndexProxyTest {
    private static final long TEST_TIMEOUT = 10000L;

    @Test(expected=IllegalStateException.class)
    public void shouldNotCreateIndexTwice() throws IOException {
        IndexProxy inner = SchemaIndexTestHelper.mockIndexProxy();
        ContractCheckingIndexProxy outer = this.newContractCheckingIndexProxy(inner);
        outer.start();
        outer.start();
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotCloseIndexTwice() throws IOException {
        IndexProxy inner = SchemaIndexTestHelper.mockIndexProxy();
        ContractCheckingIndexProxy outer = this.newContractCheckingIndexProxy(inner);
        outer.close();
        outer.close();
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotDropIndexTwice() throws IOException {
        IndexProxy inner = SchemaIndexTestHelper.mockIndexProxy();
        ContractCheckingIndexProxy outer = this.newContractCheckingIndexProxy(inner);
        outer.drop();
        outer.drop();
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotDropAfterClose() throws IOException {
        IndexProxy inner = SchemaIndexTestHelper.mockIndexProxy();
        ContractCheckingIndexProxy outer = this.newContractCheckingIndexProxy(inner);
        outer.close();
        outer.drop();
    }

    @Test
    public void shouldDropAfterCreate() throws IOException {
        IndexProxy inner = SchemaIndexTestHelper.mockIndexProxy();
        ContractCheckingIndexProxy outer = this.newContractCheckingIndexProxy(inner);
        outer.start();
        outer.drop();
    }

    @Test
    public void shouldCloseAfterCreate() throws IOException {
        IndexProxy inner = SchemaIndexTestHelper.mockIndexProxy();
        ContractCheckingIndexProxy outer = this.newContractCheckingIndexProxy(inner);
        outer.start();
        outer.close();
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotUpdateBeforeCreate() throws Exception {
        IndexProxy inner = SchemaIndexTestHelper.mockIndexProxy();
        ContractCheckingIndexProxy outer = this.newContractCheckingIndexProxy(inner);
        try (IndexUpdater updater = outer.newUpdater(IndexUpdateMode.ONLINE);){
            updater.process(null);
        }
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotUpdateAfterClose() throws Exception {
        IndexProxy inner = SchemaIndexTestHelper.mockIndexProxy();
        ContractCheckingIndexProxy outer = this.newContractCheckingIndexProxy(inner);
        outer.start();
        outer.close();
        try (IndexUpdater updater = outer.newUpdater(IndexUpdateMode.ONLINE);){
            updater.process(null);
        }
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotForceBeforeCreate() throws IOException {
        IndexProxy inner = SchemaIndexTestHelper.mockIndexProxy();
        ContractCheckingIndexProxy outer = this.newContractCheckingIndexProxy(inner);
        outer.force();
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotForceAfterClose() throws IOException {
        IndexProxy inner = SchemaIndexTestHelper.mockIndexProxy();
        ContractCheckingIndexProxy outer = this.newContractCheckingIndexProxy(inner);
        outer.start();
        outer.close();
        outer.force();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalStateException.class)
    public void shouldNotCloseWhileCreating() throws IOException {
        final DoubleLatch latch = new DoubleLatch();
        IndexProxyAdapter inner = new IndexProxyAdapter(){

            @Override
            public void start() {
                latch.startAndWaitForAllToStartAndFinish();
            }
        };
        ContractCheckingIndexProxy outer = this.newContractCheckingIndexProxy(inner);
        this.runInSeparateThread(() -> ContractCheckingIndexProxyTest.lambda$shouldNotCloseWhileCreating$0((IndexProxy)outer));
        try {
            latch.waitForAllToStart();
            outer.close();
        }
        finally {
            latch.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalStateException.class)
    public void shouldNotDropWhileCreating() throws IOException {
        final DoubleLatch latch = new DoubleLatch();
        IndexProxyAdapter inner = new IndexProxyAdapter(){

            @Override
            public void start() {
                latch.startAndWaitForAllToStartAndFinish();
            }
        };
        ContractCheckingIndexProxy outer = this.newContractCheckingIndexProxy(inner);
        this.runInSeparateThread(() -> ContractCheckingIndexProxyTest.lambda$shouldNotDropWhileCreating$1((IndexProxy)outer));
        try {
            latch.waitForAllToStart();
            outer.drop();
        }
        finally {
            latch.finish();
        }
    }

    @Test(timeout=10000L)
    public void closeWaitForUpdateToFinish() throws IOException, InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        IndexProxyAdapter inner = new IndexProxyAdapter(){

            @Override
            public IndexUpdater newUpdater(IndexUpdateMode mode) {
                return super.newUpdater(mode);
            }
        };
        ContractCheckingIndexProxy outer = this.newContractCheckingIndexProxy(inner);
        Thread actionThread = this.createActionThread(() -> ((IndexProxy)outer).close());
        outer.start();
        Thread updaterThread = this.runInSeparateThread(() -> ContractCheckingIndexProxyTest.lambda$closeWaitForUpdateToFinish$2((IndexProxy)outer, actionThread, latch));
        ThreadTestUtils.awaitThreadState((Thread)actionThread, (long)5000L, (Thread.State)Thread.State.TIMED_WAITING, (Thread.State[])new Thread.State[0]);
        latch.countDown();
        updaterThread.join();
        actionThread.join();
    }

    @Test(timeout=10000L)
    public void closeWaitForForceToComplete() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference<Thread> actionThreadReference = new AtomicReference<Thread>();
        IndexProxyAdapter inner = new IndexProxyAdapter(){

            @Override
            public void force() {
                try {
                    ((Thread)actionThreadReference.get()).start();
                    latch.await();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        ContractCheckingIndexProxy outer = this.newContractCheckingIndexProxy(inner);
        Thread actionThread = this.createActionThread(() -> ((IndexProxy)outer).close());
        actionThreadReference.set(actionThread);
        outer.start();
        Thread thread = this.runInSeparateThread(() -> ((IndexProxy)outer).force());
        ThreadTestUtils.awaitThreadState((Thread)actionThread, (long)5000L, (Thread.State)Thread.State.TIMED_WAITING, (Thread.State[])new Thread.State[0]);
        latch.countDown();
        thread.join();
        actionThread.join();
    }

    private Thread runInSeparateThread(ThrowingRunnable action) {
        Thread thread = this.createActionThread(action);
        thread.start();
        return thread;
    }

    private Thread createActionThread(ThrowingRunnable action) {
        return new Thread(() -> {
            try {
                action.run();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private ContractCheckingIndexProxy newContractCheckingIndexProxy(IndexProxy inner) {
        return new ContractCheckingIndexProxy(inner, false);
    }

    private static /* synthetic */ void lambda$closeWaitForUpdateToFinish$2(IndexProxy outer, Thread actionThread, CountDownLatch latch) throws IOException {
        try (IndexUpdater updater = outer.newUpdater(IndexUpdateMode.ONLINE);){
            updater.process(null);
            try {
                actionThread.start();
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        catch (IndexEntryConflictException e) {
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ void lambda$shouldNotDropWhileCreating$1(IndexProxy outer) throws IOException {
        outer.start();
    }

    private static /* synthetic */ void lambda$shouldNotCloseWhileCreating$0(IndexProxy outer) throws IOException {
        outer.start();
    }

    private static interface ThrowingRunnable {
        public void run() throws IOException;
    }
}

