/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.mockito.Mockito;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.scan.LabelScanStoreProvider;
import org.neo4j.kernel.impl.storemigration.StoreMigrationParticipant;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.IndexSample;
import org.neo4j.test.DoubleLatch;

public class ControlledPopulationSchemaIndexProvider
extends SchemaIndexProvider {
    private IndexPopulator mockedPopulator = new IndexPopulator.Adapter();
    private final IndexAccessor mockedWriter = (IndexAccessor)Mockito.mock(IndexAccessor.class);
    private final CountDownLatch writerLatch = new CountDownLatch(1);
    private InternalIndexState initialIndexState = InternalIndexState.POPULATING;
    final AtomicInteger populatorCallCount = new AtomicInteger();
    final AtomicInteger writerCallCount = new AtomicInteger();
    public static final SchemaIndexProvider.Descriptor PROVIDER_DESCRIPTOR = new SchemaIndexProvider.Descriptor("controlled-population", "1.0");

    public ControlledPopulationSchemaIndexProvider() {
        super(PROVIDER_DESCRIPTOR, 10);
        this.setInitialIndexState(this.initialIndexState);
        Mockito.when((Object)this.mockedWriter.newReader()).thenReturn((Object)IndexReader.EMPTY);
    }

    public DoubleLatch installPopulationJobCompletionLatch() {
        final DoubleLatch populationCompletionLatch = new DoubleLatch();
        this.mockedPopulator = new IndexPopulator.Adapter(){

            public void create() throws IOException {
                populationCompletionLatch.startAndWaitForAllToStartAndFinish();
                super.create();
            }

            public IndexSample sampleResult() {
                return new IndexSample();
            }
        };
        return populationCompletionLatch;
    }

    public void awaitFullyPopulated() {
        DoubleLatch.awaitLatch(this.writerLatch);
    }

    public IndexPopulator getPopulator(long indexId, IndexDescriptor descriptor, IndexSamplingConfig samplingConfig) {
        this.populatorCallCount.incrementAndGet();
        return this.mockedPopulator;
    }

    public IndexAccessor getOnlineAccessor(long indexId, IndexDescriptor indexConfig, IndexSamplingConfig samplingConfig) {
        this.writerCallCount.incrementAndGet();
        this.writerLatch.countDown();
        return this.mockedWriter;
    }

    public InternalIndexState getInitialState(long indexId, IndexDescriptor descriptor) {
        return this.initialIndexState;
    }

    public void setInitialIndexState(InternalIndexState initialIndexState) {
        this.initialIndexState = initialIndexState;
    }

    public String getPopulationFailure(long indexId) throws IllegalStateException {
        throw new IllegalStateException();
    }

    public int compareTo(SchemaIndexProvider o) {
        return 1;
    }

    public StoreMigrationParticipant storeMigrationParticipant(FileSystemAbstraction fs, PageCache pageCache, LabelScanStoreProvider labelScanStoreProvider) {
        return StoreMigrationParticipant.NOT_PARTICIPATING;
    }
}

