/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.neo4j.kernel.api.exceptions.index.FlipFailedKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexProxyAlreadyClosedKernelException;
import org.neo4j.kernel.impl.api.index.FailedIndexProxyFactory;
import org.neo4j.kernel.impl.api.index.FlippableIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexProxyFactory;
import org.neo4j.kernel.impl.api.index.SchemaIndexTestHelper;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.test.rule.CleanupRule;

public class FlippableIndexProxyTest {
    @Rule
    public final CleanupRule cleanup = new CleanupRule();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void shouldBeAbleToSwitchDelegate() throws Exception {
        IndexProxy actual = SchemaIndexTestHelper.mockIndexProxy();
        IndexProxy other = SchemaIndexTestHelper.mockIndexProxy();
        FlippableIndexProxy delegate = new FlippableIndexProxy(actual);
        delegate.setFlipTarget(FlippableIndexProxyTest.singleProxy(other));
        delegate.flip(this.noOp(), null);
        delegate.drop().get();
        ((IndexProxy)Mockito.verify((Object)other)).drop();
    }

    @Test
    public void shouldNotBeAbleToFlipAfterClosed() throws Exception {
        IndexProxy actual = SchemaIndexTestHelper.mockIndexProxy();
        IndexProxyFactory indexContextFactory = (IndexProxyFactory)Mockito.mock(IndexProxyFactory.class);
        FlippableIndexProxy delegate = new FlippableIndexProxy(actual);
        delegate.close().get();
        delegate.setFlipTarget(indexContextFactory);
        this.expectedException.expect(IndexProxyAlreadyClosedKernelException.class);
        delegate.flip(this.noOp(), null);
    }

    @Test
    public void shouldNotBeAbleToFlipAfterDrop() throws Exception {
        IndexProxy actual = SchemaIndexTestHelper.mockIndexProxy();
        IndexProxy failed = SchemaIndexTestHelper.mockIndexProxy();
        IndexProxyFactory indexContextFactory = (IndexProxyFactory)Mockito.mock(IndexProxyFactory.class);
        FlippableIndexProxy delegate = new FlippableIndexProxy(actual);
        delegate.setFlipTarget(indexContextFactory);
        delegate.drop().get();
        this.expectedException.expect(IndexProxyAlreadyClosedKernelException.class);
        delegate.flip(this.noOp(), this.singleFailedDelegate(failed));
    }

    @Test
    public void shouldBlockAccessDuringFlipAndThenDelegateToCorrectContext() throws Exception {
        IndexProxy contextBeforeFlip = SchemaIndexTestHelper.mockIndexProxy();
        IndexProxy contextAfterFlip = SchemaIndexTestHelper.mockIndexProxy();
        FlippableIndexProxy flippable = new FlippableIndexProxy(contextBeforeFlip);
        flippable.setFlipTarget(FlippableIndexProxyTest.singleProxy(contextAfterFlip));
        CountDownLatch triggerFinishFlip = new CountDownLatch(1);
        CountDownLatch triggerExternalAccess = new CountDownLatch(1);
        OtherThreadExecutor<Object> flippingThread = this.cleanup.add(new OtherThreadExecutor<Object>("Flipping thread", null));
        OtherThreadExecutor<Object> dropIndexThread = this.cleanup.add(new OtherThreadExecutor<Object>("Drop index thread", null));
        Future<Void> flipContextFuture = flippingThread.executeDontWait(this.startFlipAndWaitForLatchBeforeFinishing(flippable, triggerFinishFlip, triggerExternalAccess));
        Assert.assertTrue((boolean)triggerExternalAccess.await(10L, TimeUnit.SECONDS));
        Future<Void> dropIndexFuture = dropIndexThread.executeDontWait(this.dropTheIndex(flippable));
        dropIndexThread.waitUntilWaiting();
        triggerFinishFlip.countDown();
        dropIndexFuture.get(10L, TimeUnit.SECONDS);
        flipContextFuture.get(10L, TimeUnit.SECONDS);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{contextBeforeFlip});
        ((IndexProxy)Mockito.verify((Object)contextAfterFlip)).drop();
    }

    private OtherThreadExecutor.WorkerCommand<Void, Void> dropTheIndex(final FlippableIndexProxy flippable) {
        return new OtherThreadExecutor.WorkerCommand<Void, Void>(){

            @Override
            public Void doWork(Void state) throws IOException {
                SchemaIndexTestHelper.awaitFuture(flippable.drop());
                return null;
            }
        };
    }

    private OtherThreadExecutor.WorkerCommand<Void, Void> startFlipAndWaitForLatchBeforeFinishing(final FlippableIndexProxy flippable, final CountDownLatch triggerFinishFlip, final CountDownLatch triggerExternalAccess) {
        return new OtherThreadExecutor.WorkerCommand<Void, Void>(){

            @Override
            public Void doWork(Void state) throws FlipFailedKernelException {
                flippable.flip((Callable)new Callable<Void>(){

                    @Override
                    public Void call() {
                        triggerExternalAccess.countDown();
                        Assert.assertTrue((boolean)SchemaIndexTestHelper.awaitLatch(triggerFinishFlip));
                        return null;
                    }
                }, null);
                return null;
            }
        };
    }

    private Callable<Void> noOp() {
        return () -> null;
    }

    public static IndexProxyFactory singleProxy(IndexProxy proxy) {
        return () -> proxy;
    }

    private FailedIndexProxyFactory singleFailedDelegate(IndexProxy failed) {
        return failure -> failed;
    }
}

