/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.index.DelegatingIndexReader;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.inmemory.InMemoryIndexProvider;
import org.neo4j.kernel.impl.api.index.inmemory.InMemoryIndexProviderFactory;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingMode;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.IndexSample;
import org.neo4j.storageengine.api.schema.IndexSampler;
import org.neo4j.test.Barrier;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.ImpermanentDatabaseRule;

public class IndexSamplingCancellationTest {
    private final Barrier.Control samplingStarted = new Barrier.Control();
    private final Barrier.Control samplingDone = new Barrier.Control();
    private volatile Throwable samplingException;
    private final InMemoryIndexProvider index = new TestInMemoryIndexProvider();
    @Rule
    public final DatabaseRule db = new ImpermanentDatabaseRule(){

        @Override
        protected void configure(GraphDatabaseFactory factory) {
            ((TestGraphDatabaseFactory)factory).addKernelExtension(new InMemoryIndexProviderFactory(IndexSamplingCancellationTest.this.index));
        }

        @Override
        protected void configure(GraphDatabaseBuilder builder) {
            builder.setConfig(GraphDatabaseSettings.index_background_sampling_enabled, "false");
        }
    };

    @Test
    public void shouldStopSamplingWhenIndexIsDropped() throws Exception {
        IndexDefinition index = this.awaitOnline(this.indexOn(Label.label((String)"Foo"), "bar"));
        this.db.resolveDependency(IndexingService.class).triggerIndexSampling(IndexSamplingMode.TRIGGER_REBUILD_ALL);
        this.samplingStarted.await();
        this.drop(index);
        this.samplingDone.release();
        this.samplingStarted.release();
        this.samplingDone.await();
        Throwable exception = this.samplingException;
        Assert.assertThat((Object)exception, (Matcher)Matchers.instanceOf(IndexNotFoundKernelException.class));
        Assert.assertEquals((Object)"Index dropped while sampling.", (Object)exception.getMessage());
    }

    private void drop(IndexDefinition index) {
        try (Transaction tx = this.db.beginTx();){
            index.drop();
            tx.success();
        }
    }

    private IndexDefinition indexOn(Label label, String propertyKey) {
        IndexDefinition index;
        try (Transaction tx = this.db.beginTx();){
            index = this.db.schema().indexFor(label).on(propertyKey).create();
            tx.success();
        }
        return index;
    }

    private IndexDefinition awaitOnline(IndexDefinition index) {
        try (Transaction tx = this.db.beginTx();){
            this.db.schema().awaitIndexOnline(index, 3L, TimeUnit.SECONDS);
            tx.success();
        }
        return index;
    }

    private class DelegatingIndexSampler
    implements IndexSampler {
        final IndexSampler delegate;

        DelegatingIndexSampler(IndexSampler delegate) {
            this.delegate = delegate;
        }

        public IndexSample sampleIndex() throws IndexNotFoundKernelException {
            try {
                IndexSample indexSample = this.delegate.sampleIndex();
                return indexSample;
            }
            catch (Throwable e) {
                IndexSamplingCancellationTest.this.samplingException = e;
                throw e;
            }
            finally {
                IndexSamplingCancellationTest.this.samplingDone.reached();
            }
        }
    }

    private class TestIndexReader
    extends DelegatingIndexReader {
        TestIndexReader(IndexReader delegate) {
            super(delegate);
        }

        public IndexSampler createSampler() {
            IndexSamplingCancellationTest.this.samplingStarted.reached();
            IndexSampler sampler = super.createSampler();
            return new DelegatingIndexSampler(sampler);
        }
    }

    private class DelegatingIndexAccessor
    extends IndexAccessor.Delegator {
        DelegatingIndexAccessor(IndexAccessor delegate) {
            super(delegate);
        }

        public IndexReader newReader() {
            return new TestIndexReader(super.newReader());
        }
    }

    private class TestInMemoryIndexProvider
    extends InMemoryIndexProvider {
        TestInMemoryIndexProvider() {
            super(100);
        }

        @Override
        public IndexAccessor getOnlineAccessor(long indexId, IndexDescriptor descriptor, IndexSamplingConfig samplingConfig) {
            return new DelegatingIndexAccessor(super.getOnlineAccessor(indexId, descriptor, samplingConfig));
        }
    }
}

