/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptorFactory;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.OnlineIndexProxy;

public class OnlineIndexProxyTest {
    private final long indexId = 1L;
    private final IndexDescriptor descriptor = IndexDescriptorFactory.forLabel((int)1, (int[])new int[]{2});
    private final SchemaIndexProvider.Descriptor providerDescriptor = (SchemaIndexProvider.Descriptor)Mockito.mock(SchemaIndexProvider.Descriptor.class);
    private final IndexAccessor accessor = (IndexAccessor)Mockito.mock(IndexAccessor.class);
    private final IndexStoreView storeView = (IndexStoreView)Mockito.mock(IndexStoreView.class);

    @Test
    public void shouldRemoveIndexCountsWhenTheIndexItselfIsDropped() throws IOException {
        OnlineIndexProxy index = new OnlineIndexProxy(1L, this.descriptor, this.accessor, this.storeView, this.providerDescriptor, false);
        index.drop();
        ((IndexAccessor)Mockito.verify((Object)this.accessor)).drop();
        ((IndexStoreView)Mockito.verify((Object)this.storeView)).replaceIndexCounts(1L, 0L, 0L, 0L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.accessor, this.storeView});
    }
}

