/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.inmemory;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.storageengine.api.schema.IndexSample;
import org.neo4j.storageengine.api.schema.IndexSampler;

public class HashBasedIndexSampler
implements IndexSampler {
    private final Map<List<Object>, Set<Long>> data;

    public HashBasedIndexSampler(Map<List<Object>, Set<Long>> data) {
        this.data = data;
    }

    public IndexSample sampleIndex() throws IndexNotFoundKernelException {
        if (this.data == null) {
            throw new IndexNotFoundKernelException("Index dropped while sampling.");
        }
        long uniqueValues = 0L;
        long indexSize = 0L;
        for (Map.Entry<List<Object>, Set<Long>> entry : this.data.entrySet()) {
            Set<Long> nodeIds = entry.getValue();
            if (nodeIds.isEmpty()) continue;
            ++uniqueValues;
            indexSize += (long)nodeIds.size();
        }
        return new IndexSample(indexSize, uniqueValues, indexSize);
    }
}

