/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.sampling;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptorFactory;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingJob;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingJobTracker;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.impl.util.Neo4jJobScheduler;
import org.neo4j.test.DoubleLatch;

public class IndexSamplingJobTrackerTest {
    private final IndexSamplingConfig config = (IndexSamplingConfig)Mockito.mock(IndexSamplingConfig.class);
    LabelSchemaDescriptor descriptor11 = SchemaDescriptorFactory.forLabel((int)1, (int[])new int[]{1});
    LabelSchemaDescriptor descriptor12 = SchemaDescriptorFactory.forLabel((int)1, (int[])new int[]{2});
    LabelSchemaDescriptor descriptor22 = SchemaDescriptorFactory.forLabel((int)2, (int[])new int[]{2});
    IndexDescriptor index11 = IndexDescriptorFactory.forSchema((LabelSchemaDescriptor)this.descriptor11);
    IndexDescriptor index12 = IndexDescriptorFactory.forSchema((LabelSchemaDescriptor)this.descriptor12);
    IndexDescriptor index22 = IndexDescriptorFactory.forSchema((LabelSchemaDescriptor)this.descriptor22);
    long indexId11 = 0L;
    long indexId12 = 1L;
    long indexId22 = 2L;

    @Test
    public void shouldNotRunASampleJobWhichIsAlreadyRunning() throws Throwable {
        Mockito.when((Object)this.config.jobLimit()).thenReturn((Object)2);
        Neo4jJobScheduler jobScheduler = new Neo4jJobScheduler();
        jobScheduler.init();
        IndexSamplingJobTracker jobTracker = new IndexSamplingJobTracker(this.config, (JobScheduler)jobScheduler);
        final DoubleLatch latch = new DoubleLatch();
        final AtomicInteger count = new AtomicInteger(0);
        Assert.assertTrue((boolean)jobTracker.canExecuteMoreSamplingJobs());
        IndexSamplingJob job = new IndexSamplingJob(){

            public void run() {
                count.incrementAndGet();
                latch.waitForAllToStart();
                latch.finish();
            }

            public long indexId() {
                return IndexSamplingJobTrackerTest.this.indexId12;
            }
        };
        jobTracker.scheduleSamplingJob(job);
        jobTracker.scheduleSamplingJob(job);
        latch.startAndWaitForAllToStart();
        latch.waitForAllToFinish();
        Assert.assertEquals((long)1L, (long)count.get());
    }

    @Test
    public void shouldNotAcceptMoreJobsThanAllowed() throws Throwable {
        Mockito.when((Object)this.config.jobLimit()).thenReturn((Object)1);
        Neo4jJobScheduler jobScheduler = new Neo4jJobScheduler();
        jobScheduler.init();
        IndexSamplingJobTracker jobTracker = new IndexSamplingJobTracker(this.config, (JobScheduler)jobScheduler);
        final DoubleLatch latch = new DoubleLatch();
        DoubleLatch waitingLatch = new DoubleLatch();
        Assert.assertTrue((boolean)jobTracker.canExecuteMoreSamplingJobs());
        jobTracker.scheduleSamplingJob(new IndexSamplingJob(){

            public void run() {
                latch.startAndWaitForAllToStart();
                latch.waitForAllToFinish();
            }

            public long indexId() {
                return IndexSamplingJobTrackerTest.this.indexId12;
            }
        });
        latch.waitForAllToStart();
        Assert.assertFalse((boolean)jobTracker.canExecuteMoreSamplingJobs());
        AtomicBoolean waiting = new AtomicBoolean(false);
        new Thread(() -> {
            waiting.set(true);
            waitingLatch.startAndWaitForAllToStart();
            jobTracker.waitUntilCanExecuteMoreSamplingJobs();
            waiting.set(false);
            waitingLatch.finish();
        }).start();
        waitingLatch.waitForAllToStart();
        Assert.assertTrue((boolean)waiting.get());
        latch.finish();
        waitingLatch.waitForAllToFinish();
        Assert.assertFalse((boolean)waiting.get());
        while (!jobTracker.canExecuteMoreSamplingJobs()) {
            Thread.yield();
        }
    }

    @Test(timeout=5000L)
    public void shouldAcceptNewJobWhenRunningJobFinishes() throws Throwable {
        Mockito.when((Object)this.config.jobLimit()).thenReturn((Object)1);
        Neo4jJobScheduler jobScheduler = new Neo4jJobScheduler();
        jobScheduler.init();
        IndexSamplingJobTracker jobTracker = new IndexSamplingJobTracker(this.config, (JobScheduler)jobScheduler);
        final DoubleLatch latch = new DoubleLatch();
        final AtomicBoolean lastJobExecuted = new AtomicBoolean();
        jobTracker.scheduleSamplingJob(new IndexSamplingJob(){

            public long indexId() {
                return IndexSamplingJobTrackerTest.this.indexId11;
            }

            public void run() {
                latch.waitForAllToStart();
            }
        });
        Executors.newSingleThreadExecutor().execute(() -> {
            jobTracker.waitUntilCanExecuteMoreSamplingJobs();
            jobTracker.scheduleSamplingJob(new IndexSamplingJob(){

                public long indexId() {
                    return IndexSamplingJobTrackerTest.this.indexId22;
                }

                public void run() {
                    lastJobExecuted.set(true);
                    latch.finish();
                }
            });
        });
        Assert.assertFalse((boolean)jobTracker.canExecuteMoreSamplingJobs());
        latch.startAndWaitForAllToStart();
        latch.waitForAllToFinish();
        Assert.assertTrue((boolean)lastJobExecuted.get());
    }

    @Test(timeout=5000L)
    public void shouldDoNothingWhenUsedAfterBeingStopped() {
        JobScheduler scheduler = (JobScheduler)Mockito.mock(JobScheduler.class);
        IndexSamplingJobTracker jobTracker = new IndexSamplingJobTracker(this.config, scheduler);
        jobTracker.stopAndAwaitAllJobs();
        jobTracker.scheduleSamplingJob((IndexSamplingJob)Mockito.mock(IndexSamplingJob.class));
        Mockito.verifyZeroInteractions((Object[])new Object[]{scheduler});
    }

    @Test(timeout=5000L)
    public void shouldNotAllowNewJobsAfterBeingStopped() {
        IndexSamplingJobTracker jobTracker = new IndexSamplingJobTracker(this.config, (JobScheduler)Mockito.mock(JobScheduler.class));
        jobTracker.stopAndAwaitAllJobs();
        Assert.assertFalse((boolean)jobTracker.canExecuteMoreSamplingJobs());
    }

    @Test(timeout=5000L)
    public void shouldStopAndWaitForAllJobsToFinish() throws Throwable {
        Mockito.when((Object)this.config.jobLimit()).thenReturn((Object)2);
        Neo4jJobScheduler jobScheduler = new Neo4jJobScheduler();
        jobScheduler.init();
        IndexSamplingJobTracker jobTracker = new IndexSamplingJobTracker(this.config, (JobScheduler)jobScheduler);
        CountDownLatch latch1 = new CountDownLatch(1);
        CountDownLatch latch2 = new CountDownLatch(1);
        WaitingIndexSamplingJob job1 = new WaitingIndexSamplingJob(this.indexId11, latch1);
        WaitingIndexSamplingJob job2 = new WaitingIndexSamplingJob(this.indexId22, latch1);
        jobTracker.scheduleSamplingJob((IndexSamplingJob)job1);
        jobTracker.scheduleSamplingJob((IndexSamplingJob)job2);
        Future<?> stopping = Executors.newSingleThreadExecutor().submit(() -> {
            latch2.countDown();
            jobTracker.stopAndAwaitAllJobs();
        });
        latch2.await();
        Assert.assertFalse((boolean)stopping.isDone());
        latch1.countDown();
        stopping.get(10L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)stopping.isDone());
        Assert.assertNull(stopping.get());
        Assert.assertTrue((boolean)job1.executed);
        Assert.assertTrue((boolean)job2.executed);
    }

    @Test(timeout=5000L)
    public void shouldWaitForAllJobsToFinish() throws Throwable {
        Mockito.when((Object)this.config.jobLimit()).thenReturn((Object)2);
        Neo4jJobScheduler jobScheduler = new Neo4jJobScheduler();
        jobScheduler.init();
        IndexSamplingJobTracker jobTracker = new IndexSamplingJobTracker(this.config, (JobScheduler)jobScheduler);
        CountDownLatch latch1 = new CountDownLatch(1);
        CountDownLatch latch2 = new CountDownLatch(1);
        WaitingIndexSamplingJob job1 = new WaitingIndexSamplingJob(this.indexId11, latch1);
        WaitingIndexSamplingJob job2 = new WaitingIndexSamplingJob(this.indexId22, latch1);
        jobTracker.scheduleSamplingJob((IndexSamplingJob)job1);
        jobTracker.scheduleSamplingJob((IndexSamplingJob)job2);
        Future<?> stopping = Executors.newSingleThreadExecutor().submit(() -> {
            latch2.countDown();
            try {
                jobTracker.awaitAllJobs(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        });
        latch2.await();
        Assert.assertFalse((boolean)stopping.isDone());
        latch1.countDown();
        stopping.get(10L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)stopping.isDone());
        Assert.assertNull(stopping.get());
        Assert.assertTrue((boolean)job1.executed);
        Assert.assertTrue((boolean)job2.executed);
    }

    private static class WaitingIndexSamplingJob
    implements IndexSamplingJob {
        final long indexId;
        final CountDownLatch latch;
        volatile boolean executed;

        WaitingIndexSamplingJob(long indexId, CountDownLatch latch) {
            this.indexId = indexId;
            this.latch = latch;
        }

        public long indexId() {
            return this.indexId;
        }

        public void run() {
            try {
                this.latch.await();
                this.executed = true;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
    }
}

