/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsEqual;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.collection.RawIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.TokenWriteOperations;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.proc.ProcedureSignature;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;
import org.neo4j.kernel.internal.Version;

public class BuiltInProceduresIT
extends KernelIntegrationTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void listAllLabels() throws Throwable {
        Statement statement = this.statementInNewTransaction((SecurityContext)AnonymousContext.writeToken());
        long nodeId = statement.dataWriteOperations().nodeCreate();
        int labelId = statement.tokenWriteOperations().labelGetOrCreateForName("MyLabel");
        statement.dataWriteOperations().nodeAddLabel(nodeId, labelId);
        this.commit();
        RawIterator stream = this.procedureCallOpsInNewTx().procedureCallRead(ProcedureSignature.procedureName((String[])new String[]{"db", "labels"}), new Object[0]);
        MatcherAssert.assertThat((Object)Iterators.asList((RawIterator)stream), (Matcher)Matchers.contains((Matcher)IsEqual.equalTo((Object)new Object[]{"MyLabel"})));
    }

    @Test
    public void listPropertyKeys() throws Throwable {
        TokenWriteOperations ops = this.tokenWriteOperationsInNewTransaction();
        ops.propertyKeyGetOrCreateForName("MyProp");
        this.commit();
        RawIterator stream = this.procedureCallOpsInNewTx().procedureCallRead(ProcedureSignature.procedureName((String[])new String[]{"db", "propertyKeys"}), new Object[0]);
        MatcherAssert.assertThat((Object)Iterators.asList((RawIterator)stream), (Matcher)Matchers.contains((Matcher)IsEqual.equalTo((Object)new Object[]{"MyProp"})));
    }

    @Test
    public void listRelationshipTypes() throws Throwable {
        Statement statement = this.statementInNewTransaction((SecurityContext)AnonymousContext.writeToken());
        int relType = statement.tokenWriteOperations().relationshipTypeGetOrCreateForName("MyRelType");
        long startNodeId = statement.dataWriteOperations().nodeCreate();
        long endNodeId = statement.dataWriteOperations().nodeCreate();
        statement.dataWriteOperations().relationshipCreate(relType, startNodeId, endNodeId);
        this.commit();
        RawIterator stream = this.procedureCallOpsInNewTx().procedureCallRead(ProcedureSignature.procedureName((String[])new String[]{"db", "relationshipTypes"}), new Object[0]);
        MatcherAssert.assertThat((Object)Iterators.asList((RawIterator)stream), (Matcher)Matchers.contains((Matcher)IsEqual.equalTo((Object)new Object[]{"MyRelType"})));
    }

    @Test
    public void listProcedures() throws Throwable {
        RawIterator stream = this.procedureCallOpsInNewTx().procedureCallRead(ProcedureSignature.procedureName((String[])new String[]{"dbms", "procedures"}), new Object[0]);
        MatcherAssert.assertThat((Object)Iterators.asList((RawIterator)stream), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{IsEqual.equalTo((Object)new Object[]{"dbms.listConfig", "dbms.listConfig(searchString =  :: STRING?) :: (name :: STRING?, description :: STRING?, value :: STRING?)", "List the currently active config of Neo4j."}), IsEqual.equalTo((Object)new Object[]{"db.constraints", "db.constraints() :: (description :: STRING?)", "List all constraints in the database."}), IsEqual.equalTo((Object)new Object[]{"db.indexes", "db.indexes() :: (description :: STRING?, state :: STRING?, type :: STRING?)", "List all indexes in the database."}), IsEqual.equalTo((Object)new Object[]{"db.awaitIndex", "db.awaitIndex(index :: STRING?, timeOutSeconds = 300 :: INTEGER?) :: VOID", "Wait for an index to come online (for example: CALL db.awaitIndex(\":Person(name)\"))."}), IsEqual.equalTo((Object)new Object[]{"db.resampleIndex", "db.resampleIndex(index :: STRING?) :: VOID", "Schedule resampling of an index (for example: CALL db.resampleIndex(\":Person(name)\"))."}), IsEqual.equalTo((Object)new Object[]{"db.resampleOutdatedIndexes", "db.resampleOutdatedIndexes() :: VOID", "Schedule resampling of all outdated indexes."}), IsEqual.equalTo((Object)new Object[]{"db.propertyKeys", "db.propertyKeys() :: (propertyKey :: STRING?)", "List all property keys in the database."}), IsEqual.equalTo((Object)new Object[]{"db.labels", "db.labels() :: (label :: STRING?)", "List all labels in the database."}), IsEqual.equalTo((Object)new Object[]{"db.schema", "db.schema() :: (nodes :: LIST? OF NODE?, relationships :: LIST? OF RELATIONSHIP?)", "Show the schema of the data."}), IsEqual.equalTo((Object)new Object[]{"db.relationshipTypes", "db.relationshipTypes() :: (relationshipType :: STRING?)", "List all relationship types in the database."}), IsEqual.equalTo((Object)new Object[]{"dbms.procedures", "dbms.procedures() :: (name :: STRING?, signature :: STRING?, description :: STRING?)", "List all procedures in the DBMS."}), IsEqual.equalTo((Object)new Object[]{"dbms.functions", "dbms.functions() :: (name :: STRING?, signature :: STRING?, description :: STRING?)", "List all user functions in the DBMS."}), IsEqual.equalTo((Object)new Object[]{"dbms.components", "dbms.components() :: (name :: STRING?, versions :: LIST? OF STRING?, edition :: STRING?)", "List DBMS components and their versions."}), IsEqual.equalTo((Object)new Object[]{"dbms.queryJmx", "dbms.queryJmx(query :: STRING?) :: (name :: STRING?, description :: STRING?, attributes :: MAP?)", "Query JMX management data by domain and name. For instance, \"org.neo4j:*\""}), IsEqual.equalTo((Object)new Object[]{"db.createLabel", "db.createLabel(newLabel :: STRING?) :: VOID", "Create a label"}), IsEqual.equalTo((Object)new Object[]{"db.createProperty", "db.createProperty(newProperty :: STRING?) :: VOID", "Create a Property"}), IsEqual.equalTo((Object)new Object[]{"db.createRelationshipType", "db.createRelationshipType(newRelationshipType :: STRING?) :: VOID", "Create a RelationshipType"})}));
    }

    @Test
    public void failWhenCallingNonExistingProcedures() throws Throwable {
        try {
            this.dbmsOperations().procedureCallDbms(ProcedureSignature.procedureName((String[])new String[]{"dbms", "iDoNotExist"}), new Object[0], (SecurityContext)AnonymousContext.none());
            TestCase.fail((String)"This should never get here");
        }
        catch (Exception e) {
            MatcherAssert.assertThat(e.getClass(), (Matcher)IsEqual.equalTo(ProcedureException.class));
        }
    }

    @Test
    public void listAllComponents() throws Throwable {
        RawIterator stream = this.procedureCallOpsInNewTx().procedureCallRead(ProcedureSignature.procedureName((String[])new String[]{"dbms", "components"}), new Object[0]);
        MatcherAssert.assertThat((Object)Iterators.asList((RawIterator)stream), (Matcher)Matchers.contains((Matcher)IsEqual.equalTo((Object)new Object[]{"Neo4j Kernel", Collections.singletonList(Version.getNeo4jVersion()), "community"})));
    }

    @Test
    public void listAllIndexes() throws Throwable {
        Statement statement = this.statementInNewTransaction(SecurityContext.AUTH_DISABLED);
        int labelId1 = statement.tokenWriteOperations().labelGetOrCreateForName("Person");
        int labelId2 = statement.tokenWriteOperations().labelGetOrCreateForName("Age");
        int propertyKeyId = statement.tokenWriteOperations().propertyKeyGetOrCreateForName("foo");
        statement.schemaWriteOperations().indexCreate(SchemaDescriptorFactory.forLabel((int)labelId1, (int[])new int[]{propertyKeyId}));
        statement.schemaWriteOperations().uniquePropertyConstraintCreate(SchemaDescriptorFactory.forLabel((int)labelId2, (int[])new int[]{propertyKeyId}));
        this.commit();
        try (Transaction tx = this.db.beginTx();){
            this.db.schema().awaitIndexOnline((IndexDefinition)this.db.schema().getIndexes().iterator().next(), 20L, TimeUnit.SECONDS);
            tx.success();
        }
        RawIterator stream = this.procedureCallOpsInNewTx().procedureCallRead(ProcedureSignature.procedureName((String[])new String[]{"db", "indexes"}), new Object[0]);
        HashSet<Object> result = new HashSet<Object>();
        while (stream.hasNext()) {
            result.add(stream.next());
        }
        MatcherAssert.assertThat(result, (Matcher)Matchers.containsInAnyOrder((Object[])new Object[][]{{"INDEX ON :Age(foo)", "ONLINE", "node_unique_property"}, {"INDEX ON :Person(foo)", "ONLINE", "node_label_property"}}));
    }
}

