/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.neo4j.collection.primitive.PrimitiveIntCollections;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveIntSet;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.cursor.Cursor;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.impl.api.Kernel;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public class KernelIT
extends KernelIntegrationTest {
    @Test
    public void mixingBeansApiWithKernelAPI() throws Exception {
        Transaction transaction = this.db.beginTx();
        Statement statement = this.statementContextSupplier.get();
        Node node = this.db.createNode();
        int labelId = statement.tokenWriteOperations().labelGetOrCreateForName("labello");
        statement.dataWriteOperations().nodeAddLabel(node.getId(), labelId);
        statement.close();
        transaction.success();
        transaction.close();
    }

    @Test
    public void mixingBeansApiWithKernelAPIForNestedTransaction() throws Exception {
        Transaction outerTx = this.db.beginTx();
        Statement statement = this.statementContextSupplier.get();
        Node node = this.db.createNode();
        int labelId = statement.tokenWriteOperations().labelGetOrCreateForName("labello");
        statement.dataWriteOperations().nodeAddLabel(node.getId(), labelId);
        statement.close();
        outerTx.close();
    }

    @Test
    public void changesInTransactionContextShouldBeRolledBackWhenTxIsRolledBack() throws Exception {
        int labelId;
        Node node;
        Statement statement;
        try (Transaction tx = this.db.beginTx();){
            statement = this.statementContextSupplier.get();
            node = this.db.createNode();
            labelId = statement.tokenWriteOperations().labelGetOrCreateForName("labello");
            statement.dataWriteOperations().nodeAddLabel(node.getId(), labelId);
            statement.close();
        }
        tx = this.db.beginTx();
        var4_2 = null;
        try {
            try {
                statement = this.statementContextSupplier.get();
                Throwable throwable = null;
                try {
                    statement.readOperations().nodeHasLabel(node.getId(), labelId);
                    Assert.fail((String)"should have thrown exception");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (statement != null) {
                        if (throwable != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            statement.close();
                        }
                    }
                }
            }
            catch (EntityNotFoundException entityNotFoundException) {
                // empty catch block
            }
        }
        catch (Throwable throwable) {
            var4_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldNotBeAbleToCommitIfFailedTransactionContext() throws Exception {
        Statement statement2;
        Throwable throwable;
        Node node = null;
        int labelId = -1;
        TransactionFailureException expectedException = null;
        try {
            throwable = null;
            try (Transaction transaction = this.db.beginTx();){
                statement2 = this.statementContextSupplier.get();
                node = this.db.createNode();
                labelId = statement2.tokenWriteOperations().labelGetOrCreateForName("labello");
                statement2.dataWriteOperations().nodeAddLabel(node.getId(), labelId);
                statement2.close();
                transaction.failure();
                transaction.success();
            }
            catch (Throwable statement2) {
                throwable = statement2;
                throw statement2;
            }
        }
        catch (TransactionFailureException e) {
            expectedException = e;
        }
        finally {
            Assert.assertNotNull((String)"Should have failed", (Object)((Object)expectedException));
        }
        throwable = null;
        try (Transaction tx = this.db.beginTx();){
            statement2 = this.statementContextSupplier.get();
            try {
                statement2.readOperations().nodeHasLabel(node.getId(), labelId);
                Assert.fail((String)"should have thrown exception");
            }
            catch (EntityNotFoundException entityNotFoundException) {
                // empty catch block
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }

    @Test
    public void transactionStateShouldRemovePreviouslyAddedLabel() throws Exception {
        Transaction tx = this.db.beginTx();
        Statement statement = this.statementContextSupplier.get();
        Node node = this.db.createNode();
        int labelId1 = statement.tokenWriteOperations().labelGetOrCreateForName("labello1");
        int labelId2 = statement.tokenWriteOperations().labelGetOrCreateForName("labello2");
        statement.dataWriteOperations().nodeAddLabel(node.getId(), labelId1);
        statement.dataWriteOperations().nodeAddLabel(node.getId(), labelId2);
        statement.dataWriteOperations().nodeRemoveLabel(node.getId(), labelId2);
        statement.close();
        tx.success();
        tx.close();
        tx = this.db.beginTx();
        statement = this.statementContextSupplier.get();
        Assert.assertEquals((Object)PrimitiveIntCollections.asSet((int[])new int[]{labelId1}), (Object)PrimitiveIntCollections.asSet((PrimitiveIntIterator)statement.readOperations().nodeGetLabels(node.getId())));
        tx.close();
    }

    @Test
    public void transactionStateShouldReflectRemovingAddedLabelImmediately() throws Exception {
        Transaction tx = this.db.beginTx();
        Statement statement = this.statementContextSupplier.get();
        Node node = this.db.createNode();
        int labelId1 = statement.tokenWriteOperations().labelGetOrCreateForName("labello1");
        int labelId2 = statement.tokenWriteOperations().labelGetOrCreateForName("labello2");
        statement.dataWriteOperations().nodeAddLabel(node.getId(), labelId1);
        statement.dataWriteOperations().nodeAddLabel(node.getId(), labelId2);
        statement.dataWriteOperations().nodeRemoveLabel(node.getId(), labelId2);
        Assert.assertFalse((boolean)statement.readOperations().nodeHasLabel(node.getId(), labelId2));
        Assert.assertEquals((Object)PrimitiveIntCollections.asSet((int[])new int[]{labelId1}), (Object)PrimitiveIntCollections.asSet((PrimitiveIntIterator)statement.readOperations().nodeGetLabels(node.getId())));
        statement.close();
        tx.success();
        tx.close();
    }

    @Test
    public void transactionStateShouldReflectRemovingLabelImmediately() throws Exception {
        Transaction tx = this.db.beginTx();
        Statement statement = this.statementContextSupplier.get();
        Node node = this.db.createNode();
        int labelId1 = statement.tokenWriteOperations().labelGetOrCreateForName("labello1");
        int labelId2 = statement.tokenWriteOperations().labelGetOrCreateForName("labello2");
        statement.dataWriteOperations().nodeAddLabel(node.getId(), labelId1);
        statement.dataWriteOperations().nodeAddLabel(node.getId(), labelId2);
        statement.close();
        tx.success();
        tx.close();
        tx = this.db.beginTx();
        statement = this.statementContextSupplier.get();
        statement.dataWriteOperations().nodeRemoveLabel(node.getId(), labelId2);
        PrimitiveIntSet labels = PrimitiveIntCollections.asSet((PrimitiveIntIterator)statement.readOperations().nodeGetLabels(node.getId()));
        Assert.assertFalse((boolean)statement.readOperations().nodeHasLabel(node.getId(), labelId2));
        Assert.assertEquals((Object)PrimitiveIntCollections.asSet((int[])new int[]{labelId1}), (Object)labels);
        statement.close();
        tx.success();
        tx.close();
    }

    @Test
    public void labelShouldBeRemovedAfterCommit() throws Exception {
        Transaction tx = this.db.beginTx();
        Statement statement = this.statementContextSupplier.get();
        Node node = this.db.createNode();
        int labelId1 = statement.tokenWriteOperations().labelGetOrCreateForName("labello1");
        statement.dataWriteOperations().nodeAddLabel(node.getId(), labelId1);
        statement.close();
        tx.success();
        tx.close();
        tx = this.db.beginTx();
        statement = this.statementContextSupplier.get();
        statement.dataWriteOperations().nodeRemoveLabel(node.getId(), labelId1);
        statement.close();
        tx.success();
        tx.close();
        tx = this.db.beginTx();
        statement = this.statementContextSupplier.get();
        Set labels = PrimitiveIntCollections.toSet((PrimitiveIntIterator)statement.readOperations().nodeGetLabels(node.getId()));
        statement.close();
        tx.success();
        tx.close();
        Assert.assertThat((Object)labels, (Matcher)Matchers.equalTo(Collections.emptySet()));
    }

    @Test
    public void addingNewLabelToNodeShouldRespondTrue() throws Exception {
        Transaction tx = this.db.beginTx();
        Node node = this.db.createNode();
        Statement statement = this.statementContextSupplier.get();
        int labelId = statement.tokenWriteOperations().labelGetOrCreateForName("mylabel");
        statement.dataWriteOperations().nodeAddLabel(node.getId(), labelId);
        statement.close();
        tx.success();
        tx.close();
        tx = this.db.beginTx();
        statement = this.statementContextSupplier.get();
        boolean added = statement.dataWriteOperations().nodeAddLabel(node.getId(), labelId);
        tx.close();
        Assert.assertFalse((String)"Shouldn't have been added now", (boolean)added);
    }

    @Test
    public void addingExistingLabelToNodeShouldRespondFalse() throws Exception {
        Transaction tx = this.db.beginTx();
        Node node = this.db.createNode();
        Statement statement = this.statementContextSupplier.get();
        int labelId = statement.tokenWriteOperations().labelGetOrCreateForName("mylabel");
        statement.close();
        tx.success();
        tx.close();
        tx = this.db.beginTx();
        statement = this.statementContextSupplier.get();
        boolean added = statement.dataWriteOperations().nodeAddLabel(node.getId(), labelId);
        tx.close();
        Assert.assertTrue((String)"Should have been added now", (boolean)added);
    }

    @Test
    public void removingExistingLabelFromNodeShouldRespondTrue() throws Exception {
        Transaction tx = this.db.beginTx();
        Node node = this.db.createNode();
        Statement statement = this.statementContextSupplier.get();
        int labelId = statement.tokenWriteOperations().labelGetOrCreateForName("mylabel");
        statement.dataWriteOperations().nodeAddLabel(node.getId(), labelId);
        statement.close();
        tx.success();
        tx.close();
        tx = this.db.beginTx();
        statement = this.statementContextSupplier.get();
        boolean removed = statement.dataWriteOperations().nodeRemoveLabel(node.getId(), labelId);
        Assert.assertTrue((String)"Should have been removed now", (boolean)removed);
        tx.close();
    }

    @Test
    public void removingNonExistentLabelFromNodeShouldRespondFalse() throws Exception {
        Transaction tx = this.db.beginTx();
        Node node = this.db.createNode();
        Statement statement = this.statementContextSupplier.get();
        int labelId = statement.tokenWriteOperations().labelGetOrCreateForName("mylabel");
        statement.close();
        tx.success();
        tx.close();
        tx = this.db.beginTx();
        statement = this.statementContextSupplier.get();
        boolean removed = statement.dataWriteOperations().nodeRemoveLabel(node.getId(), labelId);
        Assert.assertFalse((String)"Shouldn't have been removed now", (boolean)removed);
        tx.close();
    }

    @Test
    public void deletingNodeWithLabelsShouldHaveThoseLabelRemovalsReflectedInTransaction() throws Exception {
        Transaction tx = this.db.beginTx();
        Label label = Label.label((String)"labello");
        Node node = this.db.createNode(new Label[]{label});
        tx.success();
        tx.close();
        tx = this.db.beginTx();
        Statement statement = this.statementContextSupplier.get();
        statement.dataWriteOperations().nodeDelete(node.getId());
        int labelId = statement.readOperations().labelGetForName(label.name());
        try {
            statement.readOperations().nodeGetLabels(node.getId());
            Assert.fail();
        }
        catch (EntityNotFoundException entityNotFoundException) {
            // empty catch block
        }
        try {
            statement.readOperations().nodeHasLabel(node.getId(), labelId);
            Assert.fail();
        }
        catch (EntityNotFoundException entityNotFoundException) {
            // empty catch block
        }
        Set nodes = PrimitiveLongCollections.toSet((PrimitiveLongIterator)statement.readOperations().nodesGetForLabel(labelId));
        statement.close();
        tx.success();
        tx.close();
        Assert.assertEquals((Object)Iterators.emptySetOf(Long.class), (Object)nodes);
    }

    @Test
    public void deletingNodeWithLabelsShouldHaveRemovalReflectedInLabelScans() throws Exception {
        Transaction tx = this.db.beginTx();
        Label label = Label.label((String)"labello");
        Node node = this.db.createNode(new Label[]{label});
        tx.success();
        tx.close();
        tx = this.db.beginTx();
        node.delete();
        tx.success();
        tx.close();
        tx = this.db.beginTx();
        Statement statement = this.statementContextSupplier.get();
        int labelId = statement.readOperations().labelGetForName(label.name());
        PrimitiveLongIterator nodes = statement.readOperations().nodesGetForLabel(labelId);
        Set nodeSet = PrimitiveLongCollections.toSet((PrimitiveLongIterator)nodes);
        tx.success();
        tx.close();
        Assert.assertThat((Object)nodeSet, (Matcher)Matchers.equalTo(Collections.emptySet()));
    }

    @Test
    public void schemaStateShouldBeEvictedOnIndexComingOnline() throws Exception {
        this.schemaWriteOperationsInNewTransaction();
        this.getOrCreateSchemaState("my key", "my state");
        this.commit();
        this.createIndex(this.statementInNewTransaction(SecurityContext.AUTH_DISABLED));
        this.commit();
        try (Transaction tx = this.db.beginTx();){
            this.db.schema().awaitIndexOnline((IndexDefinition)this.db.schema().getIndexes().iterator().next(), 20L, TimeUnit.SECONDS);
            tx.success();
        }
        Assert.assertFalse((boolean)this.schemaStateContains("my key"));
    }

    @Test
    public void schemaStateShouldBeEvictedOnIndexDropped() throws Exception {
        IndexDescriptor idx = this.createIndex(this.statementInNewTransaction(SecurityContext.AUTH_DISABLED));
        this.commit();
        try (Transaction tx = this.db.beginTx();){
            this.db.schema().awaitIndexOnline((IndexDefinition)this.db.schema().getIndexes().iterator().next(), 20L, TimeUnit.SECONDS);
            this.getOrCreateSchemaState("my key", "some state");
            tx.success();
        }
        this.schemaWriteOperationsInNewTransaction().indexDrop(idx);
        this.commit();
        Assert.assertFalse((boolean)this.schemaStateContains("my key"));
    }

    @Test
    public void shouldKillTransactionsOnShutdown() throws Throwable {
        Assume.assumeThat((Object)this.kernel, (Matcher)Matchers.instanceOf(Kernel.class));
        try (KernelTransaction tx = this.kernel.newTransaction(KernelTransaction.Type.implicit, (SecurityContext)AnonymousContext.read());){
            ((Kernel)this.kernel).stop();
            tx.acquireStatement().readOperations().nodeExists(0L);
            Assert.fail((String)"Should have been terminated.");
        }
        catch (TransactionTerminatedException transactionTerminatedException) {
            // empty catch block
        }
    }

    @Test
    public void txReturnsCorrectIdWhenCommitted() throws Exception {
        KernelIT.executeDummyTxs((GraphDatabaseService)this.db, 42);
        KernelTransaction tx = this.kernel.newTransaction(KernelTransaction.Type.implicit, SecurityContext.AUTH_DISABLED);
        try (Statement statement = tx.acquireStatement();){
            statement.dataWriteOperations().nodeCreate();
        }
        tx.success();
        long previousCommittedTxId = KernelIT.lastCommittedTxId(this.db);
        Assert.assertEquals((long)(previousCommittedTxId + 1L), (long)tx.closeTransaction());
        Assert.assertFalse((boolean)tx.isOpen());
    }

    @Test
    public void txReturnsCorrectIdWhenRolledBack() throws Exception {
        KernelIT.executeDummyTxs((GraphDatabaseService)this.db, 42);
        KernelTransaction tx = this.kernel.newTransaction(KernelTransaction.Type.implicit, SecurityContext.AUTH_DISABLED);
        try (Statement statement = tx.acquireStatement();){
            statement.dataWriteOperations().nodeCreate();
        }
        tx.failure();
        Assert.assertEquals((long)-1L, (long)tx.closeTransaction());
        Assert.assertFalse((boolean)tx.isOpen());
    }

    @Test
    public void txReturnsCorrectIdWhenMarkedForTermination() throws Exception {
        KernelIT.executeDummyTxs((GraphDatabaseService)this.db, 42);
        KernelTransaction tx = this.kernel.newTransaction(KernelTransaction.Type.implicit, SecurityContext.AUTH_DISABLED);
        try (Statement statement = tx.acquireStatement();){
            statement.dataWriteOperations().nodeCreate();
        }
        tx.markForTermination((Status)Status.Transaction.Terminated);
        Assert.assertEquals((long)-1L, (long)tx.closeTransaction());
        Assert.assertFalse((boolean)tx.isOpen());
    }

    @Test
    public void txReturnsCorrectIdWhenFailedlAndMarkedForTermination() throws Exception {
        KernelIT.executeDummyTxs((GraphDatabaseService)this.db, 42);
        KernelTransaction tx = this.kernel.newTransaction(KernelTransaction.Type.implicit, SecurityContext.AUTH_DISABLED);
        try (Statement statement = tx.acquireStatement();){
            statement.dataWriteOperations().nodeCreate();
        }
        tx.failure();
        tx.markForTermination((Status)Status.Transaction.Terminated);
        Assert.assertEquals((long)-1L, (long)tx.closeTransaction());
        Assert.assertFalse((boolean)tx.isOpen());
    }

    @Test
    public void txReturnsCorrectIdWhenReadOnly() throws Exception {
        KernelIT.executeDummyTxs((GraphDatabaseService)this.db, 42);
        KernelTransaction tx = this.kernel.newTransaction(KernelTransaction.Type.implicit, SecurityContext.AUTH_DISABLED);
        try (Statement statement = tx.acquireStatement();){
            Cursor cursor = statement.readOperations().nodeCursorById(1L);
            Throwable throwable = null;
            if (cursor != null) {
                if (throwable != null) {
                    try {
                        cursor.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    cursor.close();
                }
            }
        }
        tx.success();
        Assert.assertEquals((long)0L, (long)tx.closeTransaction());
        Assert.assertFalse((boolean)tx.isOpen());
    }

    private static void executeDummyTxs(GraphDatabaseService db, int count) {
        for (int i = 0; i < count; ++i) {
            try (Transaction tx = db.beginTx();){
                db.createNode();
                tx.success();
                continue;
            }
        }
    }

    private static long lastCommittedTxId(GraphDatabaseAPI db) {
        TransactionIdStore txIdStore = (TransactionIdStore)db.getDependencyResolver().resolveDependency(TransactionIdStore.class);
        return txIdStore.getLastCommittedTransactionId();
    }

    private IndexDescriptor createIndex(Statement statement) throws SchemaKernelException, InvalidTransactionTypeKernelException {
        return statement.schemaWriteOperations().indexCreate(SchemaDescriptorFactory.forLabel((int)statement.tokenWriteOperations().labelGetOrCreateForName("hello"), (int[])new int[]{statement.tokenWriteOperations().propertyKeyGetOrCreateForName("hepp")}));
    }

    private String getOrCreateSchemaState(String key, String maybeSetThisState) {
        try (Transaction tx = this.db.beginTx();){
            Statement statement = this.statementContextSupplier.get();
            String state = (String)statement.readOperations().schemaStateGetOrCreate((Object)key, s -> maybeSetThisState);
            tx.success();
            String string = state;
            return string;
        }
    }

    private boolean schemaStateContains(String key) {
        try (Transaction tx = this.db.beginTx();){
            Statement statement = this.statementContextSupplier.get();
            AtomicBoolean result = new AtomicBoolean(true);
            statement.readOperations().schemaStateGetOrCreate((Object)key, s -> {
                result.set(false);
                return null;
            });
            tx.success();
            boolean bl = result.get();
            return bl;
        }
    }
}

