/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.collection.primitive.PrimitiveLongResourceIterator;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.AssertOpen;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.legacyindex.AutoIndexing;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.api.schema.IndexQuery;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptorFactory;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.ConstraintEnforcingEntityOperations;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.StateHandlingStatementOperations;
import org.neo4j.kernel.impl.api.StatementOperationsTestHelper;
import org.neo4j.kernel.impl.api.legacyindex.InternalAutoIndexing;
import org.neo4j.kernel.impl.api.operations.EntityOperations;
import org.neo4j.kernel.impl.api.operations.EntityReadOperations;
import org.neo4j.kernel.impl.api.operations.EntityWriteOperations;
import org.neo4j.kernel.impl.api.operations.SchemaReadOperations;
import org.neo4j.kernel.impl.api.operations.SchemaWriteOperations;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.api.state.StubCursors;
import org.neo4j.kernel.impl.api.state.TxState;
import org.neo4j.kernel.impl.api.store.StoreStatement;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.constraints.StandardConstraintSemantics;
import org.neo4j.kernel.impl.index.LegacyIndexStore;
import org.neo4j.storageengine.api.NodeItem;
import org.neo4j.storageengine.api.StorageStatement;
import org.neo4j.storageengine.api.StoreReadLayer;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.test.mockito.answer.Neo4jMockitoAnswers;

public class IndexQueryTransactionStateTest {
    int labelId = 2;
    int propertyKeyId = 3;
    String value = "My Value";
    IndexDescriptor indexDescriptor = IndexDescriptorFactory.forLabel((int)this.labelId, (int[])new int[]{this.propertyKeyId});
    List<IndexDescriptor> indexes = Collections.singletonList(this.indexDescriptor);
    IndexQuery.ExactPredicate withValue = IndexQuery.exact((int)this.propertyKeyId, (Object)this.value);
    private StoreReadLayer store;
    private StoreStatement statement;
    private EntityOperations txContext;
    private KernelStatement state;
    private IndexReader indexReader;

    @Before
    public void before() throws Exception {
        TxState txState = new TxState();
        this.state = StatementOperationsTestHelper.mockedState((TransactionState)txState);
        this.store = (StoreReadLayer)Mockito.mock(StoreReadLayer.class);
        Mockito.when((Object)this.store.indexGetState(this.indexDescriptor)).thenReturn((Object)InternalIndexState.ONLINE);
        Mockito.when((Object)this.store.indexesGetForLabel(this.labelId)).then(Neo4jMockitoAnswers.answerAsIteratorFrom(this.indexes));
        Mockito.when((Object)this.store.indexesGetAll()).then(Neo4jMockitoAnswers.answerAsIteratorFrom(this.indexes));
        Mockito.when((Object)this.store.indexesGetRelatedToProperty(this.propertyKeyId)).then(Neo4jMockitoAnswers.answerAsIteratorFrom(this.indexes));
        Mockito.when((Object)this.store.constraintsGetForLabel(this.labelId)).thenReturn(Collections.emptyIterator());
        Mockito.when((Object)this.store.indexGetForSchema(this.indexDescriptor.schema())).thenReturn((Object)this.indexDescriptor);
        this.statement = (StoreStatement)Mockito.mock(StoreStatement.class);
        Mockito.when((Object)this.state.getStoreStatement()).thenReturn((Object)this.statement);
        this.indexReader = (IndexReader)Mockito.mock(IndexReader.class);
        Mockito.when((Object)this.statement.getIndexReader(this.indexDescriptor)).thenReturn((Object)this.indexReader);
        Mockito.when((Object)this.statement.getFreshIndexReader(this.indexDescriptor)).thenReturn((Object)this.indexReader);
        StateHandlingStatementOperations stateHandlingOperations = new StateHandlingStatementOperations(this.store, (AutoIndexing)new InternalAutoIndexing(Config.empty(), null), (ConstraintIndexCreator)Mockito.mock(ConstraintIndexCreator.class), (LegacyIndexStore)Mockito.mock(LegacyIndexStore.class));
        this.txContext = new ConstraintEnforcingEntityOperations((ConstraintSemantics)new StandardConstraintSemantics(), (EntityWriteOperations)stateHandlingOperations, (EntityReadOperations)stateHandlingOperations, (SchemaWriteOperations)stateHandlingOperations, (SchemaReadOperations)stateHandlingOperations);
    }

    @Test
    public void shouldExcludeRemovedNodesFromIndexQuery() throws Exception {
        long nodeId = 2L;
        Mockito.when((Object)this.indexReader.query(new IndexQuery[]{this.withValue})).then(Neo4jMockitoAnswers.answerAsPrimitiveLongIteratorFrom(Arrays.asList(1L, nodeId, 3L)));
        Mockito.when((Object)this.statement.acquireSingleNodeCursor(nodeId)).thenReturn(StubCursors.asNodeCursor(nodeId));
        this.txContext.nodeDelete(this.state, nodeId);
        PrimitiveLongIterator result = this.txContext.indexQuery(this.state, this.indexDescriptor, new IndexQuery[]{this.withValue});
        Assert.assertThat((Object)PrimitiveLongCollections.toSet((PrimitiveLongIterator)result), (Matcher)org.hamcrest.Matchers.equalTo((Object)Iterators.asSet((Object[])new Long[]{1L, 3L})));
    }

    @Test
    public void shouldExcludeRemovedNodeFromUniqueIndexQuery() throws Exception {
        long nodeId = 1L;
        Mockito.when((Object)this.indexReader.query(new IndexQuery[]{this.withValue})).thenReturn((Object)IndexQueryTransactionStateTest.asPrimitiveResourceIterator(nodeId));
        Mockito.when((Object)this.statement.acquireSingleNodeCursor(nodeId)).thenReturn(StubCursors.asNodeCursor(nodeId));
        this.txContext.nodeDelete(this.state, nodeId);
        long result = this.txContext.nodeGetFromUniqueIndexSeek(this.state, this.indexDescriptor, new IndexQuery.ExactPredicate[]{this.withValue});
        this.assertNoSuchNode(result);
    }

    @Test
    public void shouldExcludeChangedNodesWithMissingLabelFromIndexQuery() throws Exception {
        Mockito.when((Object)this.indexReader.query(new IndexQuery[]{this.withValue})).then(Neo4jMockitoAnswers.answerAsPrimitiveLongIteratorFrom(Arrays.asList(2L, 3L)));
        this.state.txState().nodeDoAddProperty(1L, Property.intProperty((int)this.propertyKeyId, (int)10));
        PrimitiveLongIterator result = this.txContext.indexQuery(this.state, this.indexDescriptor, new IndexQuery[]{this.withValue});
        Assert.assertThat((Object)PrimitiveLongCollections.toSet((PrimitiveLongIterator)result), (Matcher)org.hamcrest.Matchers.equalTo((Object)Iterators.asSet((Object[])new Long[]{2L, 3L})));
    }

    @Test
    public void shouldExcludeChangedNodeWithMissingLabelFromUniqueIndexQuery() throws Exception {
        Mockito.when((Object)this.indexReader.query(new IndexQuery[]{this.withValue})).thenReturn((Object)IndexQueryTransactionStateTest.asPrimitiveResourceIterator(new long[0]));
        this.state.txState().nodeDoAddProperty(1L, Property.intProperty((int)this.propertyKeyId, (int)10));
        long result = this.txContext.nodeGetFromUniqueIndexSeek(this.state, this.indexDescriptor, new IndexQuery.ExactPredicate[]{this.withValue});
        this.assertNoSuchNode(result);
    }

    @Test
    public void shouldIncludeCreatedNodesWithCorrectLabelAndProperty() throws Exception {
        Mockito.when((Object)this.indexReader.query(new IndexQuery[]{this.withValue})).then(Neo4jMockitoAnswers.answerAsPrimitiveLongIteratorFrom(Arrays.asList(2L, 3L)));
        long nodeId = 1L;
        this.state.txState().nodeDoAddProperty(nodeId, Property.stringProperty((int)this.propertyKeyId, (String)this.value));
        Mockito.when((Object)this.statement.acquireSingleNodeCursor(nodeId)).thenReturn(StubCursors.asNodeCursor(nodeId, 40L));
        this.mockStoreProperty();
        Mockito.when((Object)this.store.indexesGetForLabel(this.labelId)).thenReturn(this.indexes.iterator());
        this.txContext.nodeAddLabel(this.state, nodeId, this.labelId);
        PrimitiveLongIterator result = this.txContext.indexQuery(this.state, this.indexDescriptor, new IndexQuery[]{this.withValue});
        Assert.assertThat((Object)PrimitiveLongCollections.toSet((PrimitiveLongIterator)result), (Matcher)org.hamcrest.Matchers.equalTo((Object)Iterators.asSet((Object[])new Long[]{nodeId, 2L, 3L})));
    }

    @Test
    public void shouldIncludeUniqueCreatedNodeWithCorrectLabelAndProperty() throws Exception {
        Mockito.when((Object)this.indexReader.query(new IndexQuery[]{this.withValue})).thenReturn((Object)IndexQueryTransactionStateTest.asPrimitiveResourceIterator(new long[0]));
        long nodeId = 1L;
        this.state.txState().nodeDoAddProperty(nodeId, Property.stringProperty((int)this.propertyKeyId, (String)this.value));
        Mockito.when((Object)this.statement.acquireSingleNodeCursor(nodeId)).thenReturn(StubCursors.asNodeCursor(nodeId, 40L));
        this.mockStoreProperty();
        Mockito.when((Object)this.store.indexesGetForLabel(this.labelId)).thenReturn(this.indexes.iterator());
        this.txContext.nodeAddLabel(this.state, nodeId, this.labelId);
        long result = this.txContext.nodeGetFromUniqueIndexSeek(this.state, this.indexDescriptor, new IndexQuery.ExactPredicate[]{this.withValue});
        Assert.assertThat((Object)result, (Matcher)org.hamcrest.Matchers.equalTo((Object)nodeId));
    }

    @Test
    public void shouldIncludeExistingNodesWithCorrectPropertyAfterAddingLabel() throws Exception {
        Mockito.when((Object)this.indexReader.query(new IndexQuery[]{this.withValue})).then(Neo4jMockitoAnswers.answerAsPrimitiveLongIteratorFrom(Arrays.asList(2L, 3L)));
        long nodeId = 1L;
        Mockito.when((Object)this.statement.acquireSingleNodeCursor(nodeId)).thenReturn(StubCursors.asNodeCursor(nodeId, 40L));
        this.mockStoreProperty();
        Mockito.when((Object)this.store.indexesGetForLabel(this.labelId)).thenReturn(this.indexes.iterator());
        this.txContext.nodeAddLabel(this.state, nodeId, this.labelId);
        PrimitiveLongIterator result = this.txContext.indexQuery(this.state, this.indexDescriptor, new IndexQuery[]{this.withValue});
        Assert.assertThat((Object)PrimitiveLongCollections.toSet((PrimitiveLongIterator)result), (Matcher)org.hamcrest.Matchers.equalTo((Object)Iterators.asSet((Object[])new Long[]{nodeId, 2L, 3L})));
    }

    @Test
    public void shouldIncludeExistingUniqueNodeWithCorrectPropertyAfterAddingLabel() throws Exception {
        Mockito.when((Object)this.indexReader.query(new IndexQuery[]{this.withValue})).thenReturn((Object)IndexQueryTransactionStateTest.asPrimitiveResourceIterator(new long[0]));
        long nodeId = 2L;
        Mockito.when((Object)this.statement.acquireSingleNodeCursor(nodeId)).thenReturn(StubCursors.asNodeCursor(nodeId, 40L));
        this.mockStoreProperty();
        Mockito.when((Object)this.store.indexesGetForLabel(this.labelId)).thenReturn(this.indexes.iterator());
        this.txContext.nodeAddLabel(this.state, nodeId, this.labelId);
        long result = this.txContext.nodeGetFromUniqueIndexSeek(this.state, this.indexDescriptor, new IndexQuery.ExactPredicate[]{this.withValue});
        Assert.assertThat((Object)result, (Matcher)org.hamcrest.Matchers.equalTo((Object)nodeId));
    }

    @Test
    public void shouldExcludeExistingNodesWithCorrectPropertyAfterRemovingLabel() throws Exception {
        long nodeId = 1L;
        Mockito.when((Object)this.indexReader.query(new IndexQuery[]{this.withValue})).then(Neo4jMockitoAnswers.answerAsPrimitiveLongIteratorFrom(Arrays.asList(nodeId, 2L, 3L)));
        Mockito.when((Object)this.statement.acquireSingleNodeCursor(nodeId)).thenReturn(StubCursors.asNodeCursor(nodeId, 40L, StubCursors.labels(this.labelId)));
        this.mockStoreProperty();
        this.txContext.nodeRemoveLabel(this.state, nodeId, this.labelId);
        PrimitiveLongIterator result = this.txContext.indexQuery(this.state, this.indexDescriptor, new IndexQuery[]{this.withValue});
        Assert.assertThat((Object)PrimitiveLongCollections.toSet((PrimitiveLongIterator)result), (Matcher)org.hamcrest.Matchers.equalTo((Object)Iterators.asSet((Object[])new Long[]{2L, 3L})));
    }

    @Test
    public void shouldExcludeExistingUniqueNodeWithCorrectPropertyAfterRemovingLabel() throws Exception {
        long nodeId = 1L;
        Mockito.when((Object)this.indexReader.query(new IndexQuery[]{this.withValue})).thenReturn((Object)IndexQueryTransactionStateTest.asPrimitiveResourceIterator(nodeId));
        Mockito.when((Object)this.statement.acquireSingleNodeCursor(nodeId)).thenReturn(StubCursors.asNodeCursor(nodeId, 40L, StubCursors.labels(this.labelId)));
        this.mockStoreProperty();
        this.txContext.nodeRemoveLabel(this.state, nodeId, this.labelId);
        long result = this.txContext.nodeGetFromUniqueIndexSeek(this.state, this.indexDescriptor, new IndexQuery.ExactPredicate[]{this.withValue});
        this.assertNoSuchNode(result);
    }

    @Test
    public void shouldExcludeNodesWithRemovedProperty() throws Exception {
        Mockito.when((Object)this.indexReader.query(new IndexQuery[]{this.withValue})).then(Neo4jMockitoAnswers.answerAsPrimitiveLongIteratorFrom(Arrays.asList(2L, 3L)));
        long nodeId = 1L;
        this.state.txState().nodeDoAddProperty(nodeId, Property.intProperty((int)this.propertyKeyId, (int)10));
        Mockito.when((Object)this.statement.acquireSingleNodeCursor(nodeId)).thenReturn(StubCursors.asNodeCursor(nodeId, StubCursors.labels(this.labelId)));
        this.txContext.nodeAddLabel(this.state, nodeId, this.labelId);
        PrimitiveLongIterator result = this.txContext.indexQuery(this.state, this.indexDescriptor, new IndexQuery[]{this.withValue});
        Assert.assertThat((Object)PrimitiveLongCollections.toSet((PrimitiveLongIterator)result), (Matcher)org.hamcrest.Matchers.equalTo((Object)Iterators.asSet((Object[])new Long[]{2L, 3L})));
    }

    @Test
    public void shouldExcludeUniqueNodeWithRemovedProperty() throws Exception {
        long nodeId = 1L;
        Mockito.when((Object)this.indexReader.query(new IndexQuery[]{this.withValue})).thenReturn((Object)IndexQueryTransactionStateTest.asPrimitiveResourceIterator(nodeId));
        Mockito.when((Object)this.statement.acquireSingleNodeCursor(nodeId)).thenReturn(StubCursors.asNodeCursor(nodeId, 40L, StubCursors.labels(this.labelId)));
        this.mockStoreProperty();
        this.txContext.nodeRemoveProperty(this.state, nodeId, this.propertyKeyId);
        long result = this.txContext.nodeGetFromUniqueIndexSeek(this.state, this.indexDescriptor, new IndexQuery.ExactPredicate[]{this.withValue});
        this.assertNoSuchNode(result);
    }

    private void mockStoreProperty() {
        Mockito.when((Object)this.store.nodeGetProperties((StorageStatement)Matchers.eq((Object)this.statement), (NodeItem)Matchers.any(NodeItem.class), (AssertOpen)Matchers.any(AssertOpen.class))).thenReturn(StubCursors.asPropertyCursor(Property.stringProperty((int)this.propertyKeyId, (String)this.value)));
        Mockito.when((Object)this.store.nodeGetProperty((StorageStatement)Matchers.eq((Object)this.statement), (NodeItem)Matchers.any(NodeItem.class), Matchers.eq((int)this.propertyKeyId), (AssertOpen)Matchers.any(AssertOpen.class))).thenReturn(StubCursors.asPropertyCursor(Property.stringProperty((int)this.propertyKeyId, (String)this.value)));
    }

    private void assertNoSuchNode(long node) {
        Assert.assertThat((Object)node, (Matcher)org.hamcrest.Matchers.equalTo((Object)-1L));
    }

    private static PrimitiveLongResourceIterator asPrimitiveResourceIterator(long ... values) {
        return PrimitiveLongCollections.resourceIterator((PrimitiveLongIterator)PrimitiveLongCollections.iterator((long[])values), () -> {});
    }
}

