/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntCollections;
import org.neo4j.collection.primitive.PrimitiveIntSet;
import org.neo4j.cursor.Cursor;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.OrderedPropertyValues;
import org.neo4j.kernel.api.schema.SchemaDescriptorPredicates;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptorFactory;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.operations.EntityReadOperations;
import org.neo4j.kernel.impl.api.state.IndexTxStateUpdater;
import org.neo4j.kernel.impl.api.state.StubCursors;
import org.neo4j.storageengine.api.NodeItem;
import org.neo4j.storageengine.api.StoreReadLayer;

public class IndexTxStateUpdaterTest {
    private static final int labelId1 = 10;
    private static final int labelId2 = 11;
    private static final int unIndexedLabelId = 12;
    private static final int propId1 = 20;
    private static final int propId2 = 21;
    private static final int propId3 = 22;
    private static final int newPropId = 23;
    private static final int unIndexedPropId = 24;
    private KernelStatement state;
    private TransactionState txState;
    private IndexTxStateUpdater indexTxUpdater;
    private NodeItem node;
    private IndexDescriptor indexOn1_1 = IndexDescriptorFactory.forLabel((int)10, (int[])new int[]{20});
    private IndexDescriptor indexOn2_new = IndexDescriptorFactory.forLabel((int)11, (int[])new int[]{23});
    private IndexDescriptor uniqueOn1_2 = IndexDescriptorFactory.uniqueForLabel((int)10, (int[])new int[]{21});
    private IndexDescriptor indexOn1_1_new = IndexDescriptorFactory.forLabel((int)10, (int[])new int[]{20, 23});
    private IndexDescriptor uniqueOn2_2_3 = IndexDescriptorFactory.uniqueForLabel((int)11, (int[])new int[]{21, 22});
    private List<IndexDescriptor> indexes = Arrays.asList(this.indexOn1_1, this.indexOn2_new, this.uniqueOn1_2, this.indexOn1_1_new, this.uniqueOn2_2_3);

    @Before
    public void setup() {
        this.state = (KernelStatement)Mockito.mock(KernelStatement.class);
        this.txState = (TransactionState)Mockito.mock(TransactionState.class);
        Mockito.when((Object)this.state.txState()).thenReturn((Object)this.txState);
        StoreReadLayer storeReadLayer = (StoreReadLayer)Mockito.mock(StoreReadLayer.class);
        Mockito.when((Object)storeReadLayer.indexesGetAll()).thenAnswer(x -> this.indexes.iterator());
        Mockito.when((Object)storeReadLayer.indexesGetForLabel(Matchers.anyInt())).thenAnswer(x -> Iterators.filter((Predicate)SchemaDescriptorPredicates.hasLabel((int)((Integer)x.getArguments()[0])), this.indexes.iterator()));
        Mockito.when((Object)storeReadLayer.indexesGetRelatedToProperty(Matchers.anyInt())).thenAnswer(x -> Iterators.filter((Predicate)SchemaDescriptorPredicates.hasProperty((int)((Integer)x.getArguments()[0])), this.indexes.iterator()));
        PrimitiveIntSet labels = Primitive.intSet();
        labels.add(10);
        labels.add(11);
        Cursor<NodeItem> nodeItemCursor = StubCursors.asNodeCursor(0L, labels);
        nodeItemCursor.next();
        this.node = (NodeItem)nodeItemCursor.get();
        PrimitiveIntSet defaultPropertyIds = PrimitiveIntCollections.asSet((int[])new int[]{20, 21, 22});
        EntityReadOperations readOps = (EntityReadOperations)Mockito.mock(EntityReadOperations.class);
        Mockito.when((Object)readOps.nodeGetPropertyKeys(this.state, this.node)).thenReturn((Object)defaultPropertyIds);
        Mockito.when((Object)readOps.nodeGetProperties(this.state, this.node)).thenAnswer(p -> StubCursors.asPropertyCursor(Property.property((int)20, (Object)"hi1"), Property.property((int)21, (Object)"hi2"), Property.property((int)22, (Object)"hi3")));
        Mockito.when((Object)readOps.nodeGetProperty(this.state, this.node, 20)).thenReturn((Object)"hi1");
        Mockito.when((Object)readOps.nodeGetProperty(this.state, this.node, 21)).thenReturn((Object)"hi2");
        Mockito.when((Object)readOps.nodeGetProperty(this.state, this.node, 22)).thenReturn((Object)"hi3");
        this.indexTxUpdater = new IndexTxStateUpdater(storeReadLayer, readOps);
    }

    @Test
    public void shouldNotUpdateIndexesOnChangedIrrelevantLabel() throws EntityNotFoundException {
        this.indexTxUpdater.onLabelChange(this.state, 12, this.node, IndexTxStateUpdater.LabelChangeType.ADDED_LABEL);
        this.indexTxUpdater.onLabelChange(this.state, 12, this.node, IndexTxStateUpdater.LabelChangeType.REMOVED_LABEL);
        ((TransactionState)Mockito.verify((Object)this.txState, (VerificationMode)Mockito.times((int)0))).indexDoUpdateEntry((LabelSchemaDescriptor)Matchers.any(), (long)Matchers.anyInt(), (OrderedPropertyValues)Matchers.any(), (OrderedPropertyValues)Matchers.any());
    }

    @Test
    public void shouldUpdateIndexesOnAddedLabel() throws EntityNotFoundException {
        this.indexTxUpdater.onLabelChange(this.state, 10, this.node, IndexTxStateUpdater.LabelChangeType.ADDED_LABEL);
        this.verifyIndexUpdate(this.indexOn1_1.schema(), this.node.id(), null, this.values("hi1"));
        this.verifyIndexUpdate(this.uniqueOn1_2.schema(), this.node.id(), null, this.values("hi2"));
        ((TransactionState)Mockito.verify((Object)this.txState, (VerificationMode)Mockito.times((int)2))).indexDoUpdateEntry((LabelSchemaDescriptor)Matchers.any(), (long)Matchers.anyInt(), (OrderedPropertyValues)Matchers.any(), (OrderedPropertyValues)Matchers.any());
    }

    @Test
    public void shouldUpdateIndexesOnRemovedLabel() throws EntityNotFoundException {
        this.indexTxUpdater.onLabelChange(this.state, 11, this.node, IndexTxStateUpdater.LabelChangeType.REMOVED_LABEL);
        this.verifyIndexUpdate(this.uniqueOn2_2_3.schema(), this.node.id(), this.values("hi2", "hi3"), null);
        ((TransactionState)Mockito.verify((Object)this.txState, (VerificationMode)Mockito.times((int)1))).indexDoUpdateEntry((LabelSchemaDescriptor)Matchers.any(), (long)Matchers.anyInt(), (OrderedPropertyValues)Matchers.any(), (OrderedPropertyValues)Matchers.any());
    }

    @Test
    public void shouldNotUpdateIndexesOnChangedIrrelevantProperty() throws EntityNotFoundException {
        this.indexTxUpdater.onPropertyAdd(this.state, this.node, Property.property((int)24, (Object)"whAt"));
        this.indexTxUpdater.onPropertyRemove(this.state, this.node, Property.property((int)24, (Object)"whAt"));
        this.indexTxUpdater.onPropertyChange(this.state, this.node, Property.property((int)24, (Object)"whAt"), Property.property((int)24, (Object)"whAt2"));
        ((TransactionState)Mockito.verify((Object)this.txState, (VerificationMode)Mockito.times((int)0))).indexDoUpdateEntry((LabelSchemaDescriptor)Matchers.any(), (long)Matchers.anyInt(), (OrderedPropertyValues)Matchers.any(), (OrderedPropertyValues)Matchers.any());
    }

    @Test
    public void shouldUpdateIndexesOnAddedProperty() throws EntityNotFoundException {
        this.indexTxUpdater.onPropertyAdd(this.state, this.node, Property.property((int)23, (Object)"newHi"));
        this.verifyIndexUpdate(this.indexOn2_new.schema(), this.node.id(), null, this.values("newHi"));
        this.verifyIndexUpdate(this.indexOn1_1_new.schema(), this.node.id(), null, this.values("hi1", "newHi"));
        ((TransactionState)Mockito.verify((Object)this.txState, (VerificationMode)Mockito.times((int)2))).indexDoUpdateEntry((LabelSchemaDescriptor)Matchers.any(), (long)Matchers.anyInt(), (OrderedPropertyValues)Matchers.any(), (OrderedPropertyValues)Matchers.any());
    }

    @Test
    public void shouldUpdateIndexesOnRemovedProperty() throws EntityNotFoundException {
        this.indexTxUpdater.onPropertyRemove(this.state, this.node, Property.property((int)21, (Object)"hi2"));
        this.verifyIndexUpdate(this.uniqueOn1_2.schema(), this.node.id(), this.values("hi2"), null);
        this.verifyIndexUpdate(this.uniqueOn2_2_3.schema(), this.node.id(), this.values("hi2", "hi3"), null);
        ((TransactionState)Mockito.verify((Object)this.txState, (VerificationMode)Mockito.times((int)2))).indexDoUpdateEntry((LabelSchemaDescriptor)Matchers.any(), (long)Matchers.anyInt(), (OrderedPropertyValues)Matchers.any(), (OrderedPropertyValues)Matchers.any());
    }

    @Test
    public void shouldUpdateIndexesOnChangesProperty() throws EntityNotFoundException {
        this.indexTxUpdater.onPropertyChange(this.state, this.node, Property.property((int)21, (Object)"hi2"), Property.property((int)21, (Object)"new2"));
        this.verifyIndexUpdate(this.uniqueOn1_2.schema(), this.node.id(), this.values("hi2"), this.values("new2"));
        this.verifyIndexUpdate(this.uniqueOn2_2_3.schema(), this.node.id(), this.values("hi2", "hi3"), this.values("new2", "hi3"));
        ((TransactionState)Mockito.verify((Object)this.txState, (VerificationMode)Mockito.times((int)2))).indexDoUpdateEntry((LabelSchemaDescriptor)Matchers.any(), (long)Matchers.anyInt(), (OrderedPropertyValues)Matchers.any(), (OrderedPropertyValues)Matchers.any());
    }

    private OrderedPropertyValues values(Object ... values) {
        return OrderedPropertyValues.ofUndefined((Object[])values);
    }

    private void verifyIndexUpdate(LabelSchemaDescriptor schema, long nodeId, OrderedPropertyValues before, OrderedPropertyValues after) {
        ((TransactionState)Mockito.verify((Object)this.txState)).indexDoUpdateEntry((LabelSchemaDescriptor)Matchers.eq((Object)schema), Matchers.eq((long)nodeId), (OrderedPropertyValues)Matchers.eq((Object)before), (OrderedPropertyValues)Matchers.eq((Object)after));
    }
}

